package com.vhall.vhss.network;


import android.text.TextUtils;

import com.vhall.business.impl.VhssSimpleCallBack;
import com.vhall.httpclient.api.VHNetApi;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.api.CoreApiConstant;
import com.vhall.vhss.data.CardsInfoData;
import com.vhall.vhss.data.CommonConfigData;
import com.vhall.vhss.data.CouponInfoData;
import com.vhall.vhss.data.GiftListData;
import com.vhall.vhss.data.GoodsInfoData;
import com.vhall.vhss.data.GoodsOrderSetting;
import com.vhall.vhss.data.LotteryCheckData;
import com.vhall.vhss.data.LotteryPrizeData;
import com.vhall.vhss.data.LotteryPrizeListData;
import com.vhall.vhss.data.LotteryWinnerListData;
import com.vhall.vhss.data.LotteryWinningDetailData;
import com.vhall.vhss.data.LotteryWinningUserInfoData;
import com.vhall.vhss.data.OrderInfoData;
import com.vhall.vhss.data.PlayerConfigData;
import com.vhall.vhss.data.SurveyInfoData;
import com.vhall.vhss.data.TimerInfoData;
import com.vhall.vhss.netutils.CoreNetCallback;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;

/**
 * @author hkl
 * 互动工具
 */
public class InteractToolsNetworkRequest extends BaseNetwork {
    /**
     * 观看端-抽奖-获取中奖用户列表
     *
     * @param lottery_id 抽奖活动ID
     * @param room_id    房间id
     */
    public static void lotteryGetWinner(String room_id, String lottery_id, CallBack<LotteryWinnerListData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        params.put("lottery_id", lottery_id);

        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_USER_GET_LOTTERY), new CoreNetCallback<>(callBack, LotteryWinnerListData.class));
    }

    /**
     * 观看端-领奖页-获取信息
     *
     * @param webinar_id 房间id
     */
    public static void getPrizeInfo(String webinar_id, CallBack<ArrayList<LotteryPrizeListData>> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", webinar_id);

        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_PRIZE_INFO), new CoreNetCallback(callBack, new ArrayList<LotteryPrizeListData>() {
        }.getClass()));
    }

    /**
     * 观看端-领奖页-获取信息
     *
     * @param webinar_id 房间id
     */
    public static void getPrizeInfo(String webinar_id, String lottery_id,CallBack<LotteryPrizeData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", webinar_id);
        params.put("lottery_id", lottery_id);

        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_PRIZE_INFO1), new CoreNetCallback(callBack, LotteryPrizeData.class));
    }

    /**
     * 观看端-检查抽奖进行中
     */
    public static void lotteryCheck(CallBack<LotteryCheckData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_AWARD_CHECK), new CoreNetCallback(callBack, LotteryCheckData.class));
    }


    /**
     * 抽奖-立即参与
     *
     * @param lottery_id 抽奖活动ID
     * @param room_id    房间id
     */
    public static void lotteryJoin(String room_id, String lottery_id, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        params.put("lottery_id", lottery_id);

        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_JOIN_LOTTERY), new CoreNetCallback(callBack));
    }


    /**
     * @param room_id             房间id
     * @param lottery_id          抽奖活动ID
     * @param lottery_user_name   中奖人姓名
     * @param lottery_user_phone  中奖人手机号
     * @param lottery_user_remark 备注
     */
    public static void lotteryCommit(String room_id, String lottery_id, String lottery_user_name, String lottery_user_phone, String lottery_user_remark, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        params.put("lottery_id", lottery_id);
        params.put("lottery_user_name", lottery_user_name);
        params.put("lottery_user_phone", lottery_user_phone);
        params.put("lottery_user_remark", lottery_user_remark);

        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_AWARD_LOTTERY), new CoreNetCallback(callBack));
    }

    /**
     * 观看端-抽奖-获取中奖详情
     *
     * @param room_id    房间id
     * @param lottery_id 抽奖活动ID
     */
    public static void lotteryWinningDetail(String room_id, String lottery_id, CallBack<LotteryWinningDetailData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        params.put("lottery_id", lottery_id);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_AWARD_USER_DETAIL), new CoreNetCallback(callBack, LotteryWinningDetailData.class));
    }

    /**
     * 观看端-抽奖-查看之前提交过的中奖信息
     *
     * @param room_id 房间id
     */
    public static void lotteryWinningUserInfo(String room_id, CallBack<LotteryWinningUserInfoData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_AWARD_USER_INFO), new CoreNetCallback(callBack, LotteryWinningUserInfoData.class));
    }


    /**
     * 签到-用户进行签到
     *
     * @param sign_id 签到id
     * @param room_id 房间id
     */
    public static void signJoin(String room_id, String sign_id, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        params.put("sign_id", sign_id);

        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_USER_SIGN), new CoreNetCallback(callBack));
    }

    /**
     * 问卷 查询房间历史问卷
     *
     * @param room_id 房间id
     */
    public static void getHistorySurvey(String switchId, String room_id, String webinar_id, CallBack<ArrayList<SurveyInfoData>> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        params.put("webinar_id", webinar_id);
        params.put("switch_id", switchId);
        try {
            VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_HISTORY_SURVEY), new CoreNetCallback(callBack, new ArrayList<SurveyInfoData>() {
            }.getClass()));
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }


    /**
     * 观看端-检查抽奖列表接口
     *
     * @param show_all 是否需要展示所有抽奖 0-否(默认：仅展示进行中、已中奖抽奖) 1-是
     */
    public static void getHistoryLotteryList(String show_all, CallBack<ArrayList<LotteryCheckData>> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("show_all", show_all);
        try {
            VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_AWARD_CHECK_LIST), new CoreNetCallback(callBack, new ArrayList<LotteryCheckData>() {
            }.getClass()));
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    /**
     * 观看端-查询计时器进度
     */
    public static void getTimerInfo(CallBack<TimerInfoData> callBack) {
        try {
            VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(null), CoreApiConstant.API_TIMER_INFO), new CoreNetCallback(callBack, TimerInfoData.class));
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    /**
     * 观看端-用户点赞
     * 点赞次数，最多500，超过500会强制成为500
     */

    public static void userLike(String room_id, String num, CallBack callBack) {
        try {
            HashMap<String, String> params = new HashMap<>();
            params.put("room_id", room_id);
            params.put("num", num);
            VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_CREATE_USER_LIKE), new CoreNetCallback(callBack));
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }


    /**
     * 获取房间的点赞数量
     */

    public static void getRoomLike(String room_id, final CallBack<Integer> callBack) {
        try {
            HashMap<String, String> params = new HashMap<>();
            params.put("room_id", room_id);
            VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_ROOM_LIKE), new CoreNetCallback(new CallBack<String>() {
                @Override
                public void onSuccess(String result) {
                    try {
                        JSONObject objectResult = new JSONObject(result);
                        if (!TextUtils.isEmpty(objectResult.optString("data"))) {
                            JSONObject objectData = new JSONObject(objectResult.optString("data"));
                            int total = objectData.optInt("total");
                            if (callBack != null) {
                                callBack.onSuccess(total);
                            }
                        } else {
                            if (callBack != null) {
                                callBack.onError(-1, "no data");
                            }
                        }
                    } catch (Exception e) {
                        if (callBack != null) {
                            callBack.onError(-1, e.getMessage());
                        }
                    }
                }

                @Override
                public void onError(int eventCode, String msg) {
                    if (callBack != null) {
                        callBack.onError(eventCode, msg);
                    }
                }
            }));
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }


    /**
     * 观看端-获取用户点赞总数量
     */

    public static void getAllLike(final CallBack<Integer> callBack) {
        try {
            HashMap<String, String> params = new HashMap<>();
            VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_ALL_LIKE), new CoreNetCallback(new CallBack<String>() {
                @Override
                public void onSuccess(String result) {
                    try {
                        JSONObject objectResult = new JSONObject(result);
                        if (!TextUtils.isEmpty(objectResult.optString("data"))) {
                            JSONObject objectData = new JSONObject(objectResult.optString("data"));
                            int total = objectData.optInt("total");
                            if (callBack != null) {
                                callBack.onSuccess(total);
                            }
                        } else {
                            if (callBack != null) {
                                callBack.onError(-1, "no data");
                            }
                        }
                    } catch (Exception e) {
                        if (callBack != null) {
                            callBack.onError(-1, e.getMessage());
                        }
                    }
                }

                @Override
                public void onError(int eventCode, String msg) {
                    if (callBack != null) {
                        callBack.onError(eventCode, msg);
                    }
                }
            }));
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    /**
     * 观看端_获取活动使用的礼物列表
     */

    public static void getGiftList(String room_id, CallBack<GiftListData> callBack) {
        try {
            HashMap<String, String> params = new HashMap<>();
            params.put("room_id", room_id);
            VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_GIFT_LIST), new CoreNetCallback(callBack, GiftListData.class));
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    /**
     * 观看端_发送礼物给主持人
     *
     * @param room_id      lss
     * @param gift_id      礼物ID
     * @param channel      支付渠道 WEIXIN
     * @param service_code 支付方式 QR_PAY
     * @param open_id      当支付方式为JSAPI的时候必传
     */

    public static void sendGift(String room_id, String gift_id, String channel, String service_code, String open_id, CallBack callBack) {
        try {
            HashMap<String, String> params = new HashMap<>();
            params.put("room_id", room_id);
            params.put("gift_id", gift_id);
            params.put("channel", channel);
            params.put("service_code", service_code);
            if (!TextUtils.isEmpty(open_id)) {
                params.put("open_id", open_id);
            }
            VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_SEND_GIFT), new CoreNetCallback(callBack));
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    /**
     * @param phone 手机号
     * @param code  验证码（非必穿 根据控制台控制）
     */

    public static void wechatSubmit(String webinar_id, String phone, String code, CallBack callBack) {
        try {
            HashMap<String, String> params = new HashMap<>();
            params.put("webinar_id", webinar_id);
            params.put("phone", phone);
            if (!TextUtils.isEmpty(code))
                params.put("code", code);
            VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_INTERACTS_NOTICE_WECHAT_SUBMIT), new CoreNetCallback(callBack));
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    /*
     * 获取推屏卡片
     * http://yapi.vhall.domain/project/101/interface/api/56860
     */
    public static void getCardList(String webinar_id, String switch_id, int curr_page, int page_size, CallBack<CardsInfoData> callBack) {
        try {
            HashMap<String, String> params = new HashMap<>();
            params.put("webinar_id", webinar_id);
            params.put("switch_id", switch_id);
            params.put("curr_page", curr_page+"");
            params.put("page_size", page_size+"");
            VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_SCREEN_CARD_LIST), new CoreNetCallback(callBack, CardsInfoData.class));
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }
    /*
     *  获取卡片信息
     * id	卡片id
     */
    public static void getCardInfo(String webinar_id,String card_id, CallBack<CardsInfoData.CardInfo> callBack){
        try {
            HashMap<String, String> params = new HashMap<>();
            params.put("webinar_id", webinar_id);
            params.put("id", card_id);
            VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_SCREEN_CARD_INFO), new CoreNetCallback(callBack, CardsInfoData.CardInfo.class));
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }
    /*
     *  上报卡片点击事件 用于卡片点击统计
     *
     */
    public static void cardClicked(String webinar_id, String switch_id,String card_id, CallBack<String> callBack){
        try {
            HashMap<String, String> params = new HashMap<>();
            params.put("webinar_id", webinar_id);
            params.put("card_id", card_id);
            params.put("switch_id", switch_id);
            VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_SCREEN_CARD_CLICKED), new CoreNetCallback(callBack, null));
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    /**
     * 商品列表
     *
     */
    public static void getGoodsList(String webinar_id,int status,  CallBack<ArrayList<GoodsInfoData.GoodsInfo>> callBack) {
        try {
            HashMap<String, String> params = new HashMap<>();
            params.put("status", status+"");
            VHNetApi.getNetApi().doPost(getBaseRequestGET(getSignParam(params), CoreApiConstant.API_SALE_GOODS_LIST), new CoreNetCallback(callBack, new ArrayList<GoodsInfoData.GoodsInfo>() {
            }.getClass()));
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    /**
     * 获取上架商品详情
     *
     * @param goods_id 商品id
     */
    public static void getGoodsInfo(String goods_id, CallBack<GoodsInfoData.GoodsInfo> callBack) {
        try {
            HashMap<String, String> params = new HashMap<>();
            params.put("goods_id", goods_id);
            VHNetApi.getNetApi().doPost(getBaseRequestGET(getSignParam(params), CoreApiConstant.API_SALE_GOODS_INFO), new CoreNetCallback(callBack, GoodsInfoData.GoodsInfo.class));
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    /**
     * 获取活动下商品订单提交信息设置项
     *
     * @param webinar_id 商品id
     */
    public static void getGoodsOrderSetting(String webinar_id, CallBack<GoodsOrderSetting> callBack) {
        try {
            HashMap<String, String> params = new HashMap<>();
            params.put("webinar_id", webinar_id);
            VHNetApi.getNetApi().doPost(getBaseRequestGET(getSignParam(params), CoreApiConstant.API_GOODS_ORDER_SETTING), new CoreNetCallback(callBack, GoodsOrderSetting.class));
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }
    /**
     * 查询商户号绑定列表
     *
     * @param webinar_id 商品id
     */
    public static void getGoodsPartnerList(String webinar_id, CallBack<String> callBack) {
        try {
            HashMap<String, String> params = new HashMap<>();
            params.put("webinar_id", webinar_id);
            VHNetApi.getNetApi().doPost(getBaseRequestGET(getSignParam(params), CoreApiConstant.API_GOODS_PARTNER_LIST), new CoreNetCallback(callBack, String.class));
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }
    /**
     * 创建订单
     *
     * @param
     */
    public static void goodsOrderCreate(JSONObject params, CallBack<OrderInfoData> callBack) throws JSONException {
        VHNetApi.getNetApi().doPost(getJsonBaseRequest(getJsonSignParam(params), CoreApiConstant.API_GOODS_ORDER_CREATE), new CoreNetCallback(callBack, OrderInfoData.class));
    }

    /**
     * 活动订单信息
     * http://yapi.vhall.domain/project/1285/interface/api/58016
     * @param
     */
    public static void getGoodsOrderInfo(String order_no, CallBack<OrderInfoData> callBack) {
        try {
            JSONObject params = new JSONObject();
            params.put("order_no", order_no);
            VHNetApi.getNetApi().doPost(getJsonBaseRequest(getJsonSignParam(params), CoreApiConstant.API_GOODS_MY_ORDER_INFO), new CoreNetCallback(callBack, OrderInfoData.class));
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }


    /**
     * 可用优惠券列表
     * <p>
     * http://yapi.vhall.domain/project/1285/interface/api/58709
     */
    public static void getCouponAvailableList(String webinar_id,String goods_id,Integer goods_num, CallBack<ArrayList<CouponInfoData.CouponItem>> callBack) {
        try {
            JSONObject params = new JSONObject();
            params.put("webinar_id", webinar_id);
            params.put("goods_id", goods_id);
            params.put("goods_num", goods_num);
            VHNetApi.getNetApi().doPost(getJsonBaseRequest(getJsonSignParam(params), CoreApiConstant.API_COUPON_AVAILABLE_LIST), new CoreNetCallback(callBack,  new ArrayList<CouponInfoData.CouponItem>() {
            }.getClass()));
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }

    /**
     * 不可用优惠券列表
     * <p>
     * http://yapi.vhall.domain/project/1285/interface/api/58716
     */
    public static void getCouponUnavailableList(String webinar_id,String goods_id,Integer goods_num,  CallBack<ArrayList<CouponInfoData.CouponItem>> callBack) {
        try {
            JSONObject params = new JSONObject();
            params.put("webinar_id", webinar_id);
            params.put("goods_id", goods_id);
            params.put("goods_num", goods_num);
            VHNetApi.getNetApi().doPost(getJsonBaseRequest(getJsonSignParam(params), CoreApiConstant.API_COUPON_UNAVAILABLE_LIST), new CoreNetCallback(callBack,  new ArrayList<CouponInfoData.CouponItem>() {
            }.getClass()));
        } catch (Exception e) {
            if (callBack != null) {
                callBack.onError(-1, e.getMessage());
            }
        }
    }
}
