package com.vhall.vhss.network;


import android.text.TextUtils;

import com.vhall.httpclient.api.VHNetApi;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.api.CoreApiConstant;
import com.vhall.vhss.data.VhssUserInfoData;
import com.vhall.vhss.netutils.CoreNetCallback;

import java.util.HashMap;

import static com.vhall.vhss.api.CoreApiConstant.API_PLATFORM;

/**
 * @author hkl
 * 互动 相关
 */
public class InteractNetworkRequest extends BaseNetwork {
    /**
     * 设置主讲人
     *
     * @param room_id            房间id
     * @param receive_account_id 被选择者的参会id
     */
    public static void setMainScreen(String room_id, String receive_account_id, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        params.put("receive_account_id", receive_account_id);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_SET_MAIN_SCREEN), new CoreNetCallback(callBack));
    }


    /**
     * 设置房间举手状态
     *
     * @param room_id 房间id
     * @param status  举手状态 1允许0禁止
     */
    public static void setHandsUp(String room_id, String status, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        params.put("status", status);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_SET_HANDS_UP), new CoreNetCallback(callBack, VhssUserInfoData.class));

    }

    /**
     * 设置房间举手状态
     *
     * @param room_id 房间id
     * @param status  举手状态 1允许0禁止
     *                纠正之间接口命名问题 替换成 setHandsUp
     */
    @Deprecated
    public static void guestJoinWebinar(String room_id, String status, CallBack callBack) {
        setHandsUp(room_id, status, callBack);
    }

    /**
     * 用户举手申请上麦
     *
     * @param room_id 房间id
     */
    public static void apply(String room_id, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_APPLY), new CoreNetCallback(callBack, VhssUserInfoData.class));
    }

    /**
     * 用户取消申请上麦
     *
     * @param room_id 房间id
     */
    public static void cancelApply(String room_id, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_CANCEL_APPLY), new CoreNetCallback(callBack, VhssUserInfoData.class));
    }

    /**
     * 允许用户上麦
     *
     * @param room_id            房间id
     * @param receive_account_id 参会用户的uid
     */
    public static void agreeApply(String room_id, String receive_account_id, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        params.put("receive_account_id", receive_account_id);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_AGREE_APPLY), new CoreNetCallback(callBack, VhssUserInfoData.class));
    }

    /**
     * 拒绝用户上麦
     *
     * @param room_id            房间id
     * @param receive_account_id 参会用户的uid
     */
    public static void rejectApply(String room_id, String receive_account_id, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        params.put("receive_account_id", receive_account_id);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_REJECT_APPLY), new CoreNetCallback(callBack, VhssUserInfoData.class));
    }

    /**
     * 用户上麦
     *
     * @param room_id 房间id
     */
    public static void speak(String room_id, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_USER_SPEAK), new CoreNetCallback(callBack, VhssUserInfoData.class));
    }

    /**
     * 用户下麦
     *
     * @param room_id 房间id
     */
    public static void ownerNoSpeak(String room_id, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_OWNER_NO_SPEAK), new CoreNetCallback(callBack, VhssUserInfoData.class));
    }

    /**
     * 邀请用户上麦
     *
     * @param room_id            房间id
     * @param receive_account_id 被邀请用户的参会用户的uid
     */
    public static void inviteUserSpeak(String room_id, String receive_account_id, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        params.put("receive_account_id", receive_account_id);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_INVITE), new CoreNetCallback(callBack, VhssUserInfoData.class));
    }

    /**
     * 用户同意上麦邀请
     *
     * @param room_id 房间id
     */
    public static void agreeInvite(String room_id, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_AGREE_INVITE), new CoreNetCallback(callBack, VhssUserInfoData.class));
    }

    /**
     * 用户拒绝上麦邀请
     *
     * @param room_id 房间id
     */
    public static void rejectInvite(String room_id, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_REJECT_INVITE), new CoreNetCallback(callBack, VhssUserInfoData.class));
    }

    /**
     * 设置房间内已上麦用户下麦
     *
     * @param room_id            房间id
     * @param receive_account_id 被下麦的用户的参会用户的uid
     */
    public static void onSpeak(String room_id, String receive_account_id, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        params.put("receive_account_id", receive_account_id);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_NO_SPEAK), new CoreNetCallback(callBack, VhssUserInfoData.class));
    }

    /**
     * 设置房间设备状态
     *
     * @param room_id            房间id
     * @param receive_account_id 被下麦的用户的参会用户的uid
     * @param device             1麦克风，2摄像头
     * @param status             0关闭1打开
     */
    public static void setDeviceStatus(String room_id, String receive_account_id, String device, String status, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", TextUtils.isEmpty(room_id) ? "" : room_id);
        params.put("receive_account_id", receive_account_id);
        params.put("device", TextUtils.isEmpty(device) ? "" : device);
        params.put("status", TextUtils.isEmpty(status) ? "" : status);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_SET_DEVICE_STATUS), new CoreNetCallback(callBack));
    }


    /**
     * 设置房间用户的设备检测状态
     *
     * @param room_id 房间id
     * @param status  设备检测状态，0未检测1可以上麦2不可以上麦
     *                type  设备类型:    设备类型，0未检测 1手机端 2 PC 3 SDK
     */
    public static void setDevice(String room_id, String status, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", TextUtils.isEmpty(room_id) ? "" : room_id);
        if (TextUtils.equals(API_PLATFORM, "5")) {
            params.put("type", "3");
        } else {
            params.put("type", "1");
        }
        params.put("status", TextUtils.isEmpty(status) ? "" : status);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_SET_DEVICE), new CoreNetCallback(callBack));
    }
}
