package com.vhall.vhss.network;

import android.text.TextUtils;

import com.vhall.httpclient.api.VHNetApi;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.api.CoreApiConstant;
import com.vhall.vhss.data.ExamAnswerPaperHistoryData;
import com.vhall.vhss.data.ExamInfoData;
import com.vhall.vhss.data.ExamListData;
import com.vhall.vhss.data.ExamRankListData;
import com.vhall.vhss.data.ExamScoreInfoData;
import com.vhall.vhss.data.ExamUserFormCheckData;
import com.vhall.vhss.data.ExamUserFormData;
import com.vhall.vhss.data.WebinarinfoListData;
import com.vhall.vhss.netutils.CoreNetCallback;

import java.util.HashMap;

/**
 * @author hkl
 * Date: 2022/11/15 11:01
 */
public class ExamNetworkRequest extends BaseNetwork {

    /**
     * 答题前置条件检查
     */
    public static void examUserFormCheck(String webinar_id, String user_name, String head_img, String mobile, CallBack<ExamUserFormCheckData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", webinar_id);
        if (!TextUtils.isEmpty(user_name))
            params.put("user_name", user_name);
        if (!TextUtils.isEmpty(head_img))
            params.put("head_img", head_img);
        if (!TextUtils.isEmpty(mobile))
            params.put("mobile", mobile);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_INTERACTS_EXAM_USER_FORM_CHECK), new CoreNetCallback(callBack, ExamUserFormCheckData.class));
    }

    /**
     * 观看端-初始化用户表单
     */
    public static void examGetUserFormInfo(String webinar_id, String paper_id, CallBack<ExamUserFormData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", webinar_id);
        params.put("paper_id", paper_id);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_INTERACTS_EXAM_GET_USER_FORM_INFO), new CoreNetCallback(callBack, ExamUserFormData.class));
    }

    /**
     * 发送验证码
     */
    public static void examSendVerifyCode(String webinar_id, String phone, String country_code, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", webinar_id);
        params.put("phone", phone);
        params.put("msg_template_id", "a6f7552d669145f999b77a462f62b3f5");
        params.put("msg_sign_id", "d54a2a1e59a54dc5bfdd9c74822e9974");
        if (TextUtils.isEmpty(country_code))
            params.put("country_code", "CN");
        else
            params.put("country_code", country_code);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_INTERACTS_EXAM_SEND_VERIFY_CODE), new CoreNetCallback(callBack));
    }

    /**
     * 验证验证码
     */
    public static void examVerifyCode(String webinar_id, String paper_id, String phone, String verify_code, String country_code, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", webinar_id);
        params.put("phone", phone);
        params.put("paper_id", paper_id);
        params.put("verify_code", verify_code);
        if (TextUtils.isEmpty(country_code))
            params.put("country_code", "CN");
        else
            params.put("country_code", country_code);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_INTERACTS_EXAM_VERIFY_CODE), new CoreNetCallback(callBack));
    }

    /**
     * 保存用户表单信息
     */
    public static void examSaveUserForm(String webinar_id, String paper_id, String user_detail, String verify_code, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", webinar_id);
        params.put("paper_id", paper_id);
        params.put("user_detail", user_detail);
        if (!TextUtils.isEmpty(verify_code))
            params.put("verify_code", verify_code);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_INTERACTS_EXAM_SAVE_USER_FORM), new CoreNetCallback(callBack));
    }

    /**
     * 获取场次已推送试卷列表
     */
    public static void examGetPushedPaperList(String webinar_id, String switch_id, CallBack<ExamListData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", webinar_id);
        params.put("switch_id", switch_id);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_INTERACTS_EXAM_GET_PUSHED_PAPER_LIST), new CoreNetCallback(callBack, ExamListData.class));
    }

    /**
     * 获取试卷详情
     */
    public static void examGetPaperInfoForWatch(String webinar_id, String paper_id, CallBack<ExamInfoData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", webinar_id);
        params.put("paper_id", paper_id);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_INTERACTS_EXAM_GET_PAPER_INFO_FOR_WATCH), new CoreNetCallback(callBack, ExamInfoData.class));
    }


    /**
     * 单题提交
     */
    public static void examAnswerQuestion(String webinar_id, String paper_id, String user_answer, String question_id, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", webinar_id);
        params.put("paper_id", paper_id);
        params.put("user_answer", user_answer);
        params.put("question_id", question_id);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_INTERACTS_EXAM_ANSWER_QUESTION), new CoreNetCallback(callBack));
    }

    /**
     * 主动交卷
     */
    public static void examInitiativeSubmitPaper(String webinar_id, String paper_id, CallBack<WebinarinfoListData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", webinar_id);
        params.put("paper_id", paper_id);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_INTERACTS_EXAM_INITIATIVE_SUBMIT_PAPER), new CoreNetCallback(callBack, WebinarinfoListData.class));
    }

    /**
     * 获取已答题记录断点续答
     */
    public static void examGetUserAnswerPaperHistory(String webinar_id, String paper_id, CallBack<ExamAnswerPaperHistoryData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", webinar_id);
        params.put("paper_id", paper_id);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_INTERACTS_EXAM_GET_USER_ANSWER_PAPER_HISTORY), new CoreNetCallback(callBack, ExamAnswerPaperHistoryData.class));
    }

    /**
     * 获取榜单信息
     */
    public static void examGetSimpleRankList(String webinar_id, String paper_id, String pos, String limit, CallBack<ExamRankListData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", webinar_id);
        params.put("paper_id", paper_id);
        params.put("pos", pos);
        params.put("limit", limit);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_INTERACTS_EXAM_GET_SIMPLE_RANK_LIST), new CoreNetCallback(callBack, ExamRankListData.class));
    }

    /**
     * 获取个人成绩
     */
    public static void examPersonScoreInfo(String webinar_id, String paper_id, CallBack<ExamScoreInfoData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("webinar_id", webinar_id);
        params.put("paper_id", paper_id);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_INTERACTS_EXAM_PERSON_SCORE_INFO), new CoreNetCallback(callBack, ExamScoreInfoData.class));
    }
}