package com.vhall.vhss.network;

import android.text.TextUtils;

import com.vhall.httpclient.api.VHNetApi;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.api.CoreApiConstant;
import com.vhall.vhss.data.ChatListData;
import com.vhall.vhss.data.QuestionHistoryListData;
import com.vhall.vhss.data.UserStateListData;
import com.vhall.vhss.data.VhssUserInfoData;
import com.vhall.vhss.netutils.CoreNetCallback;

import java.util.HashMap;
import java.util.logging.XMLFormatter;

/**
 * @author hkl
 * 活动 相关
 */
public class ChatNetworkRequest extends BaseNetwork {


    public static void chatGetList(String room_id, int pos, int limit, CallBack<ChatListData> callBack) {
        chatGetList(room_id, pos, limit, "", "", "", callBack);
    }

    /**
     * 获取当前房间聊天列表
     *
     * @param room_id     房间id
     * @param pos         获取条目节点，默认为0
     * @param limit       获取条目数量，最大100
     * @param msg_id      获取条目数量，聊天记录 锚点消息id,此参数存在时anchor_path 参数必须存在
     * @param anchor_path 锚点方向，up 向上查找，down 向下查找,此参数存在时 msg_id 参数必须存在
     * @param is_role     0：不筛选主办方 1：筛选主办方 默认是0
     */
    public static void chatGetList(String room_id, int pos, int limit, String msg_id, String anchor_path, String is_role, CallBack<ChatListData> callBack) {
        HashMap<String, String> params = new HashMap<>();

        params.put("room_id", room_id);
        if (pos == 0) {
            if (callBack != null) {
                callBack.onError(-1, "页码从1开始");
            }
            return;
        }
        limit = limit == 0 ? 10 : limit;
        params.put("limit", String.valueOf(limit));
        if (!TextUtils.isEmpty(msg_id)) {
            params.put("msg_id", msg_id);
            params.put("anchor_path", TextUtils.isEmpty(anchor_path) ? "up" : anchor_path);
        } else {
            params.put("pos", String.valueOf((pos - 1) * limit));
        }
        if (!TextUtils.isEmpty(is_role)) {
            params.put("is_role", is_role);
        }
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_CHAT_GET_LIST), new CoreNetCallback(callBack, ChatListData.class));
    }

    /**
     * 发送自定义消息
     *
     * @param room_id    房间id
     * @param channel_id 频道
     * @param body       消息内容
     *                   client       pc_browser,h5_browser,android,ios,desktop,wechat_browser,wechat_applet
     */
    public static void sendCustomMessage(String room_id, String channel_id, String body, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        params.put("channel_id", channel_id);
        params.put("body", body);
        params.put("client", "android");
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_SEND_CUSTOM_MESSAGE), new CoreNetCallback(callBack, VhssUserInfoData.class));
    }

    /**
     * 把用户踢出/恢复观看页
     *
     * @param room_id            房间id
     * @param channel_id         频道
     * @param status             1踢出 0取消踢出
     * @param receive_account_id 参会用户的uid
     */
    public static void setKicked(String room_id, String channel_id, String receive_account_id, String status, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        params.put("channel_id", channel_id);
        params.put("status", status);
        params.put("receive_account_id", receive_account_id);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_SET_KICKED), new CoreNetCallback(callBack, VhssUserInfoData.class));
    }

    /**
     * 设置/取消用户禁言
     *
     * @param room_id            房间id
     * @param channel_id         频道
     * @param status             1踢出 0取消踢出
     * @param receive_account_id 参会用户的uid
     */
    public static void setBanned(String room_id, String channel_id, String receive_account_id, String status, CallBack callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        params.put("channel_id", channel_id);
        params.put("status", status);
        params.put("receive_account_id", receive_account_id);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_SET_BANNED), new CoreNetCallback(callBack, VhssUserInfoData.class));
    }

    /**
     * 获取在线用户列表
     *
     * @param room_id 房间id
     * @param page    获取条目节点，默认为1
     * @param limit   获取条目数量，最大100
     *                nickname 用户昵称  可以添加
     */
    public static void chatOnlineList(String room_id, int page, int limit, CallBack<UserStateListData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        if (page == 0) {
            if (callBack != null) {
                callBack.onError(-1, "页码从1开始");
            }
            return;
        }
        limit = limit == 0 ? 10 : limit;
        params.put("pos", String.valueOf((page - 1) * limit));
        params.put("limit", String.valueOf(limit));
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_ONLINE_LIST), new CoreNetCallback(callBack, UserStateListData.class));
    }

    /**
     * 获取受限用户列表
     *
     * @param room_id 房间id
     * @param pos     获取条目节点，默认为0
     * @param limit   获取条目数量，最大100
     *                nickname 用户昵称  可以添加
     */
    public static void chatSpecialList(String room_id, int pos, int limit, CallBack<UserStateListData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        if (pos == 0) {
            if (callBack != null) {
                callBack.onError(-1, "页码从1开始");
            }
            return;
        }
        limit = limit == 0 ? 10 : limit;
        params.put("pos", String.valueOf((pos - 1) * limit));
        params.put("limit", String.valueOf(limit));
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_SPECIAL_LIST), new CoreNetCallback(callBack, UserStateListData.class));
    }

    /**
     * 获取当前B端用户所有的关键词
     *
     * @param room_id 房间id
     */
    public static void getKeyword(String room_id, CallBack<String> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_KEYWORD), new CoreNetCallback(callBack));
    }

    /**
     * 观看端_提交一个提问
     *
     * @param room_id 房间id
     */
    public static void submitQuestion(String room_id, String content, CallBack<String> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        params.put("content", content);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_SUBMIT_QUESTION), new CoreNetCallback(callBack));
    }

    /**
     * 观看端_获取当前活动的历史问答记录
     *
     * @param room_id 房间id
     */
    public static void getQuestionHistory(String room_id, CallBack<QuestionHistoryListData> callBack) {
        HashMap<String, String> params = new HashMap<>();
        params.put("room_id", room_id);
        VHNetApi.getNetApi().doPost(getBaseRequest(getSignParam(params), CoreApiConstant.API_GET_QUESTION_HISTORY), new CoreNetCallback(callBack, QuestionHistoryListData.class));
    }
}
