package com.vhall.vhss.network;

import android.text.TextUtils;

import com.vhall.httpclient.core.IVHRequest;
import com.vhall.vhss.TokenManger;
import com.vhall.vhss.api.CoreApiConstant;
import com.vhall.vhss.api.CoreNetApi;
import com.vhall.vhss.netutils.EncryptionUtil;
import com.vhall.vhss.netutils.Md5Encode;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.UUID;

import static com.vhall.vhss.api.CoreApiConstant.API_PLATFORM;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;


/**
 * @author hkl
 * Date: 2019-06-25 13:49
 */
public class BaseNetwork {

    public static String createVssUrl(String api) {
        if (api.contains("http")) {
            return api;
        }
        return String.format("%s%s%s", CoreApiConstant.API_HOST, CoreApiConstant.API_AREA, api);
    }

    static HashMap<String, String> getSignParam(HashMap<String, String> params) {
        HashMap<String, String> param = params == null ? new HashMap<String, String>() : params;
        param.put("signed_at", String.valueOf(System.currentTimeMillis() / 1000));
        if (TextUtils.equals(API_PLATFORM, "5")) {
            param.putAll(CoreNetApi.getNet().getHashMap());
            param.put("sign_type", TokenManger.getSignType());
        }
        return getParam(param);
    }

    private final static String PKG_KEY = "package_name";//包名key
    private final static String SIGNATURE_KEY = "signature";//签名key

    private static HashMap<String, String> getParam(HashMap<String, String> params) {
        String[] key = params.keySet().toArray(new String[0]);
        Arrays.sort(key);

        String param = "";
        //无包名签名参数
        String withOutExtraParam = "";
        for (String k : key) {
            param = param + k + params.get(k);
            //附加参数不参与计算
            if (TextUtils.equals(PKG_KEY, k) || TextUtils.equals(SIGNATURE_KEY, k)) {
                continue;
            }
            withOutExtraParam = withOutExtraParam + k + params.get(k);
        }

        if (!TextUtils.isEmpty(CoreApiConstant.SECRET_KEY) && !TextUtils.equals(TokenManger.getSignType(), "1")) {
            param = String.format("%s%s%s", CoreApiConstant.SECRET_KEY, param, CoreApiConstant.SECRET_KEY);
            withOutExtraParam = String.format("%s%s%s", CoreApiConstant.SECRET_KEY, withOutExtraParam, CoreApiConstant.SECRET_KEY);
        }
        String sign = "";
        //无包名签名
        String sign_special = "";
        if (TextUtils.equals(TokenManger.getSignType(), "1") && TextUtils.equals(API_PLATFORM, "5")) {//RSA
            sign = EncryptionUtil.encrypt(Md5Encode.getMD5(param));
            sign_special = EncryptionUtil.encrypt(Md5Encode.getMD5(withOutExtraParam));
        } else if (TextUtils.equals(TokenManger.getSignType(), "2") && TextUtils.equals(API_PLATFORM, "5")) {//SHA256
            sign = EncryptionUtil.SHA256Signature(param);
            sign_special = EncryptionUtil.SHA256Signature(withOutExtraParam);
        } else if (TextUtils.equals(TokenManger.getSignType(), "3") && TextUtils.equals(API_PLATFORM, "5")) {//SM3
            try {
                sign = EncryptionUtil.sm3Signature(param);
                sign_special = EncryptionUtil.sm3Signature(withOutExtraParam);
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {//MD5
            sign = Md5Encode.getMD5(param);
            sign_special = Md5Encode.getMD5(withOutExtraParam);
//            params.put("interact_token", TokenManger.getInteractToken());
        }
        params.put("sign", sign);
        params.put("sign_special", sign_special);
        if (params.containsKey(PKG_KEY)) {
            params.remove(PKG_KEY);
        }
        if (params.containsKey("signature")) {
            params.remove("signature");
        }
        if (TextUtils.equals(API_PLATFORM, "1")) {
            params.putAll(CoreNetApi.getNet().getHashMap());
        }
        return params;
    }

    static JSONObject getJsonSignParam(JSONObject params) throws JSONException {
        params.put("signed_at", String.valueOf(System.currentTimeMillis() / 1000));

        if (TextUtils.equals(API_PLATFORM, "5")) {
            HashMap<String, String> map = CoreNetApi.getNet().getHashMap();
            // 遍历
            for (HashMap.Entry<String, String> entry : map.entrySet()) {
                params.put(entry.getKey(),entry.getValue());
            }
            params.put("sign_type", TokenManger.getSignType());
        }
        return getJsonParam(params);
    }
    private static JSONObject getJsonParam(JSONObject params) throws JSONException {
        Iterator<String> keys = params.keys();
        ArrayList<String> list = new ArrayList<String>();
        while (keys.hasNext()) {
            list.add(keys.next());
        }
        Collections.sort(list);

        String param = "";
        //无包名签名参数
        String withOutExtraParam = "";
        for (String k : list) {
            Object object = params.get(k);
            String value = "";
            if(!(object instanceof JSONObject || object instanceof JSONArray))
                value = params.optString(k);

            param = param + k + value;
            //附加参数不参与计算
            if (TextUtils.equals(PKG_KEY, k) || TextUtils.equals(SIGNATURE_KEY, k)) {
                continue;
            }
            withOutExtraParam = withOutExtraParam + k +value;
        }

        if (!TextUtils.isEmpty(CoreApiConstant.SECRET_KEY) && !TextUtils.equals(TokenManger.getSignType(), "1")) {
            param = String.format("%s%s%s", CoreApiConstant.SECRET_KEY, param, CoreApiConstant.SECRET_KEY);
            withOutExtraParam = String.format("%s%s%s", CoreApiConstant.SECRET_KEY, withOutExtraParam, CoreApiConstant.SECRET_KEY);
        }
        String sign = "";
        //无包名签名
        String sign_special = "";
        if (TextUtils.equals(TokenManger.getSignType(), "1") && TextUtils.equals(API_PLATFORM, "5")) {//RSA
            sign = EncryptionUtil.encrypt(Md5Encode.getMD5(param));
            sign_special = EncryptionUtil.encrypt(Md5Encode.getMD5(withOutExtraParam));
        } else if (TextUtils.equals(TokenManger.getSignType(), "2") && TextUtils.equals(API_PLATFORM, "5")) {//SHA256
            sign = EncryptionUtil.SHA256Signature(param);
            sign_special = EncryptionUtil.SHA256Signature(withOutExtraParam);
        } else if (TextUtils.equals(TokenManger.getSignType(), "3") && TextUtils.equals(API_PLATFORM, "5")) {//SM3
            try {
                sign = EncryptionUtil.sm3Signature(param);
                sign_special = EncryptionUtil.sm3Signature(withOutExtraParam);
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {//MD5
            sign = Md5Encode.getMD5(param);
            sign_special = Md5Encode.getMD5(withOutExtraParam);
//            params.put("interact_token", TokenManger.getInteractToken());
        }
        params.put("sign", sign);
        params.put("sign_special", sign_special);
        if (params.get(PKG_KEY) != null ) {
            params.remove(PKG_KEY);
        }
        if (params.get("signature") != null ) {
            params.remove("signature");
        }
        if (TextUtils.equals(API_PLATFORM, "1")) {
            HashMap<String, String> map = CoreNetApi.getNet().getHashMap();
            // 遍历
            for (HashMap.Entry<String, String> entry : map.entrySet()) {
                params.put(entry.getKey(),entry.getValue());
            }
        }
        return params;
    }



    static IVHRequest getBaseRequest(HashMap<String, String> params, String apiUrl) {
        String time_zone;
        try {
            Calendar cal = Calendar.getInstance();
            TimeZone tz = cal.getTimeZone();
            time_zone = tz.getID();
        } catch (Exception e) {
            e.printStackTrace();
            time_zone = "";
        }
        IVHRequest.Builder builder = new IVHRequest.Builder();
        builder.setUrl(createVssUrl(apiUrl))
                .addHeader("platform", API_PLATFORM)
                .addHeader("interact-token", TokenManger.getInteractToken())
                .addHeader("request-id", UUID.randomUUID().toString())
                .addHeader("gray-id", TextUtils.isEmpty(TokenManger.getGrayId()) ? "" : TokenManger.getGrayId())
                .addFormParas(params);

        builder.addHeader("token", TokenManger.getToken());
        if (!TextUtils.isEmpty(time_zone))
            builder.addHeader("zone", time_zone);
        return builder.addFormParas(params).build();
    }

    static IVHRequest getBaseRequestGET(HashMap<String, String> params, String apiUrl) {
        String time_zone;
        try {
            Calendar cal = Calendar.getInstance();
            TimeZone tz = cal.getTimeZone();
            time_zone = tz.getID();
        } catch (Exception e) {
            e.printStackTrace();
            time_zone = "";
        }

        String[] key = params.keySet().toArray(new String[0]);
        Arrays.sort(key);
        String param = "";
        for (String k : key) {
            param = param + k + "=" + params.get(k) + "&";
        }

        IVHRequest.Builder builder = new IVHRequest.Builder();
        builder.setUrl(createVssUrl(apiUrl)+"?"+param)
                .addHeader("platform", API_PLATFORM)
                .addHeader("interact-token", TokenManger.getInteractToken())
                .addHeader("request-id", UUID.randomUUID().toString())
                .addHeader("gray-id", TextUtils.isEmpty(TokenManger.getGrayId()) ? "" : TokenManger.getGrayId());

        builder.addHeader("token", TokenManger.getToken());
        if (!TextUtils.isEmpty(time_zone))
            builder.addHeader("zone", time_zone);
        return builder.build();
    }

    static IVHRequest getJsonBaseRequest(JSONObject params, String apiUrl) {
        String time_zone;
        try {
            Calendar cal = Calendar.getInstance();
            TimeZone tz = cal.getTimeZone();
            time_zone = tz.getID();
        } catch (Exception e) {
            e.printStackTrace();
            time_zone = "";
        }
        IVHRequest.Builder builder = new IVHRequest.Builder();
        builder.setUrl(createVssUrl(apiUrl))
                .addHeader("platform", API_PLATFORM)
                .addHeader("interact-token", TokenManger.getInteractToken())
                .addHeader("request-id", UUID.randomUUID().toString())
                .addHeader("gray-id", TextUtils.isEmpty(TokenManger.getGrayId()) ? "" : TokenManger.getGrayId())
                .setJson(params);

        builder.addHeader("token", TokenManger.getToken());
        if (!TextUtils.isEmpty(time_zone))
            builder.addHeader("zone", time_zone);
        return builder.setJson(params).build();
    }
}
