package com.vhall.vhss.netutils;


import android.text.TextUtils;

import org.json.JSONArray;
import org.json.JSONObject;

import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

/**
 * 解析json
 */
public class VHJSON {
    public static <T> T parseObject(String json, Class<T> clz) {
        if(TextUtils.isEmpty(json))
            return null;
        try {
            //for list
            if (checkList(clz)) {
                T innerClz = handleListObject(json, clz);
                if (innerClz != null) return innerClz;
            } else {
                Constructor constructor = clz.getConstructor(JSONObject.class);
                constructor.setAccessible(true);
                return (T) constructor.newInstance(new JSONObject(json));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return TextUtils.isEmpty(json) ? null : (T) json;
    }

    private static <T> T handleListObject(String json, Class<T> clz) throws ClassNotFoundException {
        Type type = clz.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            if (((ParameterizedType) clz.getGenericSuperclass()).getRawType().equals(ArrayList.class)) {
                Class innerClz = (Class) ((ParameterizedType) clz.getGenericSuperclass()).getActualTypeArguments()[0];
                return (T) parseListObject(json, innerClz);
            }
        }
        return null;
    }


    private static boolean checkList(Class clz) {
        Type type = clz.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType) clz.getGenericSuperclass()).getRawType().equals(ArrayList.class);
        }
        return false;
    }


    public static <T> List<T> parseListObject(String jsonArray, Class<T> clz) {
        List<T> ts = new ArrayList<>();
        try {
            JSONArray array = new JSONArray(jsonArray);
            if (array != null && array.length() > 0) {
                for (int i = 0; i < array.length(); i++) {
                    ts.add(parseObject(array.optJSONObject(i).toString(), clz));
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ts;
    }


}
