package com.vhall.vhss.netutils;

import android.util.Base64;
import android.util.Log;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.util.encoders.Hex;

/**
 * @author hkl
 * Date: 2021/1/15 11:53 AM
 */
public class EncryptionUtil {

    private static String PUCLIC_KEY = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCfz0clGLdOalwUrcygD7pc5res\n" +
            "gSokUiJ+MySO8iWuRm0TPoEUQhecd56QR4Xrbv91Nnn5qnD4bHPlIJIq7zz8R+hW\n" +
            "Y6DblLJNbpj4hypSZX0jiIaxQalgK20HZAdqaZ5o+77gSwZKNtUHsM0byEETvH+0\n" +
            "PrMvXsUc8r7d/aTMnwIDAQAB";

    //用户的可以
    public static String USER_PRIVATE_KEY = "";

    /**
     * Test the EncryptionUtil
     */
    public static String encrypt(String params) {
        String msg="";
        try {
             msg = executeSignature(params);
        } catch (Exception e) {
            Log.e("EncryptionUtil", e.getMessage());
        }

        return msg;
    }

    /**
     * 执行签名
     *
     * @param toSignStr 参数内容
     * @return 签名后的内容，base64后的字符串
     * @throws NoSuchAlgorithmException
     * @throws InvalidKeySpecException
     * @throws InvalidKeyException
     * @throws SignatureException
     */
    public static String executeSignature(String toSignStr) throws Exception, InvalidKeySpecException, InvalidKeyException, SignatureException {
        byte[] buffer = Base64Utils.decode(USER_PRIVATE_KEY);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(buffer);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = (RSAPrivateKey) keyFactory.generatePrivate(keySpec);
        Signature signature = Signature.getInstance("MD5withRSA");
        signature.initSign(privateKey);
        signature.update(toSignStr.getBytes());
        // 生成签名
        byte[] result = signature.sign();
        // base64编码签名为字符串
        return Base64.encodeToString(result, Base64.URL_SAFE | Base64.NO_PADDING); //Base64Utils.encode(result);
    }

    /**
     * 验证签名
     *
     * @param sign 签名
     * @param src  参数内容
     * @return 验证结果
     * @throws NoSuchAlgorithmException
     * @throws InvalidKeySpecException
     * @throws InvalidKeyException
     * @throws SignatureException
     */
    public static boolean verifySignature(String sign, String src) throws Exception, InvalidKeySpecException, InvalidKeyException, SignatureException {
        byte[] buffer = Base64Utils.decode(PUCLIC_KEY);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(buffer);
        PublicKey publicKey = (RSAPublicKey) keyFactory.generatePublic(keySpec);
        Signature signature = Signature.getInstance("MD5withRSA");
        signature.initVerify(publicKey);
        signature.update(src.getBytes());
        // base64解码签名为字节数组
        byte[] decodeSign = Base64.decode(sign,Base64.URL_SAFE | Base64.NO_PADDING);

        // 验证签名
        return signature.verify(decodeSign);
    }

    public static String SHA256Signature(String input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] encodedHash = digest.digest(input.getBytes());

            StringBuilder hexString = new StringBuilder();
            for (byte b : encodedHash) {
                String hex = Integer.toHexString(0xff & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String sm3Signature(String data)  throws Exception {
        byte[] digestBytes = data.getBytes("UTF-8");
        // 创建SM3Digest对象
        SM3Digest digest = new SM3Digest();

        // 更新数据
        digest.update(digestBytes, 0, digestBytes.length);

        // 计算哈希值
        byte[] hash = new byte[digest.getDigestSize()];
        digest.doFinal(hash, 0);

        // 将哈希值转换为十六进制字符串
        String hashHex = Hex.toHexString(hash);
        return hashHex;
    }
} 