package com.vhall.vhss.exception;

import android.net.ParseException;
import android.text.TextUtils;

import org.json.JSONException;

import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;


/**
 * 本地异常处理。包括解析异常等其他异常
 *
 * @author hkl
 */

public class CustomException {

    public static ApiException handleException(int code, Throwable e) {
        ApiException ex;
        String message = e.getMessage();
        if (TextUtils.isEmpty(message)) {
            message = "Error: e.getMessage().toString() null";
        }
        if (e instanceof JSONException
                || e instanceof ParseException) {
            //解析错误
            ex = new ApiException(code, "解析异常");
            return ex;
        } else if (e instanceof UnknownHostException || e instanceof SocketTimeoutException || e instanceof ConnectException) {
            //连接错误
            ex = new ApiException(code, "网络请求异常，请查看网络设置");
            return ex;
        } else {
            //未知错误
            ex = new ApiException(code, message);
            return ex;
        }
    }
}
