package com.vhall.vhss.data;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author hkl
 * Date: 2020/11/23 7:30 PM
 */
public class WebinarinfoListData implements Serializable {
    /**
     * total : 102
     * page : 1
     * pagesize : 12
     * list : [{"webinar_id":795704919,"is_interact":1,"user_id":1333,"user_fid":333,"layout":3,"is_demand":0,"img_url":"r6JB","subject":"this subject","start_time":"2020-10-26 22:56:32","pv":2333,"type":1,"end_time":"0000-00-00 00:00:00","verify":0,"fee":"0","sort":2.673256325532,"vss_room_id":"lss_e1db49e2","vss_inav_id":"inav_b836e457","vss_channel_id":"ch_09670369"},{"webinar_id":795704919,"is_interact":1,"user_id":1333,"user_fid":333,"layout":3,"is_demand":0,"img_url":"*MGl","subject":"this subject","start_time":"2020-10-26 22:56:32","pv":2333,"type":1,"end_time":"0000-00-00 00:00:00","verify":0,"fee":"0","sort":2.673256325532,"vss_room_id":"lss_e1db49e2","vss_inav_id":"inav_b836e457","vss_channel_id":"ch_09670369"}]
     */

    public String total;
    public String page;
    public String pagesize;
    public List<ListBean> list;

    public String raw;

    public WebinarinfoListData() {
    }

    public WebinarinfoListData(JSONObject object) {
        raw = object.toString();
        this.total = object.optString("total");
        this.page = object.optString("page");
        this.pagesize = object.optString("pagesize");
        JSONArray listArray = object.optJSONArray("list");
        if (listArray != null) {
            this.list = new ArrayList<>();
            for (int i = 0; i < listArray.length(); i++) {
                this.list.add(new ListBean(listArray.optJSONObject(i)));
            }
        }
    }


    public static class ListBean implements Serializable {
        /**
         * webinar_id : 795704919
         * is_interact : 1
         * user_id : 1333
         * user_fid : 333
         * layout : 3
         * is_demand : 0
         * img_url : r6JB
         * subject : this subject
         * start_time : 2020-10-26 22:56:32
         * pv : 2333
         * type : 1
         * end_time : 0000-00-00 00:00:00
         * verify : 0
         * fee : 0
         * sort : 2.673256325532
         * vss_room_id : lss_e1db49e2
         * vss_inav_id : inav_b836e457
         * vss_channel_id : ch_09670369
         */

        public String webinar_id;
        public String is_interact;
        public String user_id;
        public String user_fid;
        public String layout;
        public String is_demand;
        public String img_url;
        public String subject;
        public String start_time;
        public String pv;
        public String type;
        public String end_time;
        public String verify;//验证方式，0 无验证，1 密码，2 白名单，3 付费活动, 4 F码, 5 报名表单
        public String fee;
        public double sort;
        public String vss_room_id;
        public String vss_inav_id;
        public String vss_channel_id;
        public String webinar_type;//1 ：音频 2 : 视频 3 ： 互动
        public String share_link;
        public String player;
        public int is_privilege;
        public int webinar_state;// 1 预约 2 直播 3 回放 4 点播 5 结束
        public String is_new_version;//0 1 3 只有3是新版本的
        public int inav_num;//连麦人数 1v5 = 6 1v15=16
        public int is_director;//是否支持云导播 1:开启 0:关闭
        public int no_delay_webinar;//是否无延迟直播 1:是 0:否
        public int webinar_show_type;//1:横屏 0:竖屏

        public ListBean() {
        }

        public ListBean(JSONObject object) {

            this.is_new_version = object.optString("is_new_version");
            this.webinar_state = object.optInt("webinar_state");
            this.is_privilege = object.optInt("is_privilege");
            this.player = object.optString("player");
            this.share_link = object.optString("share_link");
            this.webinar_type = object.optString("webinar_type");
            this.webinar_id = object.optString("webinar_id");
            this.is_interact = object.optString("is_interact");
            this.user_id = object.optString("user_id");
            this.user_fid = object.optString("user_fid");
            this.layout = object.optString("layout");
            this.is_demand = object.optString("is_demand");
            this.img_url = object.optString("img_url");
            this.subject = object.optString("subject");
            this.start_time = object.optString("start_time");
            this.pv = object.optString("pv");
            this.type = object.optString("type");
            this.end_time = object.optString("end_time");
            this.verify = object.optString("verify");
            this.fee = object.optString("fee");
            this.vss_room_id = object.optString("vss_room_id");
            this.vss_inav_id = object.optString("vss_inav_id");
            this.vss_channel_id = object.optString("vss_channel_id");
            this.sort = object.optDouble("sort");
            this.inav_num = object.optInt("inav_num");
            this.no_delay_webinar = object.optInt("no_delay_webinar");
            this.is_director = object.optInt("is_director");
            this.webinar_show_type = object.optInt("webinar_show_type");
        }
    }
}
