package com.vhall.vhss.data;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author hkl
 * Date: 2022/7/26 10:04
 */
public class WarmInfoData implements Serializable {

    public String img_url;//暖场视频图片
    public String player_type;//1:单次播放 2:循环播放
    public String warm_id;//暖场视频id
    public String webinar_id;//活动id
    public String is_open_warm_video; //控制台暖场视频是否开启，0:关闭，1:开启

    public List<RecordListBean> list;//暖场视频对应列表
    public String raw;

    public WarmInfoData() {

    }

    public WarmInfoData(JSONObject object) {
        raw = object.toString();

        img_url = object.optString("img_url");
        player_type = object.optString("player_type");
        warm_id = object.optString("warm_id");
        webinar_id = object.optString("webinar_id");
        is_open_warm_video = object.optString("is_open_warm_video");
        JSONArray listArray = object.optJSONArray("record_list");
        if (listArray != null) {
            this.list = new ArrayList<>();
            for (int i = 0; i < listArray.length(); i++) {
                this.list.add(new RecordListBean(listArray.optJSONObject(i)));
            }
        }

    }

    public static class RecordListBean implements Serializable {
        public String paas_record_id;//暖场视频paas_id
        public String record_name;//暖场视频名称
        public String created_at;//关联成为暖场视频时间
        public String duration;//时长
        public String storage;//大小

        public RecordListBean() {
        }

        public RecordListBean(JSONObject object) {
            paas_record_id = object.optString("paas_record_id");
            record_name = object.optString("record_name");
            created_at = object.optString("created_at");
            duration = object.optString("duration");
            storage = object.optString("storage");
        }
    }
}