package com.vhall.vhss.data;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author wxx
 * Date: 2023/5/29 10:04
 * https://saas-doc.vhall.com/opendocs/show/1048
 */
public class RecordsData implements Serializable {

    public List<ListBean> list;
    public int total;
    public RecordsData() {

    }

    public String raw;

    public RecordsData(JSONObject object) {
        raw = object.toString();
        total = object.optInt("total");
        JSONArray listArray = object.optJSONArray("list");
        if (listArray != null) {
            this.list = new ArrayList<>();
            for (int i = 0; i < listArray.length(); i++) {
                this.list.add(new ListBean(listArray.optJSONObject(i)));
            }
        }
    }

    public class ListBean implements Serializable {
        public long record_id;//回放id
        public long webinar_id;//所属活动id
        public String name;//回放名称
        public long user_id;//用户id
        public int type;//类别 6默认回放
        public String img_url;//图片地址
        public String created_at;//创建时间
        public String updated_at;//修改时间
        public String duration;//视频时长；例如 00:03:20
        public int source;//来源 0 回放 1 录制 2 上传 3 打点录制
        public int quality;//清晰度
        public String transcode_code;//转码流媒体返回code码
        public String percent;//转码进度百分比
        public long switch_id;//回放对应的场次id
        public int encrypt_status;//0:未加密 1:加密中 2:加密成功
        public int is_rehearsal;//是否彩排 1 ：是 0 ：否
        public int doc_status;//	1:有章节 0:没有章节
        public int is_union_screen;//是否融屏 1:是 0 否
        public int remake_doc_progress;//课件重置进度 生成进度 如88  初始为0

        public ListBean() {

        }

        public ListBean(JSONObject object) {
            raw = object.toString();

            record_id = object.optLong("id");
            webinar_id = object.optLong("webinar_id");
            name = object.optString("name");
            user_id = object.optLong("user_id");
            type = object.optInt("type");
            img_url = object.optString("img_url");
            created_at = object.optString("created_at");
            updated_at = object.optString("updated_at");
            duration = object.optString("duration");
            source = object.optInt("source");
            quality = object.optInt("quality");
            transcode_code = object.optString("transcode_code");
            percent = object.optString("percent");
            switch_id = object.optLong("switch_id");
            encrypt_status = object.optInt("encrypt_status");
            is_rehearsal = object.optInt("is_rehearsal");
            is_union_screen = object.optInt("is_union_screen");
            doc_status = object.optInt("doc_status");
            remake_doc_progress = object.optInt("remake_doc_progress");
        }
    }
}