package com.vhall.vhss.data;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author hkl
 * Date: 2022/7/26 10:04
 */
public class RecordChaptersData implements Serializable {

    public List<ListBean> list;

    public RecordChaptersData() {

    }

    public String raw;

    public RecordChaptersData(JSONObject object) {
        raw = object.toString();
        JSONArray listArray = object.optJSONArray("doc_titles");
        if (listArray != null) {
            this.list = new ArrayList<>();
            for (int i = 0; i < listArray.length(); i++) {
                this.list.add(new ListBean(listArray.optJSONObject(i)));
            }
        }
    }

    public class ListBean implements Serializable {
        public String hash;//文档hash
        public double created_at;//文档章节演示时间点 相对视频起始的开始时间点
        public String title;//章节名称
        public String step_total;//子章节数量
        public String step;//当前文档子章节标识
        public String page;//当前文档章节页数
        public String subsection;//子章节信息 参控下表subsection说
        public String document_id;//文档id
        public String raw;

        public ListBean() {

        }

        public ListBean(JSONObject object) {
            raw = object.toString();

            hash = object.optString("hash");
            created_at = object.optDouble("created_at");
            title = object.optString("title");
            step_total = object.optString("step_total");
            page = object.optString("page");
            step = object.optString("step");
            document_id = object.optString("document_id");
        }
    }
}