package com.vhall.vhss.data;

import org.json.JSONObject;

import java.io.Serializable;

/**
 * @author hkl
 * Date: 2020/11/24 3:13 PM
 */
public class PrivilegeInfoData implements Serializable {

    /**
     * webinar_id : 757444784
     * is_public : 0
     * guest_password : v1SuJ7
     * assistant_password : #B1MG4
     * host_password : [dWlz
     * permission_data : {"guest":{"white_board":{"label":"文档白板","check":1},"webinar_award":{"label":"抽奖","check":1},"survey":{"label":"问卷","check":1},"sign_in":{"label":"签到","check":1},"members_manager":{"label":"成员管理","check":1},"comment_check":{"label":"聊天过滤","check":1},"webinar_notice":{"label":"公告","check":1},"disable_msg":{"label":"全员禁言","check":1},"assistant":{"label":"问答","check":1},"share":{"label":"分享","check":1}},"assistant":{"webinar_award":{"label":"抽奖","check":1},"survey":{"label":"问卷","check":1},"sign_in":{"label":"签到","check":1},"members_manager":{"label":"成员管理","check":1},"comment_check":{"label":"聊天过滤","check":1},"webinar_notice":{"label":"公告","check":1},"disable_msg":{"label":"全员禁言","check":1},"assistant":{"label":"问答","check":1},"share":{"label":"分享","check":1}}}
     * start_time : consequat ipsum sint est
     * subject : mollit
     * webinar_type : enim esse pariatu
     * nick_name : fugiat Duis labore minim exercitatio
     * join_link : dolore dolor ea anim
     */

    public String webinar_id;
    public int is_privilege;
    public String guest_password;
    public String assistant_password;
    public String host_password;
    public PermissionDataBean permission_data;
    public String start_time;
    public String subject;
    public String webinar_type;
    public String nick_name;
    public String join_link;//助理加入链接
    public String guest_join_link;//嘉宾加入链接
    public String host_join_link;//主持人加入链接

    public String raw;

    public PrivilegeInfoData() {
    }

    public PrivilegeInfoData(JSONObject object) {
        raw = object.toString();
        this.webinar_id = object.optString("webinar_id");
        this.is_privilege = object.optInt("is_privilege");
        this.guest_password = object.optString("guest_password");
        this.assistant_password = object.optString("assistant_password");
        this.host_password = object.optString("host_password");
        this.start_time = object.optString("start_time");
        this.subject = object.optString("subject");
        this.webinar_type = object.optString("webinar_type");
        this.nick_name = object.optString("nick_name");
        this.join_link = object.optString("join_link");
        this.guest_join_link = object.optString("guest_join_link");
        this.host_join_link = object.optString("host_join_link");
        JSONObject permission_dataObject = object.optJSONObject("permission_data");
        if (permission_dataObject != null) {
            this.permission_data = new PermissionDataBean(permission_dataObject);
        }
    }

    public static class PermissionDataBean implements Serializable {
        /**
         * guest : {"white_board":{"label":"文档白板","check":1},"webinar_award":{"label":"抽奖","check":1},"survey":{"label":"问卷","check":1},"sign_in":{"label":"签到","check":1},"members_manager":{"label":"成员管理","check":1},"comment_check":{"label":"聊天过滤","check":1},"webinar_notice":{"label":"公告","check":1},"disable_msg":{"label":"全员禁言","check":1},"assistant":{"label":"问答","check":1},"share":{"label":"分享","check":1}}
         * assistant : {"webinar_award":{"label":"抽奖","check":1},"survey":{"label":"问卷","check":1},"sign_in":{"label":"签到","check":1},"members_manager":{"label":"成员管理","check":1},"comment_check":{"label":"聊天过滤","check":1},"webinar_notice":{"label":"公告","check":1},"disable_msg":{"label":"全员禁言","check":1},"assistant":{"label":"问答","check":1},"share":{"label":"分享","check":1}}
         */

        public GuestBean guest;
        public AssistantBeanXX assistant;

        public PermissionDataBean() {
        }

        public PermissionDataBean(JSONObject object) {

            JSONObject guestObject = object.optJSONObject("guest");
            if (guestObject != null) {
                this.guest = new GuestBean(guestObject);
            }
            JSONObject assistantObject = object.optJSONObject("assistant");
            if (assistantObject != null) {
                this.assistant = new AssistantBeanXX(assistantObject);
            }
        }

        public static class GuestBean implements Serializable {
            /**
             * white_board : {"label":"文档白板","check":1}
             * webinar_award : {"label":"抽奖","check":1}
             * survey : {"label":"问卷","check":1}
             * sign_in : {"label":"签到","check":1}
             * members_manager : {"label":"成员管理","check":1}
             * comment_check : {"label":"聊天过滤","check":1}
             * webinar_notice : {"label":"公告","check":1}
             * disable_msg : {"label":"全员禁言","check":1}
             * assistant : {"label":"问答","check":1}
             * share : {"label":"分享","check":1}
             */
            public LabelData white_board;
            public LabelData webinar_award;
            public LabelData survey;
            public LabelData sign_in;
            public LabelData members_manager;
            public LabelData comment_check;
            public LabelData webinar_notice;
            public LabelData disable_msg;
            public LabelData assistant;
            public LabelData share;

            public GuestBean() {
            }

            public GuestBean(JSONObject object) {

                JSONObject white_boardObject = object.optJSONObject("white_board");
                if (white_boardObject != null) {
                    this.white_board = new LabelData(white_boardObject);
                }
                JSONObject webinar_awardObject = object.optJSONObject("webinar_award");
                if (webinar_awardObject != null) {
                    this.webinar_award = new LabelData(webinar_awardObject);
                }
                JSONObject surveyObject = object.optJSONObject("survey");
                if (surveyObject != null) {
                    this.survey = new LabelData(surveyObject);
                }
                JSONObject sign_inObject = object.optJSONObject("sign_in");
                if (sign_inObject != null) {
                    this.sign_in = new LabelData(sign_inObject);
                }
                JSONObject members_managerObject = object.optJSONObject("members_manager");
                if (members_managerObject != null) {
                    this.members_manager = new LabelData(members_managerObject);
                }
                JSONObject comment_checkObject = object.optJSONObject("comment_check");
                if (comment_checkObject != null) {
                    this.comment_check = new LabelData(comment_checkObject);
                }
                JSONObject webinar_noticeObject = object.optJSONObject("webinar_notice");
                if (webinar_noticeObject != null) {
                    this.webinar_notice = new LabelData(webinar_noticeObject);
                }
                JSONObject disable_msgObject = object.optJSONObject("disable_msg");
                if (disable_msgObject != null) {
                    this.disable_msg = new LabelData(disable_msgObject);
                }
                JSONObject assistantObject = object.optJSONObject("assistant");
                if (assistantObject != null) {
                    this.assistant = new LabelData(assistantObject);
                }
                JSONObject shareObject = object.optJSONObject("share");
                if (shareObject != null) {
                    this.share = new LabelData(shareObject);
                }
            }
        }

        public static class AssistantBeanXX implements Serializable {
            /**
             * webinar_award : {"label":"抽奖","check":1}
             * survey : {"label":"问卷","check":1}
             * sign_in : {"label":"签到","check":1}
             * members_manager : {"label":"成员管理","check":1}
             * comment_check : {"label":"聊天过滤","check":1}
             * webinar_notice : {"label":"公告","check":1}
             * disable_msg : {"label":"全员禁言","check":1}
             * assistant : {"label":"问答","check":1}
             * share : {"label":"分享","check":1}
             */

            public LabelData webinar_award;
            public LabelData survey;
            public LabelData sign_in;
            public LabelData members_manager;
            public LabelData comment_check;
            public LabelData webinar_notice;
            public LabelData disable_msg;
            public LabelData assistant;
            public LabelData share;

            public AssistantBeanXX() {
            }

            public AssistantBeanXX(JSONObject object) {

                JSONObject webinar_awardObject = object.optJSONObject("webinar_award");
                if (webinar_awardObject != null) {
                    this.webinar_award = new LabelData(webinar_awardObject);
                }
                JSONObject surveyObject = object.optJSONObject("survey");
                if (surveyObject != null) {
                    this.survey = new LabelData(surveyObject);
                }
                JSONObject sign_inObject = object.optJSONObject("sign_in");
                if (sign_inObject != null) {
                    this.sign_in = new LabelData(sign_inObject);
                }
                JSONObject members_managerObject = object.optJSONObject("members_manager");
                if (members_managerObject != null) {
                    this.members_manager = new LabelData(members_managerObject);
                }
                JSONObject comment_checkObject = object.optJSONObject("comment_check");
                if (comment_checkObject != null) {
                    this.comment_check = new LabelData(comment_checkObject);
                }
                JSONObject webinar_noticeObject = object.optJSONObject("webinar_notice");
                if (webinar_noticeObject != null) {
                    this.webinar_notice = new LabelData(webinar_noticeObject);
                }
                JSONObject disable_msgObject = object.optJSONObject("disable_msg");
                if (disable_msgObject != null) {
                    this.disable_msg = new LabelData(disable_msgObject);
                }
                JSONObject assistantObject = object.optJSONObject("assistant");
                if (assistantObject != null) {
                    this.assistant = new LabelData(assistantObject);
                }
                JSONObject shareObject = object.optJSONObject("share");
                if (shareObject != null) {
                    this.share = new LabelData(shareObject);
                }
            }

        }
    }

    public static class LabelData implements Serializable {
        /**
         * label : 问卷
         * check : 1
         */

        public String label;
        public int check;

        public LabelData() {
        }

        public LabelData(JSONObject object) {

            this.label = object.optString("label");
            this.check = object.optInt("check");
        }
    }
}
