package com.vhall.vhss.data;

import org.json.JSONObject;

import java.io.Serializable;

/**
 * @author hkl
 * Date: 2022/7/26 10:04
 */
public class PlayerConfigData implements Serializable {

    public ScrollInfoData scrollInfoData;
    public WatermarkInfoData watermarkInfoData;
    public String default_definition;

    public String raw;

    public PlayerConfigData() {

    }

    public PlayerConfigData(JSONObject object) {
        raw = object.toString();
        ResponseJe water_mark = new ResponseJe(object.optString("water-mark"), WatermarkInfoData.class);
        if (water_mark.getData() instanceof WatermarkInfoData) {
            this.watermarkInfoData = (WatermarkInfoData) water_mark.getData();
        }

        ResponseJe screen = new ResponseJe(object.optString("screen-config"), ScrollInfoData.class);
        if (screen.getData() instanceof ScrollInfoData) {
            this.scrollInfoData = (ScrollInfoData) screen.getData();
        }

        ResponseJe definition = new ResponseJe(object.optString("definition"), DefinitionBean.class);
        if (definition.getData() instanceof DefinitionBean) {
            DefinitionBean data = (DefinitionBean) definition.getData();
            this.default_definition = data.default_definition;
        }
    }

    public static class DefinitionBean implements Serializable {
        public String default_definition;

        public DefinitionBean() {
        }

        public DefinitionBean(JSONObject object) {
            default_definition = object.optString("default_definition");
        }
    }
}