package com.vhall.vhss.data;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author hkl
 * Date: 2020/11/13 9:50 AM
 * 领奖信息数据
 */
public class LotteryPrizeData implements Serializable {

    public int receive_award_way;//领奖方式1寄送奖品2私信兑奖3无需领奖
    public List<LotteryPrizeListData> list;
    public String raw;

    public LotteryPrizeData() {
    }

    public LotteryPrizeData(JSONObject object) {
        raw = object.toString();
        this.receive_award_way = object.optInt("receive_award_way");
        String json_data = object.optString("json_data");
        try {
            JSONArray listArray = new JSONArray(json_data);
            if (listArray != null) {
                this.list = new ArrayList<>();
                for (int i = 0; i < listArray.length(); i++) {
                    this.list.add(new LotteryPrizeListData(listArray.optJSONObject(i)));
                }
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }
}
