package com.vhall.vhss.data;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author hkl
 * Date: 2020/12/3 3:50 PM
 */
public class LanguageListData implements Serializable {

    /**
     * list : [{"webinar_id":853762516,"language_type":1,"subject":"互动直播","status":"1","introduction":"<p><\/p>"}]
     * total : 1
     * language_types : 1
     */

    public int total;
    public String language_types;

    public String raw;

    public LanguageListData(JSONObject object) {
        raw = object.toString();
        this.total = object.optInt("total");
        this.language_types = object.optString("language_types");
        JSONArray listArray = object.optJSONArray("list");
        if (listArray != null) {
            this.list = new ArrayList<>();
            for (int i = 0; i < listArray.length(); i++) {
                this.list.add(new ListBean(listArray.optJSONObject(i)));
            }
        }
    }

    public LanguageListData() {
    }

    public List<ListBean> list;

    public static class ListBean implements Serializable {
        /**
         * webinar_id : 853762516
         * language_type : 1
         * subject : 互动直播
         * status : 1
         * introduction : <p></p>
         */

        public String webinar_id;
        public int language_type;
        public int subject;
        public String status;
        public String introduction;

        public ListBean() {

        }

        public ListBean(JSONObject object) {

            this.webinar_id = object.optString("webinar_id");
            this.language_type = object.optInt("language_type");
            this.subject = object.optInt("subject");
            this.introduction = object.optString("introduction");
            this.status = object.optString("status");
        }
    }
}
