package com.vhall.vhss.data;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author hkl
 * 标签列表
 */
public class LabelListInfoData implements Serializable {

    public int total;
    public int webinar_label_num;
    public List<DetailBean> list;

    public String raw;

    public LabelListInfoData() {
    }

    public LabelListInfoData(JSONObject object) {
        raw = object.toString();
        this.total = object.optInt("total");
        this.webinar_label_num = object.optInt("webinar_label_num");
        JSONArray detailArray = object.optJSONArray("list");
        if (detailArray != null) {
            this.list = new ArrayList<>();
            for (int i = 0; i < detailArray.length(); i++) {
                this.list.add(new DetailBean(detailArray.optJSONObject(i)));
            }
        }
    }

    public static class DetailBean implements Serializable {
        public String name;//标签名称
        public String label_id;//主键id
        public String user_id;//用户id
        public String is_check;//是否选中（传活动ID后生效）0：未选中1选中
        public String is_quote;//是否被引用 0：否 1：被引用
        public String created_at;
        public String updated_at;
        public String order_at;//置顶时间

        public DetailBean() {
        }

        public DetailBean(JSONObject object) {

            this.name = object.optString("name");
            this.label_id = object.optString("label_id");
            this.user_id = object.optString("user_id");
            this.is_check = object.optString("is_check");
            this.is_quote = object.optString("is_quote");
            this.created_at = object.optString("created_at");
            this.updated_at = object.optString("updated_at");
            this.order_at = object.optString("order_at");
        }
    }
}
