package com.vhall.vhss.data;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author hkl
 * 领奖信息数据
 */
public class GiftListData implements Serializable {

    public List<ListBean> list;
    public int total;

    public String raw;

    public GiftListData() {
    }

    public GiftListData(JSONObject object) {
        raw = object.toString();
        total = object.optInt("total");
        JSONArray listArray = object.optJSONArray("list");
        if (listArray != null) {
            this.list = new ArrayList<>();
            for (int i = 0; i < listArray.length(); i++) {
                this.list.add(new ListBean(listArray.optJSONObject(i)));
            }
        }
    }

    public static class ListBean implements Serializable {

        public String id;//礼物ID
        public String name;
        public String price;
        public String image_url;//礼物图片
        public String source_type;//来源类型：0 web 1 app
        public String source_status;//0 系统礼物 1 自定义礼物


        public ListBean() {
        }


        public ListBean(JSONObject object) {

            this.id = object.optString("id");
            this.name = object.optString("name");
            this.price = object.optString("price");
            this.image_url = object.optString("image_url");
            this.source_type = object.optString("source_type");
            this.source_status = object.optString("source_status");

        }
    }
}
