package com.vhall.vhss.data;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author wxx
 * Date: 2023/5/29 10:04
 * http://wiki.vhallops.com/pages/viewpage.action?pageId=341082193
 */
public class FilesData implements Serializable {

    public List<ListBean> list;
    public int total;
    public FilesData() {

    }

    public String raw;

    public FilesData(JSONObject object) {
        raw = object.toString();
        total = object.optInt("total");
        JSONArray listArray = object.optJSONArray("list");
        if (listArray != null) {
            this.list = new ArrayList<>();
            for (int i = 0; i < listArray.length(); i++) {
                this.list.add(new ListBean(listArray.optJSONObject(i)));
            }
        }
    }

    public class ListBean implements Serializable {
        public String file_name;//文件名称
        public String file_size;//文件大小
        public String file_ext;//文件格式
        public String file_id;//文件ID
        public String file_type;//文件类型 0:文档 1:音视频
        public String file_desc;//文件描述
        public String img_url;//文件封面

        public ListBean() {

        }

        public ListBean(JSONObject object) {
            raw = object.toString();

            file_name = object.optString("file_name");
            file_size = object.optString("file_size");
            file_ext = object.optString("file_ext");
            file_id = object.optString("file_id");
            file_type = object.optString("file_type");
            file_desc = object.optString("file_desc");
            img_url = object.optJSONObject("img_info").optString("img_url");
        }
    }
}