package com.vhall.vhss.data;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author hkl
 * 试卷列表
 */
public class ExamAnswerPaperHistoryData implements Serializable {

    public List<ListBean> list;

    public String raw;

    public ExamAnswerPaperHistoryData() {
    }

    public ExamAnswerPaperHistoryData(JSONObject object) {
        raw = object.toString();
        JSONArray listArray = object.optJSONArray("list");
        if (listArray != null) {
            this.list = new ArrayList<>();
            for (int i = 0; i < listArray.length(); i++) {
                this.list.add(new ListBean(listArray.optJSONObject(i)));
            }
        }
    }

    public static class ListBean implements Serializable {

        public String question_id;//题目id
        public String answer;//答案

        public ListBean() {
        }

        public ListBean(JSONObject object) {
            this.question_id = object.optString("question_id");
            this.answer = object.optString("answer");
        }
    }
}
