package com.vhall.vhss.data;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author hkl
 * Date: 2019-11-27 17:04
 * 文档列表
 */
public class DocListInfoData implements Serializable {

    /**
     * detail : [{"id":1875,"app_id":"af314787","document_id":"98acf806","hash":"f7a6d020ca71099b8b9412bbcf113ff0","ext":"jpg","page":1,"trans_status":1,"file_name":"IMG_20190321_164543.jpg","room_id":"lss_d2ee016f","account_id":"700","created_at":"2019-11-27 17:00:00","updated_at":"2019-11-27 17:00:11","deleted_at":null}]
     * total : 1
     * total_page : 1
     * curr_page : 1
     */

    public int total;
    public String request_id;
    public List<DetailBean> list;

    public String raw;

    public DocListInfoData() {
    }

    public DocListInfoData(JSONObject object) {
        raw = object.toString();
        this.total = object.optInt("total");
        this.request_id = object.optString("request_id");
        JSONArray detailArray = object.optJSONArray("list");
        if (detailArray != null) {
            this.list = new ArrayList<>();
            for (int i = 0; i < detailArray.length(); i++) {
                this.list.add(new DetailBean(detailArray.optJSONObject(i)));
            }
        }
    }

    public static class DetailBean implements Serializable {
        public String id;
        public String webinar_id;
        public String document_id;
        public String file_name;
        public String hash;
        public String ext;
        public int page;
        public int size;
        public int status;
        public String created_at;
        public String updated_at;
        public String converted_page_jpeg;
        public String status_jpeg;

        public DetailBean() {
        }

        public DetailBean(JSONObject object) {

            this.id = object.optString("id");
            this.document_id = object.optString("document_id");
            this.webinar_id = object.optString("webinar_id");
            this.file_name = object.optString("file_name");
            this.hash = object.optString("hash");
            this.ext = object.optString("ext");
            this.page = object.optInt("page");
            this.size = object.optInt("size");
            this.created_at = object.optString("created_at");
            this.converted_page_jpeg = object.optString("converted_page_jpeg");
            this.updated_at = object.optString("updated_at");
            this.status_jpeg = object.optString("status_jpeg");
            this.status = object.optInt("status");
        }
    }
}
