package com.vhall.vhss.data;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author hkl
 * Date: 2022/4/12 4:09 下午
 */
public class DirectorSeatListData implements Serializable {


    public String raw;
    public List<ListBean> list;

    public DirectorSeatListData() {
    }

    public DirectorSeatListData(JSONObject object) {
        raw = object.toString();
        JSONArray listArray = object.optJSONArray("list");
        if (listArray != null) {
            this.list = new ArrayList<>();
            for (int i = 0; i < listArray.length(); i++) {
                this.list.add(new ListBean(listArray.optJSONObject(i)));
            }
        }
    }


    public static class ListBean {
        public String seat_id;//机位 ID
        public String status;//机位状态， 0： 未被占用， 1：已被占用
        public String name;//机位名称

        public ListBean() {

        }

        public ListBean(JSONObject object) {
            this.name = object.optString("name");
            this.seat_id = object.optString("seat_id");
            this.status = object.optString("status");
        }
    }
}