package com.vhall.vhss.data;

import android.text.TextUtils;
import android.widget.ImageView;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author wxx
 * Date: 2023/06/09 4:09 PM
 */
public class CouponInfoData implements Serializable {
    /**
     * http://yapi.vhall.domain/project/1285/interface/api/58716
     */
    public Integer total = 0;
    public List<CouponItem> coupon_items;
    public String raw;
    public CouponInfoData() {
    }

    public CouponInfoData(JSONArray object) {
        raw = object.toString();
        if(object == null)
            return;

        JSONArray listArray = object;
        if (listArray != null) {
            this.coupon_items = new ArrayList<>();
            for (int i = 0; i < listArray.length(); i++) {
                this.coupon_items.add(new CouponItem(listArray.optJSONObject(i)));
            }
            this.total = this.coupon_items.size();
        }
    }

    public static class CouponItem implements Serializable {
        public String coupon_id;//优惠券id
        public String coupon_name;//优惠券名称
        public Integer coupon_type;//优惠券类型 0-满减优惠 1-无门槛优惠
        public String threshold_amount;//门槛金额
        public String deduction_amount;//减免金额
        public Integer validity_type;//有效期类型 0-固定日期 1-固定天数
        public Integer validity_day;//有效期天数
        public String validity_start_time;//有效期开始时间
        public String validity_end_time;//有效期结束时间
        public String use_desc;//使用说明
        public Integer applicable_product_type;//适用商品类型 0-全部商品 1-指定商品可用 2-指定商品不可用
        public Integer goods_num;//商品数量
        public String business_uid;//操作人id
        public String nick_name;//操作人昵称
        public String updated_at;//更新时间
        public boolean unavailable;//是否不可用
        public Integer unavailable_type;//不可用原因 0-未达条件 1-已失效-2-已使用
        public String coupon_user_id;//用户领取优惠券ID
        public boolean is_selected;//是否被选中
        public CouponItem() {
        }

        public CouponItem(JSONObject object) {
            this.coupon_id = object.optString("coupon_id");
            this.coupon_name = object.optString("coupon_name");
            this.coupon_type = object.optInt("coupon_type");
            this.threshold_amount = object.optString("threshold_amount");
            this.deduction_amount = object.optString("deduction_amount");
            this.validity_type = object.optInt("validity_type");
            this.validity_day = object.optInt("validity_day");
            this.validity_start_time = object.optString("validity_start_time");
            this.validity_end_time = object.optString("validity_end_time");
            this.use_desc = object.optString("use_desc");
            this.applicable_product_type = object.optInt("applicable_product_type");
            this.goods_num = object.optInt("goods_num");
            this.business_uid = object.optString("business_uid");
            this.nick_name = object.optString("nick_name");
            this.updated_at = object.optString("updated_at");
            this.unavailable = !TextUtils.isEmpty(object.optString("unavailable_type"));
            this.coupon_user_id = object.optString("coupon_user_id");
            if( this.unavailable)
                this.unavailable_type = object.optInt("unavailable_type");
        }
    }
}