package com.vhall.vhss.data;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author hkl
 * Date: 2020/12/3 3:50 PM
 */
public class ChatListData implements Serializable {
    /**
     * total : 2001
     * list : [{"data":{"type":"text","barrage_txt":"elit","text_content":"dolore fugiat aliqua officia","nick_name":"sit enim id irure","avatar":"culpa","image_urls":["tempor ullamco esse","veniam non cupidatat in aliq","nostrud","aliquip irure","ut dolore incididunt Lorem deserunt"]},"date_time":"sunt Duis ea","sender_id":"do laborum eiusmod Lorem tempor","nickname":"sint irure","avatar":"dolor eu","role_name":"cupidatat labore sunt commodo","show_time":"est in adipisicing","id":"nostrud occaecat ven","msg_id":"adipisicing qui","context":{"nickname":"do proident pariatur dolor ullamco","avatar":"proident fugiat exercitation","role_name":"ut Excepteur","reply_msg":{"type":"Lorem laboris","avatar":"tempor sint dolore in laborum","send_id":"elit reprehenderit","nick_name":"ullamco occaecat non","role_name":"amet anim voluptate","content":{"type":"nostrud mollit aliqua nulla et","barrage_txt":"minim irure Ut aliqua anim","text_content":"magna ullamco ex in anim","nick_name":"dolor ex nisi qui culpa","avatar":"elit dolor voluptate sit non"},"show_time":"culpa dolor sed","send_time":"consequat","client":"commodo consectetur tempor d","count":"enim sint ullamco","reply_msg":"mollit anim et dolor Ut","msg_id":"ea Excepteur","channel":"labore","at_list":[{"nick_name":"sed pariatur est ipsum consequat","account_id":"dolor voluptate","index":"Ut eu Excepteur adipisicing"},{"nick_name":"sit ad occaecat","account_id":"lab","index":"proident"},{"nick_name":"non in sint deserunt nulla","account_id":"adipisicing Lorem dolore aute","index":"sint in"},{"nick_name":"deserunt fugiat in","account_id":"Excepteur nostrud","index":"consectet"}],"is_history_msg":"cillum"},"at_list":[{"nick_name":"nostrud","account_id":"aliqua qui Duis","index":"quis sit eiusmod velit Ut"},{"nick_name":"pariatur ullamco velit mollit","account_id":"exercitation esse ","index":"incididunt qui exercitation"},{"nick_name":"minim velit dolore deserunt","account_id":"ut magna sint","index":"ut aliqua sunt voluptate"}]},"channel_id":"ch_5ffe0b13"},{"data":{"type":"text","barrage_txt":"dolore eiusmod in ut dolor","text_content":"officia","nick_name":"aliquip sed","avatar":"sit","image_urls":["ut dolore","sed elit exerc"]},"date_time":"Excepteur elit ","sender_id":"dolor minim sed","nickname":"voluptate aliquip reprehenderit minim sed","avatar":"officia Excepteur ex incididunt","role_name":"labore ipsum Duis","show_time":"","id":"quis incididunt","msg_id":"ullamco sit","context":{"nickname":"occaecat mollit","avatar":"laborum ex fugiat adipisicing","role_name":"eu consectetur","reply_msg":{"type":"deserunt aute sint","avatar":"Duis","send_id":"esse mollit","nick_name":"ullamco sed veniam culpa eu","role_name":"nostrud id","content":{"type":"esse amet exercitation do","barrage_txt":"elit cillum dolor","text_content":"reprehenderit","nick_name":"enim elit in dolore","avatar":"in irure"},"show_time":"pariatur officia","send_time":"c","client":"ad sint","count":"exercitation Excepteur qui laborum in","reply_msg":"et ad dolor amet","msg_id":"eu consectetur Ut","channel":"quis","at_list":[{"nick_name":"esse","account_id":"nostrud id","index":"exercitation reprehende"},{"nick_name":"id occaecat do incididunt nostrud","account_id":"magna reprehenderit","index":"et Excepteur eu dolor dolor"},{"nick_name":"magna sunt esse tempor ullamco","account_id":"anim elit dolore","index":"ullamco qui laborum cupidatat"},{"nick_name":"proident tempor","account_id":"ut officia in consectetur","index":"quis"},{"nick_name":"quis sunt qui dolore","account_id":"consequat","index":"eiusmod do qui ullamco consectetur"}],"is_history_msg":"eu"},"at_list":[{"nick_name":"voluptate cupid","account_id":"aliquip in sunt","index":"dolor aliqua"},{"nick_name":"irure do anim deserunt","account_id":"cupidatat proident nisi","index":"laboris laborum reprehenderit"},{"nick_name":"a","account_id":"in elit anim consequat","index":"in deserunt aliquip elit veniam"}]},"channel_id":"ch_5ffe0b13"}]
     */

    public int total;
    public List<ListBean> list;

    public String raw;

    public ChatListData(JSONObject object) {
        raw = object.toString();
        this.total = object.optInt("total");
        JSONArray listArray = object.optJSONArray("list");
        if (listArray != null) {
            this.list = new ArrayList<>();
            for (int i = 0; i < listArray.length(); i++) {
                this.list.add(new ListBean(listArray.optJSONObject(i)));
            }
        }
    }

    public ChatListData() {
    }

    public static class ListBean implements Serializable {
        /**
         * data : {"type":"text","barrage_txt":"elit","text_content":"dolore fugiat aliqua officia","nick_name":"sit enim id irure","avatar":"culpa","image_urls":["tempor ullamco esse","veniam non cupidatat in aliq","nostrud","aliquip irure","ut dolore incididunt Lorem deserunt"]}
         * date_time : sunt Duis ea
         * sender_id : do laborum eiusmod Lorem tempor
         * nickname : sint irure
         * avatar : dolor eu
         * role_name : cupidatat labore sunt commodo
         * show_time : est in adipisicing
         * id : nostrud occaecat ven
         * msg_id : adipisicing qui
         * context : {"nickname":"do proident pariatur dolor ullamco","avatar":"proident fugiat exercitation","role_name":"ut Excepteur","reply_msg":{"type":"Lorem laboris","avatar":"tempor sint dolore in laborum","send_id":"elit reprehenderit","nick_name":"ullamco occaecat non","role_name":"amet anim voluptate","content":{"type":"nostrud mollit aliqua nulla et","barrage_txt":"minim irure Ut aliqua anim","text_content":"magna ullamco ex in anim","nick_name":"dolor ex nisi qui culpa","avatar":"elit dolor voluptate sit non"},"show_time":"culpa dolor sed","send_time":"consequat","client":"commodo consectetur tempor d","count":"enim sint ullamco","reply_msg":"mollit anim et dolor Ut","msg_id":"ea Excepteur","channel":"labore","at_list":[{"nick_name":"sed pariatur est ipsum consequat","account_id":"dolor voluptate","index":"Ut eu Excepteur adipisicing"},{"nick_name":"sit ad occaecat","account_id":"lab","index":"proident"},{"nick_name":"non in sint deserunt nulla","account_id":"adipisicing Lorem dolore aute","index":"sint in"},{"nick_name":"deserunt fugiat in","account_id":"Excepteur nostrud","index":"consectet"}],"is_history_msg":"cillum"},"at_list":[{"nick_name":"nostrud","account_id":"aliqua qui Duis","index":"quis sit eiusmod velit Ut"},{"nick_name":"pariatur ullamco velit mollit","account_id":"exercitation esse ","index":"incididunt qui exercitation"},{"nick_name":"minim velit dolore deserunt","account_id":"ut magna sint","index":"ut aliqua sunt voluptate"}]}
         * channel_id : ch_5ffe0b13
         */

        public DataBean data;
        public String date_time;
        public String sender_id;
        public String nickname;
        public String avatar;
        public String role_name;
        public String show_time;
        public String id;
        public String msg_id;
        public ContextBean context;
        public String channel_id;

        public ListBean() {

        }

        public ListBean(JSONObject object) {

            this.date_time = object.optString("date_time");
            this.sender_id = object.optString("sender_id");
            this.nickname = object.optString("nickname");
            this.avatar = object.optString("avatar");
            this.role_name = object.optString("role_name");
            this.show_time = object.optString("show_time");
            this.id = object.optString("id");
            this.msg_id = object.optString("msg_id");
            this.channel_id = object.optString("channel_id");
            JSONObject dataObject = object.optJSONObject("data");
            if (dataObject != null) {
                this.data = new DataBean(dataObject);
            }
            JSONObject contextObject = object.optJSONObject("context");
            if (contextObject != null) {
                this.context = new ContextBean(contextObject);
            }
        }

        public static class DataBean implements Serializable {
            /**
             * type : text
             * barrage_txt : elit
             * text_content : dolore fugiat aliqua officia
             * nick_name : sit enim id irure
             * avatar : culpa
             * image_urls : ["tempor ullamco esse","veniam non cupidatat in aliq","nostrud","aliquip irure","ut dolore incididunt Lorem deserunt"]
             */

            public String type;
            public String barrage_txt;
            public String text_content;
            public String nick_name;
            public String avatar;
            public List<String> image_urls;

            public DataBean() {
            }

            public DataBean(JSONObject object) {

                this.type = object.optString("type");
                this.barrage_txt = object.optString("barrage_txt");
                this.text_content = object.optString("text_content");
                this.nick_name = object.optString("nick_name");
                this.avatar = object.optString("avatar");
                JSONArray image_urlsArray = object.optJSONArray("image_urls");
                if (image_urlsArray != null) {
                    this.image_urls = new ArrayList<>();
                    for (int i = 0; i < image_urlsArray.length(); i++) {
                        this.image_urls.add(image_urlsArray.optString(i));
                    }
                }
            }
        }

        public static class ContextBean implements Serializable {
            /**
             * nickname : do proident pariatur dolor ullamco
             * avatar : proident fugiat exercitation
             * role_name : ut Excepteur
             * reply_msg : {"type":"Lorem laboris","avatar":"tempor sint dolore in laborum","send_id":"elit reprehenderit","nick_name":"ullamco occaecat non","role_name":"amet anim voluptate","content":{"type":"nostrud mollit aliqua nulla et","barrage_txt":"minim irure Ut aliqua anim","text_content":"magna ullamco ex in anim","nick_name":"dolor ex nisi qui culpa","avatar":"elit dolor voluptate sit non"},"show_time":"culpa dolor sed","send_time":"consequat","client":"commodo consectetur tempor d","count":"enim sint ullamco","reply_msg":"mollit anim et dolor Ut","msg_id":"ea Excepteur","channel":"labore","at_list":[{"nick_name":"sed pariatur est ipsum consequat","account_id":"dolor voluptate","index":"Ut eu Excepteur adipisicing"},{"nick_name":"sit ad occaecat","account_id":"lab","index":"proident"},{"nick_name":"non in sint deserunt nulla","account_id":"adipisicing Lorem dolore aute","index":"sint in"},{"nick_name":"deserunt fugiat in","account_id":"Excepteur nostrud","index":"consectet"}],"is_history_msg":"cillum"}
             * at_list : [{"nick_name":"nostrud","account_id":"aliqua qui Duis","index":"quis sit eiusmod velit Ut"},{"nick_name":"pariatur ullamco velit mollit","account_id":"exercitation esse ","index":"incididunt qui exercitation"},{"nick_name":"minim velit dolore deserunt","account_id":"ut magna sint","index":"ut aliqua sunt voluptate"}]
             */

            public String nickname;
            public String nick_name;
            public String avatar;
            public String role_name;
            public ReplyMsgBean reply_msg;
            public List<ReplyMsgBean.AtListBean> at_list;

            public ContextBean() {
            }

            public ContextBean(JSONObject object) {

                this.nickname = object.optString("nickname");
                this.nick_name = object.optString("nick_name");
                this.avatar = object.optString("avatar");
                this.role_name = object.optString("role_name");
                JSONObject reply_msgObject = object.optJSONObject("reply_msg");
                if (reply_msgObject != null) {
                    this.reply_msg = new ReplyMsgBean(reply_msgObject);
                }
                JSONArray at_listArray = object.optJSONArray("at_list");
                if (at_listArray != null) {
                    this.at_list = new ArrayList<>();
                    for (int i = 0; i < at_listArray.length(); i++) {
                        this.at_list.add(new ReplyMsgBean.AtListBean(at_listArray.optJSONObject(i)));
                    }
                }
            }

            public static class ReplyMsgBean implements Serializable {
                /**
                 * type : Lorem laboris
                 * avatar : tempor sint dolore in laborum
                 * send_id : elit reprehenderit
                 * nick_name : ullamco occaecat non
                 * role_name : amet anim voluptate
                 * content : {"type":"nostrud mollit aliqua nulla et","barrage_txt":"minim irure Ut aliqua anim","text_content":"magna ullamco ex in anim","nick_name":"dolor ex nisi qui culpa","avatar":"elit dolor voluptate sit non"}
                 * show_time : culpa dolor sed
                 * send_time : consequat
                 * client : commodo consectetur tempor d
                 * count : enim sint ullamco
                 * reply_msg : mollit anim et dolor Ut
                 * msg_id : ea Excepteur
                 * channel : labore
                 * at_list : [{"nick_name":"sed pariatur est ipsum consequat","account_id":"dolor voluptate","index":"Ut eu Excepteur adipisicing"},{"nick_name":"sit ad occaecat","account_id":"lab","index":"proident"},{"nick_name":"non in sint deserunt nulla","account_id":"adipisicing Lorem dolore aute","index":"sint in"},{"nick_name":"deserunt fugiat in","account_id":"Excepteur nostrud","index":"consectet"}]
                 * is_history_msg : cillum
                 */

                public String type;
                public String avatar;
                public String send_id;
                public String nick_name;
                public String role_name;
                public ContentBean content;
                public String show_time;
                public String send_time;
                public String client;
                public String count;
                public String reply_msg;
                public String msg_id;
                public String channel;
                public String is_history_msg;
                public List<AtListBean> at_list;

                public ReplyMsgBean() {
                }

                public ReplyMsgBean(JSONObject object) {

                    this.type = object.optString("type");
                    this.avatar = object.optString("avatar");
                    this.send_id = object.optString("send_id");
                    this.nick_name = object.optString("nick_name");
                    this.role_name = object.optString("role_name");
                    this.show_time = object.optString("show_time");
                    this.send_time = object.optString("send_time");
                    this.client = object.optString("client");
                    this.count = object.optString("count");
                    this.reply_msg = object.optString("reply_msg");
                    this.msg_id = object.optString("msg_id");
                    this.channel = object.optString("channel");
                    this.is_history_msg = object.optString("is_history_msg");
                    JSONObject contentObject = object.optJSONObject("content");
                    if (contentObject != null) {
                        this.content = new ContentBean(contentObject);
                    }
                    JSONArray at_listArray = object.optJSONArray("at_list");
                    if (at_listArray != null) {
                        this.at_list = new ArrayList<>();
                        for (int i = 0; i < at_listArray.length(); i++) {
                            this.at_list.add(new AtListBean(at_listArray.optJSONObject(i)));
                        }
                    }
                }

                public static class ContentBean implements Serializable {
                    /**
                     * type : nostrud mollit aliqua nulla et
                     * barrage_txt : minim irure Ut aliqua anim
                     * text_content : magna ullamco ex in anim
                     * nick_name : dolor ex nisi qui culpa
                     * avatar : elit dolor voluptate sit non
                     */

                    public String type;
                    public String barrage_txt;
                    public String text_content;
                    public String nick_name;
                    public String avatar;

                    public ContentBean() {
                    }

                    public ContentBean(JSONObject object) {

                        this.type = object.optString("type");
                        this.barrage_txt = object.optString("barrage_txt");
                        this.text_content = object.optString("text_content");
                        this.nick_name = object.optString("nick_name");
                        this.avatar = object.optString("avatar");
                    }
                }

                public static class AtListBean implements Serializable {
                    /**
                     * nick_name : sed pariatur est ipsum consequat
                     * account_id : dolor voluptate
                     * index : Ut eu Excepteur adipisicing
                     */

                    public String nick_name;
                    public String account_id;
                    public String index;

                    public AtListBean() {
                    }

                    public AtListBean(JSONObject object) {

                        this.nick_name = object.optString("nick_name");
                        this.account_id = object.optString("account_id");
                        this.index = object.optString("index");
                    }
                }
            }
        }
    }
}
