package com.vhall.vhss.api;


import android.content.Context;
import android.text.TextUtils;

import com.vhall.vhss.TokenManger;

import java.util.HashMap;

/**
 * author: caoyanglong
 * desc: 网络请求
 * date: 2020/9/16
 */
public class CoreNetApi {
    private static CoreNetApi api;
    private HashMap<String, String> hashMap = new HashMap<>();
    private String client_version;

    public static CoreNetApi getNet() {
        if (api == null) {
            synchronized (CoreNetApi.class) {
                if (api == null) {
                    api = new CoreNetApi();
                }
            }
        }
        return api;
    }

    /**
     * @param platform 1代表app 5代表 sdk
     */
    public void init(Context context, String hostUrl, String area, String platform) {
        TokenManger.onCreate(context);
        if (!TextUtils.isEmpty(hostUrl)) {
            CoreApiConstant.API_HOST = hostUrl;
        }
        if (!TextUtils.isEmpty(area)) {
            CoreApiConstant.API_AREA = area;
        }
        if (!TextUtils.isEmpty(platform)) {
            CoreApiConstant.API_PLATFORM = platform;
        }
    }

    /**
     * @param hashMap saas sdk 传递共参数
     */
    public void setPostParams(HashMap<String, String> hashMap) {
        this.hashMap = hashMap;
    }

    public HashMap<String, String> getHashMap() {
        return hashMap;
    }
}
