package com.vhall.business.utils;

import android.text.TextUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VHInternalUtils {
    public static boolean isEmpty(List list) {
        return list == null || list.isEmpty();
    }


    public static boolean isNotEmpty(List list) {
        return !isEmpty(list);
    }

    public static boolean isEmpty(Object[] list) {
        return list == null || list.length == 0;
    }


    public static boolean isNotEmpty(Object[] list) {
        return !isEmpty(list);
    }

    /**
     * 判断是否是主播
     * 兼容1 host
     * @param roleName
     * @return
     */
    public static boolean isHost(String roleName) {
        return TextUtils.equals(roleName, "1") || TextUtils.equals(roleName, "host");
    }

    //成员列表排序
    private static Map<String,Integer> sOnLineOrderRoles = new HashMap<>();
    //互动人员列表排序
    private static Map<String,Integer> sInteractiveOrderRoles = new HashMap<>();



    static {
        sOnLineOrderRoles.put("1",4);
        sOnLineOrderRoles.put("2",1);
        sOnLineOrderRoles.put("3",2);
        sOnLineOrderRoles.put("4",3);

        sInteractiveOrderRoles.put("1",8);
        sInteractiveOrderRoles.put("2",5);
        sInteractiveOrderRoles.put("3",6);
        sInteractiveOrderRoles.put("4",7);
    }

    /**
     * only support role 1、2、3、4
     * @param role
     * @return
     */
    public static int getOrderNum(String role){
        role = parseRoleNameToNum(role);
        if(sOnLineOrderRoles.containsKey(role)){
            return sOnLineOrderRoles.get(role);
        }
        return 2;
    }

    public static int getInteractiveOrderNum(String role){
        role = parseRoleNameToNum(role);
        if(sInteractiveOrderRoles.containsKey(role)){
            return sInteractiveOrderRoles.get(role);
        }
        return 2;
    }
    /**
     * //角色名称： 1(host):主持人 2(user)：观众  3(assistant)：助理 4(guest)：嘉宾
     *
     * @param role
     * @return
     */
    public static String parseRoleNameToNum(String role) {
        if (TextUtils.isEmpty(role)) {
            return "2";
        }
        if (TextUtils.isDigitsOnly(role)) {
            return role;
        }
        if (TextUtils.equals("host", role)) {
            return "1";
        }
        if (TextUtils.equals("user", role)) {
            return "2";
        }
        if (TextUtils.equals("assistant", role)) {
            return "3";
        }
        if (TextUtils.equals("guest", role)) {
            return "4";
        }
        return "2";
    }


    public static int strToInt(String val){
        if(!TextUtils.isEmpty(val) && TextUtils.isDigitsOnly(val)){
            return Integer.valueOf(val);
        }
        return 0;
    }

    public static String switchToStrNumber(int val){
        return String.valueOf(val);
    }

    public static String switchToStrNumber(Integer val){
        if(val == null){
            return "0";
        }
        return String.valueOf(val);
    }

    public static String switchToStrNumber(String val){
        if(TextUtils.isEmpty(val) || !TextUtils.isDigitsOnly(val)){
            return "0";
        }
        return String.valueOf(val);
    }




}
