package com.vhall.business.utils;

import android.text.TextUtils;

import com.vhall.business.VhallSDK;
import com.vhall.business.data.WebinarInfo;
import com.vhall.ops.WatermarkOption;

/**
 * @author：jooper Email：jooperge@163.com
 * 描述：
 * 修改历史:
 * <p>
 * 创建于： 2022/6/10
 */
public class DocWatermarkHelper {

    public static boolean isDocWatermarkEnable(WebinarInfo webinarInfo) {
        return null != webinarInfo && null != webinarInfo.watermark && webinarInfo.watermark.isDocWatermarkEnable();
    }

    public static WatermarkOption makeWatermarkOption(WebinarInfo.Watermark watermark) {
        String wmText = watermark.docWatermarkType.getWatermarkText(VhallSDK.getUserId(), VhallSDK.getUserNickname());
        if (!TextUtils.isEmpty(wmText)) {
            String wmColor = watermark.docFontColor;
            if (!TextUtils.isEmpty(wmColor)) {
                if (!wmColor.startsWith("#")) {
                    wmColor = "#" + wmColor;
                }
            }

            float wmOpacity;
            try {
                wmOpacity = Float.parseFloat(watermark.docTransparency) / 100;
            } catch (NumberFormatException e) {
                wmOpacity = 1;
            }

            int wmFontSize;
            try {
                wmFontSize = Integer.parseInt(watermark.docFontSize);
            } catch (NumberFormatException e) {
                wmFontSize = 20;
                e.printStackTrace();
            }
            return new WatermarkOption(wmText, wmColor, 30, wmOpacity, wmFontSize);
        }
        return null;
    }
}