package com.vhall.business.module.survey;

import static com.vhall.business.module.message.IMessageCallBack.*;

import android.content.Context;

import com.vhall.business.NewH5ImManager;
import com.vhall.business.VhallSDK;
import com.vhall.business.data.RequestDataCallback;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.utils.SurveyInternal;

/**
 * @author hkl
 * Date: 2022/11/14 14:21
 */
public class SurveyServer implements ISurvey {

    private WebinarInfo webinarInfo;
    private Context context;
    private SurveyMessageCallBack surveyMessageCallBack;

    private void SurveyServer() {

    }

    private SurveyServer(Builder builder) {
        this.context = builder.context;
        this.webinarInfo = builder.webinarInfo;
        this.surveyMessageCallBack = builder.surveyMessageCallBack;
        if (surveyMessageCallBack != null) {
            NewH5ImManager.getInstance().setMessageCallBackMap(KEY_MESSAGE_SURVEY, surveyMessageCallBack);
        }
    }


    @Override
    public void getHistorySurveyList(RequestDataCallback callBack) {
        if (webinarInfo != null) {
            VhallSDK.getHistorySurveyList(webinarInfo.switch_id, webinarInfo.vss_room_id, webinarInfo.webinar_id, callBack);
        } else {
            if (callBack != null) {
                callBack.onError(-1, "webinarInfo can not be null");
            }
        }

    }

    @Override
    public String getSurveyUrl(String questionId) {
        if (webinarInfo != null) {
            return SurveyInternal.createSurveyUrl(webinarInfo, questionId);
        } else {
            return "";
        }
    }

    public static class Builder {
        WebinarInfo webinarInfo;
        Context context;
        SurveyMessageCallBack surveyMessageCallBack;

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder surveyMessageCallBack(SurveyMessageCallBack surveyMessageCallBack) {
            this.surveyMessageCallBack = surveyMessageCallBack;
            return this;
        }

        public Builder webinarInfo(WebinarInfo webinarInfo) {
            this.webinarInfo = webinarInfo;
            return this;
        }

        public SurveyServer build() {
            if (webinarInfo == null) {
                throw new IllegalArgumentException("webinarInfo can not be null");
            }else if(webinarInfo.is_new_version == 3 && (webinarInfo.getWebinarInfoData() == null || webinarInfo.getWebinarInfoData().interact == null)){
                    throw new IllegalArgumentException("webinarInfo can not be null");
            }
            return new SurveyServer(this);
        }
    }
}