package com.vhall.business.module.sign;

import static com.vhall.business.module.message.IMessageCallBack.*;

import android.content.Context;

import com.vhall.business.NewH5ImManager;
import com.vhall.business.VhallSDK;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.WebinarInfo;


/**
 * @author hkl
 * Date: 2022/11/14 14:21
 */
public class SignServer implements ISign {

    private WebinarInfo webinarInfo;
    private Context context;
    private SignMessageCallBack signMessageCallBack;

    private void SignServer() {

    }

    private SignServer(Builder builder) {
        this.context = builder.context;
        this.webinarInfo = builder.webinarInfo;
        this.signMessageCallBack = builder.signMessageCallBack;
        if (signMessageCallBack != null) {
            NewH5ImManager.getInstance().setMessageCallBackMap(KEY_MESSAGE_SIGN, signMessageCallBack);
        }
    }

    @Override
    public void performSignIn(String signId, RequestCallback callBack) {
        if (webinarInfo != null) {
            VhallSDK.performSignIn(webinarInfo.vss_room_id, signId, callBack);
        } else {
            if (callBack != null) {
                callBack.onError(-1, "webinarInfo can not be null");
            }
        }

    }



    public static class Builder {
        WebinarInfo webinarInfo;
        Context context;
        SignMessageCallBack signMessageCallBack;

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder signMessageCallBack(SignMessageCallBack signMessageCallBack) {
            this.signMessageCallBack = signMessageCallBack;
            return this;
        }

        public Builder webinarInfo(WebinarInfo webinarInfo) {
            this.webinarInfo = webinarInfo;
            return this;
        }

        public SignServer build() {
            if (webinarInfo == null) {
                throw new IllegalArgumentException("webinarInfo can not be null");
            }else if(webinarInfo.is_new_version == 3 && (webinarInfo.getWebinarInfoData() == null || webinarInfo.getWebinarInfoData().interact == null)){
                throw new IllegalArgumentException("webinarInfo can not be null");
            }
            return new SignServer(this);
        }
    }
}