package com.vhall.business.module.notice;

import static com.vhall.business.module.message.IMessageCallBack.*;

import android.content.Context;

import com.vhall.business.NewH5ImManager;
import com.vhall.business.VhallSDK;
import com.vhall.business.common.LogReportKs;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.data.RequestDataCallbackV2;
import com.vhall.business.data.WebinarInfo;
import com.vhall.vhss.data.NoticeListInfoData;

/**
 * @author hkl
 * Date: 2022/11/14 14:21
 */
public class NoticeServer implements INotice {

    private WebinarInfo webinarInfo;
    private Context context;
    private NoticeMessageCallBack noticeMessageCallBack;

    private void NoticeServer() {

    }

    private NoticeServer(Builder builder) {
        this.context = builder.context;
        this.webinarInfo = builder.webinarInfo;
        this.noticeMessageCallBack = builder.noticeMessageCallBack;
        if (noticeMessageCallBack != null) {
            NewH5ImManager.getInstance().setMessageCallBackMap(KEY_MESSAGE_NOTICE, noticeMessageCallBack);
        }
        LogReportManager.doReport(LogReportKs.K_LIVE_ANNOUNCEMENT_INIT);
    }


    @Override
    public void getNoticeList(int page, int limit, RequestDataCallbackV2<NoticeListInfoData> callBack) {
        if (webinarInfo != null) {
            VhallSDK.getNoticeList(webinarInfo.vss_room_id, page,limit, callBack);
        } else {
            if (callBack != null) {
                callBack.onError(-1, "webinarInfo can not be null");
            }
        }

    }


    public static class Builder {
        WebinarInfo webinarInfo;
        Context context;
        NoticeMessageCallBack noticeMessageCallBack;

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder noticeMessageCallBack(NoticeMessageCallBack noticeMessageCallBack) {
            this.noticeMessageCallBack = noticeMessageCallBack;
            return this;
        }

        public Builder webinarInfo(WebinarInfo webinarInfo) {
            this.webinarInfo = webinarInfo;
            return this;
        }

        public NoticeServer build() {
            if (webinarInfo == null) {
                throw new IllegalArgumentException("webinarInfo can not be null");
            }else if(webinarInfo.is_new_version == 3 && (webinarInfo.getWebinarInfoData() == null || webinarInfo.getWebinarInfoData().interact == null)){
                throw new IllegalArgumentException("webinarInfo can not be null");
            }
            return new NoticeServer(this);
        }
    }
}