package com.vhall.business.module.exam;

import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.RequestDataCallbackV2;
import com.vhall.vhss.data.ExamAnswerPaperHistoryData;
import com.vhall.vhss.data.ExamInfoData;
import com.vhall.vhss.data.ExamListData;
import com.vhall.vhss.data.ExamRankListData;
import com.vhall.vhss.data.ExamScoreInfoData;
import com.vhall.vhss.data.ExamUserFormCheckData;
import com.vhall.vhss.data.ExamUserFormData;

/**
 * @author hkl
 * Date: 2022/11/14 16:09
 */
interface IExam {

    /**
     * 观看端 答题前置条件检查
     */
    void examUserFormCheck(String user_name, String head_img, String mobile, RequestDataCallbackV2<ExamUserFormCheckData> callBack);

    /**
     * 观看端 初始化用户表单
     */
    void examGetUserFormInfo(String paper_id, RequestDataCallbackV2<ExamUserFormData> callBack);

    /**
     * 发送验证码
     */
    void examSendVerifyCode(String phone, String country_code, RequestCallback callBack);

    /**
     * 验证验证码
     */
    void examVerifyCode(String paper_id, String phone, String verify_code, String country_code, RequestCallback callBack);


    /**
     * 保存用户表单信息
     */
    void examSaveUserForm(String paper_id,String user_detail, String verify_code, RequestCallback callBack);

    /**
     * 获取场次已推送试卷列表
     */
    void examGetPushedPaperList(RequestDataCallbackV2<ExamListData> callBack);

    /**
     * 获取试卷详情
     */
    void examGetPaperInfoForWatch(String paper_id, RequestDataCallbackV2<ExamInfoData> callBack);

    /**
     * 单题提交
     */
    void examAnswerQuestion(String paper_id, String user_answer, String question_id, RequestCallback callBack);


    /**
     * 主动交卷
     */
    void examInitiativeSubmitPaper(String paper_id, RequestCallback callBack);


    /**
     * 获取已答题记录断点续答
     */
    void examGetUserAnswerPaperHistory(String paper_id, RequestDataCallbackV2<ExamAnswerPaperHistoryData> callBack);


    /**
     * 获取榜单信息
     */
    void examGetSimpleRankList(String paper_id, String pos, String limit, RequestDataCallbackV2<ExamRankListData> callBack);


    /**
     * 获取个人成绩
     */
    void examPersonScoreInfo(String paper_id, RequestDataCallbackV2<ExamScoreInfoData> callBack);

    String getExamUrl(String paper_id);

    String getExamRankUrl(String paper_id);

}
