package com.vhall.business.impl;
import android.text.TextUtils;

import com.vhall.business.ErrorCode;
import com.vhall.business.VhallCallback;
import com.vhall.business.VhallSDK;
import com.vhall.business.core.antation.VHNonNullParams;
import com.vhall.business.core.antation.VHVerifyLoginMethod;
import com.vhall.business.impl.exception.VHNOLoginException;
import com.vhall.business.impl.exception.VHParamsEmptyException;
import com.vhall.business.impl.process.IExceptionProcessor;
import com.vhall.business.impl.process.NoLoginExceptionProcessor;
import com.vhall.business.impl.process.ParamsEmptyExceptionProcessor;
import com.vhall.business.utils.VHInternalUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class VHProxyHandler implements InvocationHandler {
    private Object mOrigin;

    public VHProxyHandler(Object mOrigin) {
        this.mOrigin = mOrigin;
    }

    static List<IExceptionProcessor> sProcessors = new ArrayList<>();
    static {
        sProcessors.add(new NoLoginExceptionProcessor());
        sProcessors.add(new ParamsEmptyExceptionProcessor());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            verifyNoLogin(method);
            verifyParamsNotNull(method,args);
        } catch (Exception e) {
            processVHException(e,args);
            return null;
        }
        method.getParameterAnnotations();
        return method.invoke(mOrigin,args);
    }


    private void processVHException(Exception e, Object[] args){
        if(e != null && args != null && args.length>0){
            if(args[args.length-1] instanceof VhallCallback.Callback){
                for (IExceptionProcessor processor:sProcessors){
                    processor.processException(e, (VhallCallback.Callback) args[args.length-1]);
                }
            }
        }

    }

    private void verifyNoLogin(Method method){
        Annotation[] annotations = method.getAnnotations();
        if(VHInternalUtils.isNotEmpty(annotations)){
            for (Annotation a:annotations){
                if(a instanceof VHVerifyLoginMethod){
                    if(VhallSDK.isLogin())
                        throw new VHNOLoginException();
                }
            }
        }
    }

    private void verifyParamsNotNull(Method method,Object[] args)  {
        Annotation[][] annotations = method.getParameterAnnotations();

        if(VHInternalUtils.isNotEmpty(annotations)){
            for (int i = 0;i<annotations.length;i++){
                if(VHInternalUtils.isNotEmpty(annotations[i])){
                    for (int j = 0;j<annotations[i].length;j++){
                        Annotation annotation = annotations[i][j];
                        if(annotation instanceof VHNonNullParams){
                            if(args[i] == null){
                                throw new VHParamsEmptyException();
                            }else if(args[i] instanceof String){
                                if(TextUtils.isEmpty(args[i].toString())){
                                    throw new VHParamsEmptyException();
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
