package com.vhall.business.impl;

import com.vhall.business.ErrorCode;
import com.vhall.business.NewH5ImManager;
import com.vhall.business.R;
import com.vhall.business.VhallSDK;
import com.vhall.business.core.IActionNetApi;
import com.vhall.business.data.LotteryPrizeListInfo;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.RequestDataCallback;
import com.vhall.business.data.RequestDataCallbackV2;
import com.vhall.business.data.WebinarInfoRemoteDataSource;
import com.vhall.business.data.source.WebinarInfoRepository;
import com.vhall.business.module.gift.GiftMessageCallBack;
import com.vhall.business.module.message.IMessageCallBack;
import com.vhall.business.support.VHDataConvert;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.data.AgreementData;
import com.vhall.vhss.data.LotteryCheckData;
import com.vhall.vhss.data.LotteryPrizeData;
import com.vhall.vhss.data.LotteryPrizeListData;
import com.vhall.vhss.data.LotteryWinnerListData;
import com.vhall.vhss.data.LotteryWinningDetailData;
import com.vhall.vhss.data.LotteryWinningUserInfoData;
import com.vhall.vhss.data.SurveyInfoData;
import com.vhall.vhss.data.TimerInfoData;
import com.vhall.vhss.network.ActivityNetworkRequest;
import com.vhall.vhss.network.InteractToolsNetworkRequest;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

import vhall.com.vss2.module.lottery.VssLotteryManager;
import vhall.com.vss2.module.room.VssRoomManager;
import vhall.com.vss2.module.sign.VssSignManager;

/**
 * @author hkl
 * Date: 2021/5/21 10:58 AM
 */
class ActionInternalApi implements IActionNetApi {
    @Override
    public void performSignIn(String webinarId, String signId, RequestCallback callback) {
        if (NewH5ImManager.enter) {
            InteractToolsNetworkRequest.signJoin(NewH5ImManager.getInstance().getRoomId(), signId, new VhssSimpleCallBack(callback));
        } else if (VssRoomManager.enter) {
            VssSignManager.getInstance().signIn(signId, new VssSimpleCallBack(callback));
        } else {
            WebinarInfoRepository repository = WebinarInfoRepository.getInstance(WebinarInfoRemoteDataSource.getInstance());
            repository.performSignIn(webinarId, VhallSDK.getUserId(), VhallSDK.getUserNickname(), signId, callback);
        }
    }

    @Override
    public void getHistorySurvey(String switchId, String room_id, String webinar_id, final RequestDataCallback callBack) {
        if (NewH5ImManager.enter)
            InteractToolsNetworkRequest.getHistorySurvey(switchId, room_id, webinar_id, new CallBack<ArrayList<SurveyInfoData>>() {
                @Override
                public void onSuccess(ArrayList<SurveyInfoData> result) {
                    if (callBack != null) {
                        callBack.onSuccess(result);
                    }
                }

                @Override
                public void onError(int eventCode, String msg) {
                    if (callBack != null) {
                        callBack.onError(eventCode, msg);
                    }
                }
            });
        else {
            if (callBack != null) {
                callBack.onError(ErrorCode.ERROR_NO_SUPPORT, VhallSDK.mContext.getString(R.string.error_no_support));
            }
        }
    }

    /**
     * 观看端-检查抽奖列表接口
     *
     * @param show_all 是否需要展示所有抽奖 0-否(默认：仅展示进行中、已中奖抽奖) 1-是 2 已中奖抽奖
     */

    @Override
    public void getHistoryLotteryList(String show_all, final RequestDataCallback callback) {
        if (NewH5ImManager.enter)
            InteractToolsNetworkRequest.getHistoryLotteryList(show_all, new CallBack<ArrayList<LotteryCheckData>>() {
                @Override
                public void onSuccess(ArrayList<LotteryCheckData> result) {
                    if (callback != null)
                        callback.onSuccess(result);
                }

                @Override
                public void onError(int eventCode, String msg) {
                    if (callback != null)
                        callback.onError(eventCode, msg);
                }
            });
        else {
            if (callback != null) {
                callback.onError(ErrorCode.ERROR_NO_SUPPORT, VhallSDK.mContext.getString(R.string.error_no_support));
            }
        }
    }

    @Override
    public void submitLotteryInfo(String join_id, String lottery_id, String name, String phone, String remark, RequestCallback callback) {
        if (VssRoomManager.enter) {
            VssLotteryManager.getInstance().lotteryAward(lottery_id, name, phone, remark, new VssSimpleCallBack(callback));
        } else if (NewH5ImManager.enter) {
            InteractToolsNetworkRequest.lotteryCommit(NewH5ImManager.getInstance().getRoomId(), lottery_id, name, phone, remark, new VhssSimpleCallBack(callback));
        } else {
            WebinarInfoRepository repository = WebinarInfoRepository.getInstance(WebinarInfoRemoteDataSource.getInstance());
            repository.submitLotteryInfo(join_id, lottery_id, name, phone, callback);
        }
    }
    @Override
    public void submitLotteryInfo(String lottery_id, List<LotteryPrizeListInfo> infoList, RequestCallback callback) {
        if (NewH5ImManager.enter) {
            String name = "";
            String phone = "";
            String remark = "";

            JSONArray remarkJson = new JSONArray();
            for (LotteryPrizeListInfo info : infoList) {
                if (info.field_key.equals("name")) {
                    name = info.field_value;
                } else
                if (info.field_key.equals("phone")) {
                    phone = info.field_value;
                }else{
                    remarkJson.put(info.getJson());
                }
            }
            remark  = remarkJson.toString();

            InteractToolsNetworkRequest.lotteryCommit(NewH5ImManager.getInstance().getRoomId(), lottery_id, name, phone, remark, new VhssSimpleCallBack(callback));
        } else {
            if (callback != null) {
                callback.onError(ErrorCode.ERROR_NO_SUPPORT, VhallSDK.mContext.getString(R.string.error_no_support));
            }
        }
    }
    @Override
    public void lotteryCheck(RequestDataCallback callBack) {
        if (NewH5ImManager.enter) {
            InteractToolsNetworkRequest.lotteryCheck(new VhssSimpleCallBack<LotteryCheckData>(callBack));
        } else {
            if (callBack != null) {
                callBack.onError(ErrorCode.ERROR_NO_SUPPORT, VhallSDK.mContext.getString(R.string.error_no_support));
            }
        }
    }

    @Override
    public void getPrizeInfo(String webinarId, final RequestDataCallback callBack) {
        if (NewH5ImManager.enter) {
            InteractToolsNetworkRequest.getPrizeInfo(webinarId, new VhssSimpleCallBack<ArrayList<LotteryPrizeListData>>(callBack, VHDataConvert.GET_PRIZE_INFO_DATA_CONVERT));
        } else {
            if (callBack != null) {
                callBack.onError(ErrorCode.ERROR_NO_SUPPORT, VhallSDK.mContext.getString(R.string.error_no_support));
            }
        }
    }

    @Override
    public void getPrizeInfo(String webinarId, String lottery_id, RequestDataCallback callBack) {
        if (NewH5ImManager.enter) {
            InteractToolsNetworkRequest.getPrizeInfo(webinarId,lottery_id, new VhssSimpleCallBack<LotteryPrizeData>(callBack, VHDataConvert.GET_PRIZE_INFO_DATA_CONVERT1));
        } else {
            if (callBack != null) {
                callBack.onError(ErrorCode.ERROR_NO_SUPPORT, VhallSDK.mContext.getString(R.string.error_no_support));
            }
        }
    }

    @Override
    public void getLotteryWinner(String room_id, String lottery_id, RequestDataCallback callBack) {
        if (NewH5ImManager.enter) {
            InteractToolsNetworkRequest.lotteryGetWinner(room_id, lottery_id, new VhssSimpleCallBack<LotteryWinnerListData>(callBack, VHDataConvert.GET_LOTTERY_WINNER_DATA_CONVERT));
        } else {
            if (callBack != null) {
                callBack.onError(ErrorCode.ERROR_NO_SUPPORT, VhallSDK.mContext.getString(R.string.error_no_support));
            }
        }
    }

    @Override
    public void joinCodeLottery(String room_id, String lottery_id, final String command, final RequestCallback callback) {
        if (NewH5ImManager.enter) {
            InteractToolsNetworkRequest.lotteryJoin(room_id, lottery_id, new com.vhall.vhss.CallBack() {
                @Override
                public void onSuccess(Object result) {
                    NewH5ImManager.getInstance().sendMsg(command, "", null);
                    if (callback != null) {
                        callback.onSuccess();
                    }
                }

                @Override
                public void onError(int eventCode, String msg) {
                    if (callback != null) {
                        callback.onError(eventCode, msg);
                    }
                }
            });
        } else {
            if (callback != null) {
                callback.onError(ErrorCode.ERROR_NO_SUPPORT, VhallSDK.mContext.getString(R.string.error_no_support));
            }
        }
    }

    @Override
    public void getAgreement(String room_id, final RequestDataCallback callback) {
        ActivityNetworkRequest.getAgreement(room_id, new com.vhall.vhss.CallBack<AgreementData>() {
            @Override
            public void onSuccess(AgreementData result) {
                if (callback != null) {
                    callback.onSuccess(result);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callback != null) {
                    callback.onError(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void setUserAgreeAgreement(String room_id, final RequestCallback callback) {
        ActivityNetworkRequest.setUserAgreeAgreement(room_id, new com.vhall.vhss.CallBack() {
            @Override
            public void onSuccess(Object result) {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callback != null) {
                    callback.onError(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void getTimerInfo(RequestDataCallbackV2<TimerInfoData> callback) {
        InteractToolsNetworkRequest.getTimerInfo(new CallBack<TimerInfoData>() {
            @Override
            public void onSuccess(TimerInfoData result) {
                if (callback != null) {
                    callback.onSuccess(result);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callback != null) {
                    callback.onError(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void userLike(String room_id, String num, RequestCallback callback) {
        InteractToolsNetworkRequest.userLike(room_id, num, new VhssSimpleCallBack(callback));
    }

    @Override
    public void getRoomLike(String room_id, RequestDataCallbackV2<Integer> callback) {
        InteractToolsNetworkRequest.getRoomLike(room_id, new CallBack<Integer>() {
            @Override
            public void onSuccess(Integer result) {
                if (callback != null) {
                    callback.onSuccess(result);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callback != null) {
                    callback.onError(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void getAllLike(RequestDataCallbackV2<Integer> callback) {
        InteractToolsNetworkRequest.getAllLike(new CallBack<Integer>() {
            @Override
            public void onSuccess(Integer result) {
                if (callback != null) {
                    callback.onSuccess(result);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callback != null) {
                    callback.onError(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void lotteryWinningDetail(String room_id, String lottery_id, RequestDataCallbackV2<LotteryWinningDetailData> callBack) {
        InteractToolsNetworkRequest.lotteryWinningDetail(room_id, lottery_id, new VhssSimpleCallBack<LotteryWinningDetailData>(callBack));
    }

    @Override
    public void lotteryWinningUserInfo(String room_id, RequestDataCallbackV2<LotteryWinningUserInfoData> callBack) {
        InteractToolsNetworkRequest.lotteryWinningUserInfo(room_id, new VhssSimpleCallBack<LotteryWinningUserInfoData>(callBack));

    }
}