package com.vhall.business.data.source.remote;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;

import com.vhall.business.ErrorCode;
import com.vhall.business.VhallCallback;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.UserInfo;
import com.vhall.business.data.UserInfoData;
import com.vhall.business.data.source.UserInfoDataSource;
import com.vhall.business.HttpDataSource;
import com.vhall.framework.VhallSDK;
import com.vhall.logmanager.VLog;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.util.HashMap;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.RequestBody;
import okhttp3.Response;

public class UserInfoRemoteDataSource implements UserInfoDataSource {


    private static UserInfoRemoteDataSource INSTANCE;
    private static Handler mDelivery;

    private UserInfoRemoteDataSource() {
    }

    public static UserInfoRemoteDataSource getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UserInfoRemoteDataSource();
            mDelivery = new Handler(Looper.getMainLooper());
        }
        return INSTANCE;
    }

    @Override
    public void getUserInfoFromRemote(String username, String userpass, final UserInfoCallback callback) {
        HashMap<String, String> map = new HashMap<>();
        map.put("account", username);
        map.put("password", userpass);
        HttpDataSource.post("user/login", "login", map, new Callback() {
            @Override
            public void onFailure(Call call, final IOException e) {
                mDelivery.post(new Runnable() {
                    @Override
                    public void run() {
                        VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_DATA, e.getMessage());
                    }
                });
            }

            @Override
            public void onResponse(Call call, final Response response) throws IOException {
                final String resultStr = response.body().string();
                mDelivery.post(new Runnable() {
                    @Override
                    public void run() {
                        if (response.code() == 200) {
                            dealLoginResponse(resultStr, callback);
                        } else {
                            VhallCallback.ErrorCallback(callback, response.code(), response.message());
                        }
                    }
                });
            }
        });
    }

    @Override
    public void clearUserInfo(Context context) {

    }

    @Override
    public void sendChat(String url, String token, String content, final RequestCallback callback) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("text", content);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        RequestBody body = new FormBody.Builder().add("token", token).add("event", "msg").add("data", jsonObject.toString()).build();
        HttpDataSource.post(url, body, new okhttp3.Callback() {
            @Override
            public void onFailure(Call call, final IOException e) {
                mDelivery.post(new Runnable() {
                    @Override
                    public void run() {
                        VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_DATA, e.getMessage());
                    }
                });
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                mDelivery.post(new Runnable() {
                    @Override
                    public void run() {
                        callback.onSuccess();
                    }
                });
            }
        });

    }

    @Override
    public void sendCustom(String url, String token, JSONObject content, final RequestCallback callback) {
        RequestBody body;
        if (content.length() <= 0 && content == null) {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("data", new JSONObject());
            } catch (JSONException e) {
                e.printStackTrace();
            }
            body = new FormBody.Builder().add("app_name", "vhall").add("token", token).add("event", "custom_broadcast").add("data", jsonObject.toString()).build();
        } else {
            body = new FormBody.Builder().add("app_name", "vhall").add("token", token).add("event", "custom_broadcast").add("data", content.toString()).build();
        }

        HttpDataSource.post(url, body, new okhttp3.Callback() {
            @Override
            public void onFailure(Call call, final IOException e) {
                mDelivery.post(new Runnable() {
                    @Override
                    public void run() {
                        VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_DATA, e.getMessage());
                    }
                });
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                mDelivery.post(new Runnable() {
                    @Override
                    public void run() {
                        callback.onSuccess();
                    }
                });
            }
        });
    }

    @Override
    public void sendComment(String webinar_id, String content, String user_id, final RequestCallback callback) {

        HashMap<String, String> map = new HashMap<>();
        map.put("webinar_id", webinar_id);
        map.put("content", content);
        map.put("user_id", user_id);
        HttpDataSource.post("user/send-comment", "send-comment", map, new Callback() {
            @Override
            public void onFailure(Call call, final IOException e) {
                mDelivery.post(new Runnable() {
                    @Override
                    public void run() {
                        VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_DATA, e.getMessage());
                    }
                });
            }

            @Override
            public void onResponse(Call call, final Response response) throws IOException {
                final String resultStr = response.body().string();
                mDelivery.post(new Runnable() {
                    @Override
                    public void run() {
                        if (response.code() == 200) {
                            try {
                                JSONObject result = new JSONObject(resultStr);
                                String msg = result.optString("msg");
                                int code = result.optInt("code");
                                if (code == 200) {
                                    callback.onSuccess();
                                } else {
                                    VhallCallback.ErrorCallback(callback, code, msg);
                                }
                            } catch (JSONException e) {
                                VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_DATA, e.getMessage());
                                e.printStackTrace();
                            } catch (Exception e) {
                                VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_DATA, e.getMessage());
                                e.printStackTrace();
                            }
                        } else {
                            VhallCallback.ErrorCallback(callback, response.code(), response.message());
                        }
                    }
                });
            }
        });
    }

    @Override
    public void sendQuestion(String user_id, String webinar_id, String content, final RequestCallback callback) {
        HashMap<String, String> map = new HashMap<>();
        map.put("user_id", user_id);
        map.put("webinar_id", webinar_id);
        map.put("content", content);
        HttpDataSource.post("question/addques", "addques", map, new Callback() {
            @Override
            public void onFailure(Call call, final IOException e) {
                mDelivery.post(new Runnable() {
                    @Override
                    public void run() {
                        VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_DATA, e.getMessage());
                    }
                });
            }

            @Override
            public void onResponse(Call call, final Response response) throws IOException {
                final String resultStr = response.body().string();
                if (callback != null) {
                    mDelivery.post(new Runnable() {
                        @Override
                        public void run() {
                            if (response.code() == 200) {
                                dealQuestionResult(resultStr, callback);
                            } else {
                                VhallCallback.ErrorCallback(callback, response.code(), response.message());
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public void saveAppkey(Context mContext, String app_key) {

    }

    @Override
    public String getAppkey(Context mContext) {
        return null;
    }

    private void dealLoginResponse(String responseStr, UserInfoCallback callback) {
        if (callback == null) {
            return;
        }
        try {
            JSONObject result = new JSONObject(responseStr);
            String msg = result.optString("msg");
            int code = result.optInt("code");
            if (code == 200) {
                JSONObject data = result.getJSONObject("data");
                UserInfo userInfo = new UserInfo();
                userInfo.user_id = data.optString("user_id");
                userInfo.account = data.optString("account");
                userInfo.avatar = data.optString("avatar");
                userInfo.nick_name = data.optString("nick_name");
                VLog.e("userinfo", data.toString());
                callback.onSuccess(userInfo);
                //登录成功设置PaaS SDK UserInfo
                VhallSDK.getInstance().setUserInfo(new UserInfoData(userInfo.user_id, userInfo.nick_name, userInfo.avatar, "2", "3", "1", "0", "0", com.vhall.business.VhallSDK.third_account_id).toJsonString());
            } else {
                VhallCallback.ErrorCallback(callback, code, msg);
            }
        } catch (JSONException e) {
            VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_DATA, e.getMessage());
            e.printStackTrace();
        } catch (Exception e) {
            VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_DATA, e.getMessage());
            e.printStackTrace();
        }
    }

    private void dealQuestionResult(String responseStr, RequestCallback callback) {
        try {
            JSONObject result = new JSONObject(responseStr);
            String msg = result.optString("msg");
            int code = result.optInt("code");
            if (code == 200) {
                callback.onSuccess();
            } else {
                VhallCallback.ErrorCallback(callback, code, msg);
            }
        } catch (JSONException e) {
            VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_DATA, e.getMessage());
            e.printStackTrace();
        } catch (Exception e) {
            VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_DATA, e.getMessage());
            e.printStackTrace();
        }
    }
}
