package com.vhall.business.data.source.remote;

import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;

import com.vhall.business.data.WebinarInfo;
import com.vhall.business.data.source.PlaybackDocumentDataSource;
import com.vhall.business.utils.FileUtil;

import java.io.File;

public class PlaybackDocumentRemoteDataSource implements PlaybackDocumentDataSource {
    private static PlaybackDocumentRemoteDataSource INSTANCE;

    private PlaybackDocumentRemoteDataSource() {
    }

    public static PlaybackDocumentRemoteDataSource getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlaybackDocumentRemoteDataSource();
        }
        return INSTANCE;
    }

    @Override
    public void getDocumentList(final WebinarInfo webinarInfo, final LoadDocumentCallback callback) {
        String fileName = FileUtil.getFileName(webinarInfo.docurl);
        if (TextUtils.isEmpty(fileName)) {
            callback.onDataNotAvailable("无文档！");
            return;
        }
        final File localFile = new File(FileUtil.getCacheDir(), fileName);
        if (localFile != null) {
            if (localFile.exists()) {
                localFile.delete();
            }
            FileUtil.downloadFile(localFile.getAbsolutePath(), webinarInfo.docurl, new Handler() {
                @Override
                public void handleMessage(Message msg) {
                    super.handleMessage(msg);
                    switch (msg.what) {
                        case 0://下载失败
                            callback.onDataNotAvailable("下载失败！");
                            break;
                        case 1://下载成功、解析
                            webinarInfo.doc_local_url = localFile.getAbsolutePath();
                            callback.onLoaded(webinarInfo, null);
                            break;
                        case 2://下载进度
                            break;
                        default:
                            break;
                    }
                }
            });
        }
    }
}