package com.vhall.business.data.source;

import android.content.Context;

import com.vhall.business.VhallCallback;
import com.vhall.business.VhallSDK;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.UserInfo;

import org.json.JSONObject;

public interface UserInfoDataSource {

    public interface UserInfoCallback extends VhallCallback.Callback {
        void onSuccess(UserInfo userInfo);
    }

    void getUserInfoFromRemote(String username, String userpass, UserInfoCallback callback);


    void clearUserInfo(Context context);

    void sendChat(String url, String token, String content, RequestCallback callback);

    void sendCustom(String url, String token, JSONObject content, RequestCallback callback);

    void sendComment(String webinar_id, String content, String user_id, RequestCallback callback);

    void sendQuestion(String user_id, String webinar_id, String content, RequestCallback callback);

    void saveAppkey(Context mContext ,String app_key);

    String getAppkey(Context mContext );
}
