package com.vhall.business.data.source;

import com.vhall.business.data.RequestCallback;

public class InteractiveRepository implements InteractiveDataSource {
    private static InteractiveRepository INSTANCE;

    private final InteractiveDataSource mInteractiveDataSource;

    private InteractiveRepository(InteractiveDataSource mInteractiveDataSource) {
        this.mInteractiveDataSource = mInteractiveDataSource;
    }

    public static InteractiveRepository getInstance(InteractiveDataSource mInteractiveDataSource) {
        if (INSTANCE == null) {
            INSTANCE = new InteractiveRepository(mInteractiveDataSource);
        }
        return INSTANCE;
    }

    @Override
    public void onSwitchDevice(String joinId, String webinarId, int device, int type, String receiveId, RequestCallback callback) {
        mInteractiveDataSource.onSwitchDevice(joinId, webinarId, device, type, receiveId, callback);
    }

    @Override
    public void onDownMic(String joinId, String webinarId, String receiveId, RequestCallback callback) {
        mInteractiveDataSource.onDownMic(joinId, webinarId, receiveId, callback);
    }
}
