package com.vhall.business.data;

import vhall.com.vss2.CallBack;

/**
 * @author hkl
 * Date: 2020/10/10 10:17 AM
 */
public class CallBackLister implements CallBack {

   private RequestCallback callBack;

    public CallBackLister(RequestCallback callBack) {
        this.callBack = callBack;
    }

    @Override
    public void onSuccess(Object result) {
        if (callBack==null){
            return;
        }
        callBack.onSuccess();
    }

    @Override
    public void onError(int eventCode, String msg) {
        if (callBack==null){
            return;
        }
        callBack.onError(eventCode,msg);
    }
}
