package com.vhall.business.core;
import com.vhall.business.core.antation.VHNonNullParams;
import com.vhall.business.core.antation.VHVerifyLoginMethod;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.RequestDataCallback;
import com.vhall.business.data.RequestDataCallbackV2;
import com.vhall.business.data.source.WebinarInfoDataSource;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.data.DocListInfoData;
import com.vhall.vhss.data.GuestJoinInfoData;
import com.vhall.vhss.data.PrivilegeInfoData;
import com.vhall.vhss.data.UserStateListData;

public interface IInteractiveNetApi {

    void agreeApply(@VHNonNullParams String room_id, @VHNonNullParams String receive_account_id, RequestCallback callBack);

    void rejectApply(@VHNonNullParams String room_id, @VHNonNullParams String receive_account_id, RequestCallback callBack);

    void rejectInvite(@VHNonNullParams String room_id, RequestCallback callBack);


    void agreeInvite(@VHNonNullParams String room_id, RequestCallback callBack);

    void setMainScreen(@VHNonNullParams String room_id, @VHNonNullParams String receive_account_id, RequestCallback callBack);

    void setDeviceStatus(@VHNonNullParams String room_id, @VHNonNullParams String receive_account_id, @VHNonNullParams String device, @VHNonNullParams String status, RequestCallback callBack);

    void getDocList(@VHNonNullParams String webinar_id, @VHNonNullParams String room_id, int page, int limit, String keyword, RequestDataCallbackV2<DocListInfoData> callBack);

    void setMainSpeaker(@VHNonNullParams String room_id, @VHNonNullParams String receive_account_id, RequestCallback callBack);

    void downMic(@VHNonNullParams String room_id, @VHNonNullParams String receive_account_id, RequestCallback callBack);

    void inviteUserSpeak(@VHNonNullParams String room_id, @VHNonNullParams String receive_account_id, RequestCallback callBack);


    void getLimitUserList(@VHNonNullParams String room_id, int pos, int limit, RequestDataCallbackV2<UserStateListData> callBack);


    void getOnlineUserList(@VHNonNullParams String room_id, int pos, int limit, RequestDataCallbackV2<UserStateListData> callBack);


    void setKickOut(@VHNonNullParams String room_id, @VHNonNullParams String channel_id, @VHNonNullParams String receive_account_id, @VHNonNullParams String status, RequestCallback callBack);


    void setBanned(@VHNonNullParams String room_id, @VHNonNullParams String channel_id, @VHNonNullParams String receive_account_id, @VHNonNullParams String status, RequestCallback callBack);


    void setUserNoSpeak(@VHNonNullParams String room_id, RequestCallback callBack);

    void cancelApply(@VHNonNullParams String room_id, RequestCallback callBack);


    void apply(@VHNonNullParams String room_id, RequestCallback callBack);

    void setHandsUp(@VHNonNullParams String room_id, @VHNonNullParams String status, RequestCallback callBack);

    void joinWebinar(@VHNonNullParams String webinarId, @VHNonNullParams String password, @VHNonNullParams String nickname, String avatar, @VHNonNullParams String type, WebinarInfoDataSource.LoadWebinarInfoCallback callBack);


    void getRoundUsers(@VHNonNullParams String room_id ,String isNext, RequestDataCallback callBack);


}
