package com.vhall.business.core;

import com.vhall.business.data.LotteryPrizeListInfo;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.RequestDataCallback;
import com.vhall.business.data.RequestDataCallbackV2;
import com.vhall.vhss.data.DocListInfoData;
import com.vhall.vhss.data.LotteryWinningDetailData;
import com.vhall.vhss.data.LotteryWinningUserInfoData;
import com.vhall.vhss.data.TimerInfoData;
import com.vhall.vhss.data.UserStateListData;

import java.util.List;

/**
 * 抽奖 等活动接口
 */
public interface IActionNetApi {

    void performSignIn(String webinarId, String signId, RequestCallback callback);

    void getHistorySurvey(String switchId, String room_id, String webinarId, RequestDataCallback callback);

    void getHistoryLotteryList(String show_all, RequestDataCallback callback);

    void submitLotteryInfo(String join_id, String lottery_id, String name, String phone, String remark, final RequestCallback callback);
    void submitLotteryInfo(String lottery_id, List<LotteryPrizeListInfo> infoList, final RequestCallback callback);

    void lotteryCheck(final RequestDataCallback callBack);

    void getPrizeInfo(String webinarId, final RequestDataCallback callBack);
    void getPrizeInfo(String webinarId, String lottery_id, final RequestDataCallback callBack);

    void getLotteryWinner(String room_id, String lottery_id, final RequestDataCallback callBack);

    void joinCodeLottery(String room_id, String lottery_id, final String command, final RequestCallback callback);

    void getAgreement(String room_id, final RequestDataCallback callback);

    void setUserAgreeAgreement(String room_id, final RequestCallback callback);

    void getTimerInfo(RequestDataCallbackV2<TimerInfoData> callback);

    void userLike(String room_id, String num, RequestCallback callback);

    void getRoomLike(String room_id, RequestDataCallbackV2<Integer> callback);

    void getAllLike(RequestDataCallbackV2<Integer> callback);

    void lotteryWinningDetail(String room_id, String lottery_id, RequestDataCallbackV2<LotteryWinningDetailData> callback);

    void lotteryWinningUserInfo(String room_id, RequestDataCallbackV2<LotteryWinningUserInfoData> callback);
}
