package com.vhall.business.common;

import android.text.TextUtils;

import com.vhall.business.VhallSDK;
import com.vhall.logmanager.BuildConfig;
import com.vhall.logmanager.LogInfo;
import com.vhall.logmanager.LogReporter;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Date;

/**
 * @author：vhall Email：jooperge@163.com
 * 描述：日志上报管理器
 * 修改历史:
 * <p>
 * 创建于： 2023/2/16
 */
public class LogReportManager {
    public static void doReport(String key) {
        doReport(key, null, null);
    }

    /**
     *
     * @param key
     * @param paramKeys     待上报字段的key数组
     * @param paramValues   待上报字段的value数组
     */
    public static void doReport(String key, String[] paramKeys, String[] paramValues) {
        JSONObject paramJson = null;
        if (null != paramKeys) {
            paramJson = new JSONObject();
            for (int i = 0; i < paramKeys.length; i++) {
                try {
                    paramJson.put(paramKeys[i], paramValues[i]);
                } catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        LogReporter.getInstance().onCollectionWithBData(key, paramJson);
    }

    public static void doReportToDataHub(String host, String app_id, JSONObject jsonObject) {



        LogReporter.getInstance().reportToDataHub(host, app_id,jsonObject,new Date().getTime() / 1000,true);
    }

    public static JSONObject addComParams(JSONObject params) throws JSONException {
        if (params == null) {
            params = new JSONObject();
        }

        params.put("business_uid", "");//	B端租户账号ID
        params.put("user_id", "");//	用户ID
        params.put("visitor_id", "");//	游客ID
        params.put("role_name", "");//	用户类型
        params.put("event_type", "");//	站点类型
        params.put("website_id", "");//	聚合站点ID
        params.put("series_id", "");//	系列会ID
        params.put("page_id", "");//	落地页ID
        params.put("page_type", "");//	页面类型
        params.put("webinar_id", "");//	活动ID
        params.put("webinar_type", "");//	直播类型
        params.put("webinar_status", "");//	活动状态
        params.put("room_id", "");//	PaaS房间id房间ID
        params.put("switch_id", "");//	直播场次ID
        params.put("record_id", "");//	回放ID
        params.put("language_type", "cn");//	语言类型
        params.put("watch_device", 2);//	终端类型
        params.put("channel", "");//	渠道
        params.put("biz_notice_type", "");//	邀约短信类型
        params.put("sharer_id", "");//	分享人ID
        params.put("url", "");//	页面url
        params.put("report_source_id", 3);//	上报来源标识

        return params;
    }
}