package com.vhall.business.common;

import android.content.Context;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
@Deprecated
public class LiveParam implements Constants {

    private static String blacklist = "{\n" +
            "  \"MI 4LTE\" : {\n" +
            "    \"1080p\" : {\n" +
            "      \"10fps\" : true,\n" +
            "      \"15fps\" : false,\n" +
            "      \"25fps\" : false\n" +
            "    },\n" +
            "    \"480p\" : {\n" +
            "      \"10fps\" : true,\n" +
            "      \"15fps\" : true,\n" +
            "      \"25fps\" : true\n" +
            "    },\n" +
            "    \"720p\" : {\n" +
            "      \"10fps\" : true,\n" +
            "      \"15fps\" : false,\n" +
            "      \"25fps\" : false\n" +
            "    }\n" +
            "  },\n" +
            "  \"HUAWEI P7-L07\" : {\n" +
            "    \"1080p\" : {\n" +
            "      \"10fps\" : false,\n" +
            "      \"15fps\" : false,\n" +
            "      \"25fps\" : false\n" +
            "    },\n" +
            "    \"480p\" : {\n" +
            "      \"10fps\" : true,\n" +
            "      \"15fps\" : true,\n" +
            "      \"25fps\" : false\n" +
            "    },\n" +
            "    \"720p\" : {\n" +
            "      \"10fps\" : false,\n" +
            "      \"15fps\" : false,\n" +
            "      \"25fps\" : false\n" +
            "    }\n" +
            "  }\n" +
            "}";

    private static final String TAG = "LiveParam";

    //底层编码数据的支持格式
    public enum EncodePixFmt {
        kEncodePixFmtYuv420spNV21(0),
        kEncodePixFmtYUV420spNV12(1),//NV12
        kEncodePixFmtYUV420pYV21(2),
        kEncodePixFmtYUV420pYV12(3);
        private int _value;
        private EncodePixFmt(int value) {
            _value = value;
        }

        public int getValue() {
            return _value;
        }
    }

    //视频编码模式
    public enum VideoEncoderMode {
        kVideoEncoderModeSoftware(0),
        kVideoEncoderModeHardware(1);
        private int _value;

        private VideoEncoderMode(int value) {
            _value = value;
        }

        public int getValue() {
            return _value;
        }
    }

    //视频解码模式
    public enum VideoDecoderMode {
        kVideoDecoderModeSoftware(1),
        kVideoDecoderModeHardware(2);
        private int _value;

        private VideoDecoderMode(int value) {
            _value = value;
        }

        public int getValue() {
            return _value;
        }
    }

    //推流模式
    public enum LivePublishModel {
        kLivePublishModelNone(0),
        kLivePublishModelVideoAndAudio(1),
        kLivePublishModelOnlyVideo(2),
        kLivePublishModelOnlyAudio(3);
        private int _value;

        private LivePublishModel(int value) {
            _value = value;
        }

        public int getValue() {
            return _value;
        }
    }

    public enum VHallStreamType {
        kVHallStreamTypeNone(0),
        kVHallStreamTypeVideoAndAudio(1),
        kVHallStreamTypeOnlyVideo(2),
        kVHallStreamTypeOnlyAudio(3);
        private int _value;

        private VHallStreamType(int value) {
            _value = value;
        }

        public int getValue() {
            return _value;
        }
    }

    public enum LiveFormat {
        kLiveFormatNone(0),
        kLiveFormatRtmp(1),
        kLiveFormatFlV(2);
        private int _value;

        private LiveFormat(int value) {
            _value = value;
        }

        public int getValue() {
            return _value;
        }
    }

    public enum VHAVSampleFormat{
        VH_AV_SAMPLE_FMT_NONE(-1),
        VH_AV_SAMPLE_FMT_U8(0),          ///< unsigned 8 bits
        VH_AV_SAMPLE_FMT_S16(1),         ///< signed 16 bits
        VH_AV_SAMPLE_FMT_S32(2),         ///< signed 32 bits
        VH_AV_SAMPLE_FMT_FLT(3),         ///< float
        VH_AV_SAMPLE_FMT_DBL(4);         ///< double
        private int _value;
        private VHAVSampleFormat(int value){
            _value = value;
        }
        public int getValue(){
            return _value;
        }
    }

    // other
    /**
     * 系统 0代表IOS,1代表Android
     */
    private static final int platform = 5; //0代表iOSAPP 1代表AndroidAPP 2代表flash 3代表wap 4代表IOSSDK 5代表AndroidSDK 6代表小助手
    /**
     * 设备类型
     */
    private static String device_type = android.os.Build.MODEL;
    /**
     * 系统标识 MAC地址
     */
    private static String device_identifier = "";

    private static PushParam push_param = null;
    private static WatchParam warch_param = null;

    public static String readTextFile(Context context, int resId) {
        InputStream inputStream = context.getResources().openRawResource(resId);
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        String line;
        StringBuilder result = new StringBuilder();
        try {
            while ((line = br.readLine()) != null) {
                result.append(line);
                result.append("\n");
            }
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return result.toString();
    }

    static public PushParam getPushParam() {
        if (push_param == null) {
            push_param = new PushParam();
        }
        return push_param;
    }

    static public WatchParam getWarchParam() {
        if (warch_param == null) {
            warch_param = new WatchParam();
        }
        return warch_param;
    }

    static public class PushParam {
        // video
        private int frame_rate = 15;
        public int video_width = 640;
        public int video_height = 480;
        public int video_bitrate = 400 * 1000;
        public int audio_bitrate = AUDIO_BITRATE;
        public int sample_rate = SAMPLE_RATE;
        public int channel_num = CHANNEL_NUM;
        private int src_sample_fmt  = VHAVSampleFormat.VH_AV_SAMPLE_FMT_S16.getValue();
        public int publish_timeout = 5000;
        public int publish_reconnect_times = 5;
        public int encode_type = VideoEncoderMode.kVideoEncoderModeSoftware.getValue();
        public int orientation = Screen_orientation_landscape; // 0是横屏 1是竖屏
        public int live_publish_model = LivePublishModel.kLivePublishModelVideoAndAudio.getValue();// see enum LivePublishModel
        public int encode_pix_fmt = EncodePixFmt.kEncodePixFmtYuv420spNV21.getValue(); //see enum EncodePixFmt
        private int pixel_type = TYPE_HDPI;
        public int live_format = LiveFormat.kLiveFormatRtmp.getValue();//直播流的格式 rtmp 或 flv

        private PushParam(){

        }

        /*public int getPixel_type() {
            return pixel_type;
        }

        public void setPixel_type(int pixel_type) {
            if (pixel_type != TYPE_HDPI && pixel_type != TYPE_XHDPI && pixel_type != TYPE_XXHDPI) {
                this.pixel_type = TYPE_HDPI;
            } else {
                this.pixel_type = pixel_type;
            }
            this.video_width = getVideoWidth(pixel_type);
            this.video_height = getVideoHeight(pixel_type);
        }*/

        public void setPixel(int with,int height){
            this.video_width = with;
            this.video_height = height;
        }

        public int getFrame_rate() {
            return frame_rate;
        }

        /**
         * 设置视频采集帧率，取值范围是［10～25］
         *
         * @param frame_rate 采集的帧率值
         */
        public void setFrame_rate(int frame_rate) {
            frame_rate = frame_rate < 10 ? 10 : frame_rate;
            frame_rate = frame_rate > 25 ? 25 : frame_rate;
            this.frame_rate = frame_rate;
        }

        /**
         * @return the video_width
         */
        private int getVideo_width() {
            return video_width;
        }

        /**
         * @return the video_height
         */
        private int getVideo_height() {
            return video_height;
        }

        private int mParamState;

        /**
         * @return 0 代表成功，-1代表设置但是帧率和分辨率被修改 -2设备不支持
         */
        public int getParamState() {
            return mParamState;
        }

        private class Section {
            public int max = 0;
            public int min = 0;
        }

        private Section fpsSection(JSONObject resolutionObj) throws JSONException {
            boolean is10fps = resolutionObj.optBoolean("10fps");
            boolean is15fps = resolutionObj.optBoolean("15fps");
            boolean is25fps = resolutionObj.optBoolean("25fps");
            Section section = new Section();
            if (is10fps) {
                section.min = 10;
            }
            if (is15fps) {
                section.max = 15;
            }
            if (is25fps) {
                section.max = 25;
            }
            if (section.max == 0) {
                section.max = section.min;
            }
            return section;
        }

        private void deviceFilter() {
            //LiveParam.blacklist = readTextFile(context,R.raw.blacklist);
            //LogManager.e(TAG,"blacklist json: "+blacklist);
            mParamState = 0;
            try {
                JSONObject object = new JSONObject(blacklist);
                if (!object.isNull(device_type)) {
                    JSONObject phone = object.getJSONObject(device_type);
                    switch (this.pixel_type) {
                        case TYPE_XXHDPI: {
                            JSONObject obj = phone.getJSONObject("1080p");
                            Section section = fpsSection(obj);
                            if (section.max == 0) {
                                mParamState = -1;
                                this.pixel_type = TYPE_XHDPI;
                            } else {
                                if (frame_rate > section.max) {
                                    frame_rate = section.max;
                                    mParamState = -1;
                                }
                                break;
                            }
                        }
                        case TYPE_XHDPI: {
                            JSONObject obj = phone.getJSONObject("720p");
                            Section section = fpsSection(obj);
                            if (section.max == 0) {
                                mParamState = -1;
                                this.pixel_type = TYPE_HDPI;
                            } else {
                                if (frame_rate > section.max) {
                                    frame_rate = section.max;
                                    mParamState = -1;
                                }
                                break;
                            }
                        }
                        case TYPE_HDPI: {
                            JSONObject obj = phone.getJSONObject("480p");
                            Section section = fpsSection(obj);
                            if (section.max == 0) {
                                mParamState = -2;
                            } else {
                                if (frame_rate > section.max) {
                                    frame_rate = section.max;
                                    mParamState = -1;
                                }
                                break;
                            }
                        }
                    }
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

        public String getParamStr() {
            deviceFilter();
            JSONObject obj = new JSONObject();
            try {
                if (this.orientation == Screen_orientation_landscape) {
                    obj.put("width", this.video_width);
                    obj.put("height", this.video_height);
                } else {
                    obj.put("width", this.video_height);
                    obj.put("height", this.video_width);
                }
                obj.put("frame_rate", this.frame_rate);
                obj.put("bit_rate", this.video_bitrate);
                obj.put("sample_rate", this.sample_rate);
                obj.put("ch_num", this.channel_num);
                obj.put("audio_bitrate", this.audio_bitrate);
                obj.put("publish_timeout", this.publish_timeout);
                obj.put("publish_reconnect_times", this.publish_reconnect_times);
                obj.put("live_publish_model", this.live_publish_model);
                obj.put("encode_pix_fmt", this.encode_pix_fmt);
                obj.put("encode_type", this.encode_type);
                obj.put("platform", LiveParam.platform);
                obj.put("device_type", LiveParam.device_type);
                obj.put("device_identifier", LiveParam.device_identifier);
                obj.put("live_format",this.live_format);
                obj.put("src_sample_fmt",src_sample_fmt);
            } catch (JSONException e) {
                e.printStackTrace();
            }
            return obj.toString();
        }
    }

    static public class WatchParam  {
        public int watch_timeout = 5000;
        public int watch_reconnect_times = 6;
        public int buffer_time = 6; // 视频缓存时间，缓存时间长，卡顿频率低，延时高
        private int video_decoder_mode = VideoDecoderMode.kVideoDecoderModeSoftware.getValue(); // see VideoDecoderMode
        public LiveFormat live_format = LiveFormat.kLiveFormatRtmp;//直播流的格式 rtmp 或 flv

        private WatchParam(){

        }
        public int getVideo_decoder_mode() {
            return video_decoder_mode;
        }

        public void setVideo_decoder_mode(int video_decoder_mode) {
            this.video_decoder_mode = video_decoder_mode;
        }

        public String getParamStr() {
            JSONObject obj = new JSONObject();
            try {
                obj.put("watch_timeout", this.watch_timeout);
                obj.put("watch_reconnect_times", this.watch_reconnect_times);
                obj.put("buffer_time", this.buffer_time);
                obj.put("video_decoder_mode", this.video_decoder_mode);
                obj.put("platform", LiveParam.platform);
                obj.put("device_type", LiveParam.device_type);
                obj.put("device_identifier", LiveParam.device_identifier);
                obj.put("live_format",this.live_format.getValue());
            } catch (JSONException e) {
                e.printStackTrace();
            }
            return obj.toString();
        }
    }

    public static final int getVideoWidth(int type) {
        int width = 0;
        switch (type) {
            case TYPE_HDPI:
                width = 640;
                break;
            case TYPE_XHDPI:
                width = 1280;
                break;
            case TYPE_XXHDPI:
                width = 1920;
                break;
            default:
                width = 640;
                break;
        }
        return width;
    }

    public static final int getVideoHeight(int type) {
        int height = 0;
        switch (type) {
            case TYPE_HDPI:
                height = 480;
                break;
            case TYPE_XHDPI:
                height = 720;
                break;
            case TYPE_XXHDPI:
                height = 1080;
                break;
            default:
                height = 480;
                break;
        }
        return height;
    }
}