package com.vhall.business.common;

import android.media.AudioFormat;

public interface Constants {

     enum DrawMode {
        kVHallDrawModeNone(0),
        kVHallDrawModeAspectFit(1),
        kVHallDrawModeAspectFill(2);
        private int _value;

        private DrawMode(int value) {
            _value = value;
        }

        public int getValue() {
            return _value;
        }
    }

    // 常量
    public static final int CAMERA_FRONT = 0;
    public static final int CAMERA_BACK = 1;

    public static final int Screen_orientation_landscape = 0;
    public static final int Screen_orientation_portrait = 1;

    public static final int TYPE_HDPI = 0x01;// 640*480
    public static final int TYPE_XHDPI = 0x02;// 1280*720
    public static final int TYPE_XXHDPI = 0x03;// 1920*1080

    // 音频常量、暂不支持自定义
    public static final int SAMPLE_RATE = 16000;
    public static final int AUDIO_FORMAT = AudioFormat.ENCODING_PCM_16BIT;
    public static final int CHANNEL_NUM = 1;
    public static final int AUDIO_BITRATE = 16 * 1000; // bps


    public static final String TYPE_H5 = "h5";
    public static final String TYPE_FLASH = "flash";
    public static final String TYPE_H5_NEW = "6";

    public static final int VhallStreamTypeOnlyAudio = 0;
    public static final int VhallStreamTypeOnlyVideo = 1;
    public static final int VhallStreamTypeAudioAndVideo = 2;
    public static final int VhallStreamTypeScreen = 3;
    public static final int VhallStreamTypeFile = 4;
    public static final int VhallStreamTypeVideoPatrol = 5;


}
