package com.vhall.business;

import static com.vhall.business.ErrorCode.ERROR_INIT;
import static com.vhall.business.ErrorCode.ERROR_NO_SUPPORT;
import static com.vhall.business.MessageServer.EVENT_PAINTH5DOC;
import static com.vhall.business.MessageServer.EVENT_SHOWH5DOC;
import static com.vhall.ops.VHOPS.KEY_OPERATE;
import static com.vhall.ops.VHOPS.TYPE_ACTIVE;
import static com.vhall.ops.VHOPS.TYPE_SWITCHOFF;
import static com.vhall.ops.VHOPS.TYPE_SWITCHON;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;

import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.impl.VhallNetApiFactory;
import com.vhall.ops.VHOPS;
import com.vhall.player.Constants;
import com.vhall.player.VHPlayerListener;
import com.vhall.player.stream.play.impl.VHVideoPlayerView;
import com.vhall.player.vod.VodPlayerView;
import com.vhall.vod.VHVodPlayer;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

import vhall.com.vss2.CallBack;
import vhall.com.vss2.data.ResponseChatInfo;
import vhall.com.vss2.data.ResponseRoomInfo;
import vhall.com.vss2.module.chat.VssChatManager;
import vhall.com.vss2.module.room.VssRoomManager;

/**
 * Created by zwp on 2018/12/27
 *
 * @author zwp
 */
public class WatchPlaybackH5 extends Playback {
    private static final String TAG = "WatchPlaybackNew";
    private VHVodPlayer mPlayer;
    VHOPS document;
    private ResponseRoomInfo roomInfo = null;


    WatchPlaybackH5(Builder builder) {
        context = builder.context;
        if (builder.surfaceView != null) {
            surfaceView = builder.surfaceView;
        } else if (builder.vodPlayerView != null) {
            vodPlayerView = builder.vodPlayerView;
        }
        listener = builder.listener;
        docEventCallback = builder.docCallback;
        chatCallback = builder.chatCallback;
        this.messageCallback = builder.messageCallback;
        mDelivery = new Handler(new Handler.Callback() {
            @Override
            public boolean handleMessage(Message msg) {
                if (msg.what == 0) {
                    if (mPlayer != null && mPlayer.isPlaying() && document != null) {
                        document.setTime(mPlayer.getPosition());
                    }
                }
                return false;
            }
        });
    }


    private boolean isPlaying = false;

    @Override
    public void setScaleType(int scaleType) {
        super.setScaleType(scaleType);
        if (mPlayer != null) {
            mPlayer.setDrawMode(scaleType);
        }
    }

    @Override
    public boolean isPlaying() {
        if (mPlayer != null) {
            return isPlaying;
        }
        return false;
    }

    @Override
    public void mute() {
        if (null != mPlayer) {
            mPlayer.mute();
        }
    }

    @Override
    public void unMute() {
        if (null != mPlayer) {
            mPlayer.unmute();
        }
    }

    private Timer timer;

    private void handlePosition() {
        timer = new Timer();
        timer.schedule(new TimerTask() {
            @Override
            public void run() {
                mDelivery.sendEmptyMessage(0);
            }
        }, 150, 150);
    }

    private VHPlayerListener innerListener = new VHPlayerListener() {
        @Override
        public void onStateChanged(Constants.State state) {
            switch (state) {
                case START:
                    isPlaying = true;
                    handlePosition();
                    break;
                case PAUSE:
                case STOP:
                case END:
                    isPlaying = false;
                    if (timer != null) {
                        timer.cancel();
                    }
                    break;
                default:
                    break;
            }
            if (listener != null) {
                listener.onStateChanged(state);
            }
        }

        @Override
        public void onEvent(int i, String s) {
            if (i == Constants.Event.EVENT_INIT_SUCCESS) {
                if (document != null) {
                    if (mPlayer == null) {
                        return;
                    }
                    document.setCue_point(mPlayer.getCurePoint());
                }
                if (listener != null) {
                    listener.onEvent(EVENT_INIT_PLAYER_SUCCESS, context.getString(R.string.event_init_play_success));
                }
            }
            if (listener != null) {
                listener.onEvent(i, s);
            }
        }

        @Override
        public void onError(int i, int i1, String s) {
            if (listener != null) {
                listener.onError(i, i1, s);
            }
        }
    };

    private VHOPS.EventListener opsListener = new VHOPS.EventListener() {
        @Override
        public void onEvent(String event, String type, String cid) {

            //message 消息回调
            if (event.equals(KEY_OPERATE)) {
                MessageServer.MsgInfo messageInfo = null;
                //watchType 1 开启文档、0 关闭文档
                if (type.equals(TYPE_ACTIVE)) {
                    messageInfo = new MessageServer.MsgInfo();
                    messageInfo.event = EVENT_PAINTH5DOC;
                    if (document != null)
                        messageInfo.h5DocView = document.getActiveView();
                } else if (type.equals(TYPE_SWITCHOFF)) {
                    messageInfo = new MessageServer.MsgInfo();
                    messageInfo.event = EVENT_SHOWH5DOC;
                    messageInfo.watchType = 0;
                    setIsUseDoc(0);
                } else if (type.equals(TYPE_SWITCHON)) {
                    messageInfo = new MessageServer.MsgInfo();
                    messageInfo.event = EVENT_SHOWH5DOC;
                    messageInfo.watchType = 1;
                    setIsUseDoc(1);
                }
                if (messageInfo != null && messageCallback != null) {
                    messageCallback.onEvent(messageInfo);
                }
            }

            //老得文档回调
            if (docEventCallback != null) {
                if (event.equals(KEY_OPERATE)) {
                    if (type.equals(TYPE_ACTIVE)) {
                        if (document != null)
                            docEventCallback.onEvent(event, type, document.getActiveView());
                    } else if (type.equals(TYPE_SWITCHOFF)) {
                        docEventCallback.onEvent(event, type, null);
                        setIsUseDoc(0);
                    } else if (type.equals(TYPE_SWITCHON)) {
                        docEventCallback.onEvent(event, type, null);
                        setIsUseDoc(1);
                    } else {
                        docEventCallback.onEvent(event, type, null);
                    }
                }
            }
        }

        @Override
        public void onError(int i, int i1, String s) {
            if (docEventCallback != null) {
                docEventCallback.onError(i, i1, s);
            }
        }
    };

    @Override
    public void setWebinarInfo(WebinarInfo webinarInfo) {
        super.setWebinarInfo(webinarInfo);
        qualities = webinarInfo.qualities;
        if (roomInfo == null) {
            if (VssRoomManager.enter) {
                roomInfo = VssRoomManager.getInstance().getRoomInfo();
                if (document == null) {
                    document = new VHOPS(roomInfo.getPaas_access_token(),context, roomInfo.getRecord_id(), roomInfo.getChannel_id());
                    document.setListener(opsListener);
                }
                VssRoomManager.getInstance().setVssMessageListener(new H5MessageChange(messageCallback, chatCallback, webinarInfo, new H5MessageChange.WebinarInfoChangeCallBack() {
                    @Override
                    public void dataChange(WebinarInfo data) {
                        setWebinarInfo(data);
                    }

                    @Override
                    public void kickedOut() {

                    }
                }));
                mPlayer = new VHVodPlayer(context);
                mPlayer.init(roomInfo.getRecord_id(), roomInfo.getPaas_access_token());
                if (surfaceView != null) {
                    mPlayer.setDisplay(surfaceView);
                } else if (vodPlayerView != null) {
                    mPlayer.setDisplay(vodPlayerView);
                } else {
                    if (listener != null)
                        listener.onEvent(ERROR_NOT_INIT, VhallSDK.mContext.getString(R.string.error_empty_play_view));
                }
                mPlayer.setListener(innerListener);
                mPlayer.setDPI(mCurrentDpi);
                mPlayer.setDrawMode(scaleType);
                mPlayer.setWaterMark(waterMarkUrl, waterMarkGravity, waterMarkAlpha);
            } else {
                if (listener != null) {
                    listener.onEvent(ERROR_NOT_INIT, VhallSDK.mContext.getString(R.string.error_video_msg_init));
                }
            }
        }
        waterMarkUrl = webinarInfo.watermark.imgUrl;
        waterMarkGravity = webinarInfo.watermark.imgPosition;
        waterMarkAlpha = webinarInfo.watermark.imgAlpha;
    }

    @Override
    public void setDefinition(String dpi) {
        mCurrentDpi = dpi;
        if (mPlayer == null) {
            start();
        } else {
            mPlayer.setDPI(mCurrentDpi);
        }
    }

    @Override
    public void start() {
        if (roomInfo == null) {
            if (listener != null)
                listener.onError(ERROR_NOT_INIT, 0, context.getString(R.string.error_video_msg_init));
            return;
        }
        if (mPlayer == null) {
            mPlayer = new VHVodPlayer(context);
            mPlayer.init(roomInfo.getRecord_id(), roomInfo.getPaas_access_token());
            if (surfaceView != null) {
                mPlayer.setDisplay(surfaceView);
            } else if (vodPlayerView != null) {
                mPlayer.setDisplay(vodPlayerView);
            }
            mPlayer.setListener(innerListener);
            mPlayer.setDPI(mCurrentDpi);
            mPlayer.setDrawMode(scaleType);
            mPlayer.setWaterMark(waterMarkUrl, waterMarkGravity, waterMarkAlpha);
            mPlayer.start();
        } else {
            mPlayer.start();
        }
    }

    @Override
    public void onPause() {
        if (mPlayer != null) {
            mPlayer.pause();
        }
    }

    @Override
    public void onResume() {
        if (mPlayer != null) {
            mPlayer.resume();
        }
    }

    @Override
    public void stop() {
        if (mPlayer != null) {
            mPlayer.stop();
        }
    }

    @Override
    public void destroy() {
        if (mPlayer != null) {
            mPlayer.release();
        }
        mPlayer = null;
        if (timer != null) {
            timer.cancel();
        }
        mDelivery.removeMessages(0);
        VssRoomManager.leaveRoom();
        flag = false;
    }

    @Override
    public float setSpeed(float speed) {
        if (mPlayer != null) {
            return mPlayer.setSpeed(speed);
        }
        return 0;
    }

    @Override
    public boolean setVideoBackgroundColor(int color) {
        if (listener != null)
            listener.onError(ERROR_NO_SUPPORT, 0, VhallSDK.mContext.getString(R.string.error_no_support));

        return false;
    }

    @Override
    public boolean setVideoBackgroundImage(Bitmap bitmap) {
        if (listener != null)
            listener.onError(ERROR_NO_SUPPORT, 0, VhallSDK.mContext.getString(R.string.error_no_support));

        return false;
    }
    @Override
    public boolean takeVideoScreenshot(VHVideoPlayerView.ScreenShotCallback callback) {
        if (listener != null)
            listener.onError(ERROR_NO_SUPPORT, 0, VhallSDK.mContext.getString(R.string.error_no_support));

        return false;
    }
    @Override
    public void startPlay(String url) {
        if (roomInfo == null) {
            if (listener != null)
                listener.onError(ERROR_NOT_INIT, 0, context.getString(R.string.error_video_msg_init));
            return;
        }
        releasePlayer();
        if (mPlayer == null) {
            mPlayer = new VHVodPlayer(context);
            mPlayer.init(roomInfo.getRecord_id(), roomInfo.getPaas_access_token());
            mPlayer.setListener(innerListener);
            if (surfaceView != null) {
                mPlayer.setDisplay(surfaceView);
            } else {
                mPlayer.setDisplay(vodPlayerView);
            }
        }
        mPlayer.setWaterMark(waterMarkUrl, waterMarkGravity, waterMarkAlpha);
        mPlayer.startPlay(url);
        if (mSavePlayerPoint != 0) {
            mPlayer.seekto(mSavePlayerPoint);
            if (document != null) {
                document.seekTo(mSavePlayerPoint);
            }
        }
    }

    @Override
    public void releasePlayer() {
        try {
            if (mPlayer != null) {
                mSavePlayerPoint = mPlayer.getPosition();
                mPlayer.release();
                mPlayer = null;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public long getCurrentPosition() {
        if (mPlayer != null) {
            return mPlayer.getPosition();
        }
        return 0;
    }

    @Override
    public long getDuration() {
        if (mPlayer != null) {
            return mPlayer.getDuration();
        }
        return 0;
    }

    @Override
    public void seekTo(long position) {
        if (mPlayer != null) {
            mPlayer.seekto(position);
        }
        if (document != null) {
            document.seekTo(position);
        }
    }

    @Override
    public Constants.State getPlayerState() {
        if (mPlayer != null) {
            return mPlayer.getState();
        }
        return Constants.State.NONE;
    }

    @Override
    public void initWH(int width, int height) {

    }

    @Override
    public String getOriginalUrl() {
        if (webinarInfo.getCast_screen() == 1 && mPlayer != null) {
            return mPlayer.getOriginalUrl();
        }
        return null;
    }

    @Override
    public void sendComment(String content, final RequestCallback callback) {
        VssRoomManager.getInstance().sendMsg(content, "", new CallBack() {
            @Override
            public void onSuccess(Object result) {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callback != null) {
                    callback.onError(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void requestCommentHistory(String webinar_id, int limit, int pos, final ChatServer.ChatRecordCallback chatRecordCallback) {
        VssChatManager.getInstance().chatLists(String.valueOf(pos), String.valueOf(limit), "", new vhall.com.vss2.CallBack<List<ResponseChatInfo>>() {
            @Override
            public void onSuccess(List<ResponseChatInfo> result) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onDataLoaded(VhallNetApiFactory.createChatApi().chatHistoryOld(result));
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onFailed(eventCode, msg);
                }
            }
        });

    }

    @Override
    public void requestCommentHistory(String webinar_id, int limit, int page, String msgId, String anchor_path, String is_role, final ChatServer.ChatRecordCallback chatRecordCallback) {
        if (chatRecordCallback != null) {
            chatRecordCallback.onFailed(ErrorCode.ERROR_NO_SUPPORT, VhallSDK.mContext.getString(R.string.error_no_support));
        }
    }
}
