package com.vhall.business;

import static com.vhall.business.ErrorCode.ERROR_INIT;
import static com.vhall.business.ErrorCode.ERROR_LOGIN_MORE;
import static com.vhall.business.MessageServer.EVENT_PAINTH5DOC;
import static com.vhall.business.MessageServer.EVENT_SHOWH5DOC;
import static com.vhall.ops.VHOPS.ERROR_DOC_INFO;
import static com.vhall.ops.VHOPS.ERROR_SEND;
import static com.vhall.ops.VHOPS.KEY_OPERATE;
import static com.vhall.ops.VHOPS.TYPE_ACTIVE;
import static com.vhall.ops.VHOPS.TYPE_SWITCHOFF;
import static com.vhall.ops.VHOPS.TYPE_SWITCHON;
import static com.vhall.player.Constants.Event.EVENT_DPI_LIST;

import android.graphics.Bitmap;
import android.text.TextUtils;

import com.vhall.business.common.LogReportKs;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.impl.VhallNetApiFactory;
import com.vhall.business.utils.DocWatermarkHelper;
import com.vhall.lss.play.VHLivePlayer;
import com.vhall.message.ConnectServer;
import com.vhall.ops.VHOPS;
import com.vhall.player.Constants;
import com.vhall.player.VHPlayerListener;
import com.vhall.player.marquee.VHMarqueeConfig;
import com.vhall.player.stream.play.impl.VHVRVideoPlayerView;
import com.vhall.player.stream.play.impl.VHVideoPlayerView;
import com.vhall.vhss.CallBack;
import com.vhall.vhss.data.ChatListData;
import com.vhall.vhss.data.WebinarInfoData;
import com.vhall.vhss.network.ChatNetworkRequest;
import com.vhall.vhss.network.InteractNetworkRequest;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import vhall.com.vss2.module.room.callback.IVssCallBackListener;

/**
 * Created by zwp on 2018/12/26
 */
class WatchLiveH5New extends Live {
    private static final String TAG = "WatchLiveH5";
    private VHLivePlayer mPlayer;
    private WebinarInfoData roomInfo;
    protected VHOPS vhops;
    private H5MessageChange iMessageListener;

    @Override
    public String getDefinition() {
        if (mPlayer != null) {
            return mPlayer.getDpi();
        }
        return "";
    }

    @Override
    public void setDefinition(String definition) {
        if (mPlayer != null) {
            mPlayer.setDPI(definition);
        }
    }

    @Override
    public boolean isPlaying() {
        if (mPlayer != null) {
            return mPlayer.isPlaying();
        }
        return false;
    }

    @Override
    public void mute() {
        if (null != mPlayer) {
            mPlayer.mute();
        }
    }

    @Override
    public void unMute() {
        if (null != mPlayer) {
            mPlayer.unmute();
        }
    }

    @Override
    public void setPCSwitchDefinition() {
        if (mPlayer != null) {
            mPlayer.pushMsgInfo();
        }
    }

    private IVssCallBackListener iVssCallBackListener = new IVssCallBackListener() {
        @Override
        public void onStateChanged(ConnectServer.State state, int i) {
            //todo vss 层能否分开反馈
            switch (state) {
                case STATE_CONNECTED:
                    if (chatCallback != null) {
                        chatCallback.onChatServerConnected();
                    }
                    break;
                case STATE_CONNECTIONG:
                    //连接中
                    break;
                case STATE_DISCONNECT:
                    if (chatCallback != null) {
                        chatCallback.onChatServerClosed();
                    }
                    break;
                case STATE_KICK_OFF:
                    //用户链接的消息服务被踢出，无法继续接收消息。需要根据业务需求进行处理。
                    if(chatCallback != null){
                        chatCallback.onChatServerKickOff();
                    }
                    break;
                default:
                    break;
            }
        }

        @Override
        public void onError(int code, String msg) {
            if (chatCallback != null) {
                chatCallback.onConnectFailed();
            }
        }
    };


    @Override
    protected void setWebinarInfo(final WebinarInfo webinarInfo) {
        super.setWebinarInfo(webinarInfo);
        if (roomInfo == null) {
            roomInfo = webinarInfo.getWebinarInfoData();
            if (roomInfo != null) {
                if (listener != null) {
                    //如果是以主持人身份进入云导播房间 直接提示进入成功
                    if (roomInfo.webinar.type == 1 || judgeHostDirector()) {
                    } else {
                        /**
                         * 当前房间不在直播状态
                         */
                        int ERROR_STATUS = -0x11;
                        listener.onError(ERROR_STATUS, ERROR_STATUS, context.getString(R.string.no_playing));
                    }
                }
                initIM();
                initDoc();
            } else {
                if (listener != null) {
                    listener.onEvent(ERROR_NOT_INIT, VhallSDK.mContext.getString(R.string.error_video_msg_init));
                }
                return;
            }
        } else {
            return;
        }
        VR = webinarInfo.is_publish_vr == 1;
        waterMarkUrl = webinarInfo.watermark.imgUrl;
        waterMarkGravity = webinarInfo.watermark.imgPosition;
        waterMarkAlpha = webinarInfo.watermark.imgAlpha;
        //提前设置播放器
        if (mPlayer == null) {
            if (videoContainer != null) {
                initWH(videoContainer.getWidth(), videoContainer.getHeight());
            } else {
                if (listener != null)
                    listener.onEvent(ERROR_NOT_INIT, VhallSDK.mContext.getString(R.string.error_empty_play_view));
            }
            mPlayer = new VHLivePlayer.Builder()
                    .videoPlayer(this.videoView)
                    .bufferSeconds(this.buffSeconds)
                    .connectTimeout(this.connectTimeout)
                    .listener(innerListener)
                    .build();
            mPlayer.setDefaultRealtimeSubtitle(true);//设置默认开启实时字幕
        }

        if (videoView != null && videoView instanceof VHVideoPlayerView) {
            VHMarqueeConfig config = new VHMarqueeConfig();
            config.enable = roomInfo.scrollInfoData.scrolling_open;
            config.interval = roomInfo.scrollInfoData.interval;
            config.speed=roomInfo.scrollInfoData.speed;
            config.color=roomInfo.scrollInfoData.color;
            config.alpha=roomInfo.scrollInfoData.alpha;
            config.size=roomInfo.scrollInfoData.size;
            config.displayType = roomInfo.scrollInfoData.scroll_type;
            config.position = roomInfo.scrollInfoData.position;
            config.text = roomInfo.scrollInfoData.text;
            ((VHVideoPlayerView)videoView).editMarquee(config);
        }

        if (listener != null)
            listener.onEvent(EVENT_INIT_PLAYER_SUCCESS, context.getString(R.string.event_init_play_success));

    }

    //如果是以主持人身份进入云导播房间 直接提示进入成功

    private boolean judgeHostDirector() {
        return TextUtils.equals("1", webinarInfo.role_name) && webinarInfo.is_director == 1;
    }

    private void initDoc() {
        if (vhops == null) {
            vhops = new VHOPS(context, roomInfo.interact.channel_id, roomInfo.interact.room_id, roomInfo.interact.paas_access_token);
            if (DocWatermarkHelper.isDocWatermarkEnable(webinarInfo)) {
                vhops.setWatermark(DocWatermarkHelper.makeWatermarkOption(webinarInfo.watermark));
            }
            vhops.setListener(opsListener);
            vhops.join();
        }
    }

    private void initIM() {
        //每次观看直播进入活动 则清除之前的消息链接
        NewH5ImManager.getInstance().leaveRoom();
        //添加消息监听
        NewH5ImManager.getInstance().enterRoom(roomInfo);
        if (iMessageListener == null)
            iMessageListener = new H5MessageChange(messageCallback, chatCallback, webinarInfo, new H5MessageChange.WebinarInfoChangeCallBack() {
                @Override
                public void dataChange(WebinarInfo data) {
                    setWebinarInfo(data);
                }

                @Override
                public void kickedOut() {
                    if (listener != null) {
                        listener.onEvent(ERROR_LOGIN_MORE, VhallSDK.mContext.getString(R.string.error_login_more));
                    }

                }
            });
        NewH5ImManager.getInstance().setMessageListener(iMessageListener);
        NewH5ImManager.getInstance().setVssCallBackListener(iVssCallBackListener);
    }

    private VHOPS.EventListener opsListener = new VHOPS.EventListener() {
        @Override
        public void onEvent(String event, String type, String cid) {
            if (event.equals(KEY_OPERATE)) {
                MessageServer.MsgInfo messageInfo = null;
                //watchType 1 开启文档、0 关闭文档
                if (type.equals(TYPE_ACTIVE)) {
                    messageInfo = new MessageServer.MsgInfo();
                    messageInfo.event = EVENT_PAINTH5DOC;
                    messageInfo.h5DocView = vhops.getActiveView();
                } else if (type.equals(TYPE_SWITCHOFF)) {
                    messageInfo = new MessageServer.MsgInfo();
                    messageInfo.event = EVENT_SHOWH5DOC;
                    messageInfo.watchType = 0;
                } else if (type.equals(TYPE_SWITCHON)) {
                    messageInfo = new MessageServer.MsgInfo();
                    messageInfo.event = EVENT_SHOWH5DOC;
                    messageInfo.watchType = 1;
                }
                if (messageInfo != null && messageCallback != null) {
                    messageCallback.onEvent(messageInfo);
                }
            }
        }

        @Override
        public void onError(int errorCode, int innerError, String errorMsg) {
            switch (errorCode) {
                case VHOPS.ERROR_CONNECT:
                case ERROR_SEND:
                    break;
                case ERROR_DOC_INFO:
                    try {
                        JSONObject obj = new JSONObject(errorMsg);
                        String msg = obj.optString("msg");
                        String cid = obj.optString("cid");
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                default:
                    break;
            }
        }
    };

    WatchLiveH5New(WatchLive.Builder builder) {
        this.context = builder.context;
        this.videoContainer = builder.videoContainer;
        this.listener = builder.listener;
        this.videoView = builder.videoView;
        this.buffSeconds = builder.buffSeconds;
        this.connectTimeout = builder.connectTimeout;
        this.messageCallback = builder.messageCallback;
        this.chatCallback = builder.chatCallback;
        //容器非空时，如videoView 为null 自动创建
    }

    private VHPlayerListener innerListener = new VHPlayerListener() {
        @Override
        public void onStateChanged(Constants.State state) {
            if (listener != null) {
                if (state == Constants.State.START) {
                    if (vhops != null) {
                        vhops.setDealTime(mockOpsDelayTime());
                    }
                }
                listener.onStateChanged(state);
            }
        }

        @Override
        public void onEvent(int event, String msg) {
            if (event == EVENT_DPI_LIST) {
                try {
                    JSONArray array = new JSONArray(msg);
                    if (array.length() > 0) {
                        for (int i = 0; i < array.length(); i++) {
                            String key = (String) array.opt(i);
                            switch (key) {
                                case "A":
                                case "a":
                                    webinarInfo.A.valid = 1;
                                    break;
                                case "SD":
                                case "360p":
                                    webinarInfo.SD.valid = 1;
                                    break;
                                case "HD":
                                case "480p":
                                    webinarInfo.HD.valid = 1;
                                    break;
                                case "UHD":
                                case "720p":
                                    webinarInfo.UHD.valid = 1;
                                    break;
                                default:
                                    break;
                            }
                        }
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (listener != null) {
                listener.onEvent(event, msg);
            }
        }

        @Override
        public void onError(int i, int i1, String s) {
            if (listener != null) {
                listener.onError(i, i1, s);
            }
        }
    };

    @Override
    public void start() {
        if (!isAvaliable()) {
            if (listener != null)
                listener.onError(ERROR_NOT_INIT, 0, context.getString(R.string.error_video_msg_init));
            return;
        }
        //如果是以主持人身份进入云导播房间 直接拉流
        if (webinarInfo.status != WebinarInfo.LIVE && !(TextUtils.equals("1", webinarInfo.role_name) && webinarInfo.is_director == 1)) {
            if (listener != null)
                listener.onError(ERROR_STATE, 0, String.format(context.getString(R.string.playing_status), webinarInfo.getStatusStr()));
            return;
        }
        if (mPlayer == null) {
            if (videoContainer != null) {
                initWH(videoContainer.getWidth(), videoContainer.getHeight());
            }
            mPlayer = new VHLivePlayer.Builder()
                    .videoPlayer(this.videoView)
                    .bufferSeconds(this.buffSeconds)
                    .connectTimeout(this.connectTimeout)
                    .reconnectTimes(3)
                    .listener(innerListener)
                    .build();
            mPlayer.setDefaultRealtimeSubtitle(true);//设置默认开启实时字幕
        }
        if (mPlayer != null && roomInfo != null) {
            if (mPlayer.isPlaying()) {
                return;
            }
            mPlayer.start(roomInfo.interact.room_id, roomInfo.interact.paas_access_token);
            mPlayer.setWaterMark(waterMarkUrl, waterMarkGravity, waterMarkAlpha);
        }
    }

    @Override
    public void stop() {
        if (mPlayer != null) {
            mPlayer.stop();
        }
    }

    @Override
    public void destroy() {
        releasePlayer();
        if (vhops != null) {
            vhops.leave();
        }
        NewH5ImManager.getInstance().removeMessageListener(iMessageListener);
        if (NewH5ImManager.getInstance().getMessageListenerListSize() < 1){
            NewH5ImManager.getInstance().leaveRoom();
        }

        LogReportManager.doReport(LogReportKs.K_LIVE_PLAYER_DESTROY);
    }

    @Override
    public boolean setVideoBackgroundColor(int color) {
        if (videoView != null) {
            if (videoView instanceof VHVideoPlayerView) {
                ((VHVideoPlayerView) videoView).setVideoBackgroundColor(color);
                return true;
            } else {
                if (listener != null)
                    listener.onError(ERROR_INIT, 0, VhallSDK.mContext.getString(R.string.error_video_view));
            }
        } else {
            if (listener != null)
                listener.onError(ERROR_INIT, 0, VhallSDK.mContext.getString(R.string.error_video_view));
        }
        return false;
    }

    @Override
    public boolean setVideoBackgroundImage(Bitmap bitmap) {
        if (videoView != null) {
            if (videoView instanceof VHVideoPlayerView) {
                ((VHVideoPlayerView) videoView).setVideoBackgroundImage(bitmap);
                return true;
            } else {
                if (listener != null)
                    listener.onError(ERROR_INIT, 0, VhallSDK.mContext.getString(R.string.error_video_view));
            }
        } else {
            if (listener != null)
                listener.onError(ERROR_INIT, 0, VhallSDK.mContext.getString(R.string.error_video_view));
        }
        return false;
    }

    @Override
    public boolean takeVideoScreenshot(VHVideoPlayerView.ScreenShotCallback callback) {
        if (videoView != null) {
            if (videoView instanceof VHVideoPlayerView) {
                ((VHVideoPlayerView) videoView).takeVideoScreenshot(callback);
                return true;
            } else {
                if (listener != null)
                    listener.onError(ERROR_INIT, 0, VhallSDK.mContext.getString(R.string.error_video_view));
            }
        } else {
            if (listener != null)
                listener.onError(ERROR_INIT, 0, VhallSDK.mContext.getString(R.string.error_video_view));
        }
        return false;
    }

    public boolean setLiveSubtitle(boolean open){
        if (mPlayer != null)
            mPlayer.setRealtimeSubtitle(open);
        return true;
    }

    @Override
    public void startPlay(String url) {
        if (mPlayer != null) {
            mPlayer.startPlay(url);
        }
    }

    @Override
    public void releasePlayer() {
        if (mPlayer != null) {
            mPlayer.release();
        }
    }

    @Override
    public void sendChat(String content, final RequestCallback callback) {
        NewH5ImManager.getInstance().sendMsg(content, "", new CallBack() {
            @Override
            public void onSuccess(Object result) {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callback != null) {
                    callback.onError(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void sendCustom(JSONObject content, final RequestCallback callback) {
        ChatNetworkRequest.sendCustomMessage(roomInfo.interact.room_id, roomInfo.interact.channel_id, content.toString(), new CallBack() {
            @Override
            public void onSuccess(Object result) {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callback != null) {
                    callback.onError(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void sendQuestion(String content, final RequestCallback callback) {
        if (!VhallSDK.isLogin()) {
            return;
        }

        ChatNetworkRequest.submitQuestion(roomInfo.interact.room_id, content, new CallBack() {
            @Override
            public void onSuccess(Object result) {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callback != null) {
                    callback.onError(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void onRaiseHand(String webinarId, int type, final RequestCallback callback) {
        if (!VhallSDK.isLogin()) {
            callback.onError(ErrorCode.ERROR_ISLOGIN, ErrorCode.ERROR_MSG_ISLOGIN);
            return;
        }
        if (webinarInfo == null || TextUtils.isEmpty(webinarInfo.join_id)) {
            callback.onError(ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        if (context != null) {
            LogReportManager.doReport(LogReportKs.K_LIVE_MIC_APPLY, new String[]{"micro_apply_type"}, new String[]{String.valueOf(type)});
            if (type == 1) {
                InteractNetworkRequest.apply(roomInfo.interact.room_id, new CallBack() {
                    @Override
                    public void onSuccess(Object result) {
                        if (callback != null) {
                            callback.onSuccess();
                        }
                    }

                    @Override
                    public void onError(int eventCode, String msg) {
                        if (callback != null) {
                            callback.onError(eventCode, msg);
                        }
                    }
                });
            } else {
                InteractNetworkRequest.cancelApply(roomInfo.interact.room_id, new CallBack() {
                    @Override
                    public void onSuccess(Object result) {
                        if (callback != null) {
                            callback.onSuccess();
                        }
                    }

                    @Override
                    public void onError(int eventCode, String msg) {
                        if (callback != null) {
                            callback.onError(eventCode, msg);
                        }
                    }
                });
            }
        } else {
            if (callback != null) {
                callback.onError(ErrorCode.ERROR_INIT, ErrorCode.ERROR_MSG_INIT);
            }
        }

    }

    /**
     * @param type 1接受，2拒绝，3超时失败
     */
    @Override
    public void replyInvitation(String webinarId, int type, final RequestCallback callback) {
        if (!VhallSDK.isLogin()) {
            callback.onError(ErrorCode.ERROR_ISLOGIN, ErrorCode.ERROR_MSG_ISLOGIN);
            return;
        }
        if (webinarInfo == null || TextUtils.isEmpty(webinarInfo.join_id)) {
            callback.onError(ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        if (type == 1) {
            InteractNetworkRequest.agreeInvite(roomInfo.interact.room_id, new CallBack() {
                @Override
                public void onSuccess(Object result) {
                    if (callback != null) {
                        callback.onSuccess();
                    }
                }

                @Override
                public void onError(int eventCode, String msg) {
                    if (callback != null) {
                        callback.onError(eventCode, msg);
                    }
                }
            });
        } else if (type == 2) {
            InteractNetworkRequest.rejectInvite(roomInfo.interact.room_id, new CallBack() {
                @Override
                public void onSuccess(Object result) {
                    if (callback != null) {
                        callback.onSuccess();
                    }
                }

                @Override
                public void onError(int eventCode, String msg) {
                    if (callback != null) {
                        callback.onError(eventCode, msg);
                    }
                }
            });
        }
        LogReportManager.doReport(LogReportKs.K_LIVE_MIC_FEEDBACK, new String[]{"reply_inv_type"}, new String[]{String.valueOf(type)});
    }

    @Override
    public void acquireChatRecord(int page, final ChatServer.ChatRecordCallback chatRecordCallback) {
        ChatNetworkRequest.chatGetList(roomInfo.interact.room_id, page, 20, new com.vhall.vhss.CallBack<ChatListData>() {
            @Override
            public void onSuccess(ChatListData result) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onDataLoaded(VhallNetApiFactory.createChatApi().chatHistoryNew(result));
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onFailed(eventCode, msg);
                }
            }
        });

    }


    @Override
    public void acquireChatRecord(boolean show_all, final ChatServer.ChatRecordCallback chatRecordCallback) {
        ChatNetworkRequest.chatGetList(roomInfo.interact.room_id, 1, show_all ? 100 : 20, new com.vhall.vhss.CallBack<ChatListData>() {
            @Override
            public void onSuccess(ChatListData result) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onDataLoaded(VhallNetApiFactory.createChatApi().chatHistoryNew(result));
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onFailed(eventCode, msg);
                }
            }
        });

    }

    @Override
    public void acquireChatRecord(int page, int limit, String msgId, String anchor_path, String is_role, final ChatServer.ChatRecordCallback chatRecordCallback) {
        if (limit > 100) {
            limit = 100;
        }
        if (limit < 1) {
            limit = 1;
        }

        ChatNetworkRequest.chatGetList(roomInfo.interact.room_id, page, limit, msgId, anchor_path, is_role, new com.vhall.vhss.CallBack<ChatListData>() {
            @Override
            public void onSuccess(ChatListData result) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onDataLoaded(VhallNetApiFactory.createChatApi().chatHistoryNew(result));
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onFailed(eventCode, msg);
                }
            }
        });

    }

    @Override
    public void setScaleType(int scaleType) {
        super.setScaleType(scaleType);
        if (videoView != null) {
            videoView.setDrawMode(scaleType);
        }
    }


    @Override
    public String getOriginalUrl() {
        if (webinarInfo.getCast_screen() == 1 && mPlayer != null) {
            return mPlayer.getOriginalUrl();
        }
        return null;
    }

    @Override
    public void connectChatServer() {
        //PaaS 层有自动重连机制
    }

    @Override
    public void disconnectChatServer() {
        //PaaS 层有自动重连机制
    }

    @Override
    public void connectMsgServer() {
        //PaaS 层有自动重连机制
    }

    @Override
    public void disconnectMsgServer() {
        //PaaS 层有自动重连机制

    }

    @Override
    protected void setOPSDelay(int delayMs) {
        if (null != vhops) {
            vhops.setDealTime(delayMs >= 0 ? delayMs : mockOpsDelayTime());
        }
    }

    private int mockOpsDelayTime() {
        return mPlayer.getRealityBufferTime() + 2500;
    }
}
