package com.vhall.business;

import android.graphics.Bitmap;
import android.text.TextUtils;

import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.data.source.UserInfoRepository;
import com.vhall.business.data.source.local.UserInfoLocalDataSource;
import com.vhall.business.data.source.remote.UserInfoRemoteDataSource;
import com.vhall.business.impl.VhallNetApiFactory;
import com.vhall.ims.VHIM;
import com.vhall.lss.play.VHLivePlayer;
import com.vhall.message.ConnectServer;
import com.vhall.ops.VHOPS;
import com.vhall.player.Constants;
import com.vhall.player.VHPlayerListener;
import com.vhall.player.stream.play.impl.VHVideoPlayerView;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

import vhall.com.vss2.CallBack;
import vhall.com.vss2.data.ResponseChatInfo;
import vhall.com.vss2.data.ResponseRoomInfo;
import vhall.com.vss2.module.chat.VssChatManager;
import vhall.com.vss2.module.room.VssRoomManager;
import vhall.com.vss2.module.room.callback.IVssCallBackListener;
import vhall.com.vss2.module.rtc.VssRtcManager;

import static com.vhall.business.ErrorCode.ERROR_INIT;
import static com.vhall.business.ErrorCode.ERROR_NO_SUPPORT;
import static com.vhall.business.MessageServer.EVENT_PAINTH5DOC;
import static com.vhall.business.MessageServer.EVENT_SHOWH5DOC;
import static com.vhall.ops.VHOPS.ERROR_DOC_INFO;
import static com.vhall.ops.VHOPS.ERROR_SEND;
import static com.vhall.ops.VHOPS.KEY_OPERATE;
import static com.vhall.ops.VHOPS.TYPE_ACTIVE;
import static com.vhall.ops.VHOPS.TYPE_SWITCHOFF;
import static com.vhall.ops.VHOPS.TYPE_SWITCHON;
import static com.vhall.player.Constants.Event.EVENT_DPI_LIST;
import static com.vhall.player.Constants.Event.EVENT_INIT_SUCCESS;

/**
 * Created by zwp on 2018/12/26
 */
class WatchLiveH5 extends Live {
    private static final String TAG = "WatchLiveH5";
    private VHLivePlayer mPlayer;
    private ResponseRoomInfo roomInfo;
    protected VHOPS vhops;

    @Override
    public String getDefinition() {
        if (mPlayer != null) {
            return mPlayer.getDpi();
        }
        return "";
    }

    @Override
    public void setDefinition(String definition) {
        if (mPlayer != null) {
            mPlayer.setDPI(definition);
        }
    }

    @Override
    public boolean isPlaying() {
        if (mPlayer != null) {
            return mPlayer.isPlaying();
        }
        return false;
    }

    @Override
    public void mute() {
        if (null != mPlayer) {
            mPlayer.mute();
        }
    }

    @Override
    public void unMute() {
        if (null != mPlayer) {
            mPlayer.unmute();
        }
    }

    @Override
    public void setPCSwitchDefinition() {
        if (mPlayer != null) {
            mPlayer.pushMsgInfo();
        }
    }

    private IVssCallBackListener iVssCallBackListener = new IVssCallBackListener() {
        @Override
        public void onStateChanged(ConnectServer.State state, int i) {
            //todo vss 层能否分开反馈
            switch (state) {
                case STATE_CONNECTED:
                    if (chatCallback != null) {
                        chatCallback.onChatServerConnected();
                    }
                    break;
                case STATE_CONNECTIONG:
                    //连接中
                    break;
                case STATE_DISCONNECT:
                    if (chatCallback != null) {
                        chatCallback.onChatServerClosed();
                    }
                    break;
                case STATE_KICK_OFF:
                    //用户链接的消息服务被踢出，无法继续接收消息。需要根据业务需求进行处理。
                    if(chatCallback != null){
                        chatCallback.onChatServerKickOff();
                    }
                    break;
                default:
                    break;
            }
        }

        @Override
        public void onError(int code, String msg) {
            //todo vss 层能否分开反馈
            if (chatCallback != null) {
                chatCallback.onConnectFailed();
            }
        }
    };


    @Override
    protected void setWebinarInfo(final WebinarInfo webinarInfo) {
        super.setWebinarInfo(webinarInfo);
        if (roomInfo == null && VssRoomManager.enter) {
            roomInfo = VssRoomManager.getInstance().getRoomInfo();
            if (listener != null) {
                if (roomInfo.getStatus() == 1) {
//                    listener.onEvent(EVENT_INIT_SUCCESS, context.getString(R.string.event_init_play_success));
                } else {
                    /**
                     * 当前房间不在直播状态
                     */
                    int ERROR_STATUS = -0x11;
                    listener.onError(ERROR_STATUS, ERROR_STATUS, context.getString(R.string.no_playing));
                }

                VssRoomManager.getInstance().setVssMessageListener(new H5MessageChange(messageCallback, chatCallback, webinarInfo, new H5MessageChange.WebinarInfoChangeCallBack() {
                    @Override
                    public void dataChange(WebinarInfo data) {
                        setWebinarInfo(data);
                    }

                    @Override
                    public void kickedOut() {

                    }
                }));
                VssRoomManager.getInstance().setVssCallBackListener(iVssCallBackListener);
            }
            vhops = new VHOPS(context, roomInfo.getChannel_id(), roomInfo.getRoom_id(), roomInfo.getPaas_access_token());
            vhops.setListener(opsListener);
            vhops.join();
        } else {
            return;
        }
        VR = webinarInfo.is_publish_vr == 1;
        waterMarkUrl = webinarInfo.watermark.imgUrl;
        waterMarkGravity = webinarInfo.watermark.imgPosition;
        waterMarkAlpha = webinarInfo.watermark.imgAlpha;

        //提前设置播放器
        if (mPlayer == null) {
            if (videoContainer != null) {
                initWH(videoContainer.getWidth(), videoContainer.getHeight());
            } else {
                if (listener != null)
                    listener.onEvent(ERROR_NOT_INIT, VhallSDK.mContext.getString(R.string.error_empty_play_view));
            }
            mPlayer = new VHLivePlayer.Builder()
                    .videoPlayer(this.videoView)
                    .bufferSeconds(this.buffSeconds)
                    .connectTimeout(this.connectTimeout)
                    .listener(innerListener)
                    .build();
            mPlayer.setDefaultRealtimeSubtitle(true);//设置默认开启实时字幕
        }
        if (listener != null)
            listener.onEvent(EVENT_INIT_PLAYER_SUCCESS, context.getString(R.string.event_init_play_success));
    }

    private VHOPS.EventListener opsListener = new VHOPS.EventListener() {
        @Override
        public void onEvent(String event, String type, String cid) {
            if (event.equals(KEY_OPERATE)) {
                MessageServer.MsgInfo messageInfo = null;
                //watchType 1 开启文档、0 关闭文档
                if (type.equals(TYPE_ACTIVE)) {
                    messageInfo = new MessageServer.MsgInfo();
                    messageInfo.event = EVENT_PAINTH5DOC;
                    messageInfo.h5DocView = vhops.getActiveView();
                } else if (type.equals(TYPE_SWITCHOFF)) {
                    messageInfo = new MessageServer.MsgInfo();
                    messageInfo.event = EVENT_SHOWH5DOC;
                    messageInfo.watchType = 0;
                } else if (type.equals(TYPE_SWITCHON)) {
                    messageInfo = new MessageServer.MsgInfo();
                    messageInfo.event = EVENT_SHOWH5DOC;
                    messageInfo.watchType = 1;
                }
                if (messageInfo != null && messageCallback != null) {
                    messageCallback.onEvent(messageInfo);
                }
            }
        }

        @Override
        public void onError(int errorCode, int innerError, String errorMsg) {
            switch (errorCode) {
                case VHOPS.ERROR_CONNECT:
                case ERROR_SEND:
                    break;
                case ERROR_DOC_INFO:
                    try {
                        JSONObject obj = new JSONObject(errorMsg);
                        String msg = obj.optString("msg");
                        String cid = obj.optString("cid");
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                default:
                    break;
            }
        }
    };

    WatchLiveH5(WatchLive.Builder builder) {
        this.context = builder.context;
        this.videoContainer = builder.videoContainer;
        this.listener = builder.listener;
        this.videoView = builder.videoView;
        this.buffSeconds = builder.buffSeconds;
        this.connectTimeout = builder.connectTimeout;
        this.messageCallback = builder.messageCallback;
        this.chatCallback = builder.chatCallback;
        //容器非空时，如videoView 为null 自动创建
    }

    private VHPlayerListener innerListener = new VHPlayerListener() {
        @Override
        public void onStateChanged(Constants.State state) {
            if (listener != null) {
                if (state == Constants.State.START) {
                    if (vhops != null) {
                        vhops.setDealTime(mPlayer.getRealityBufferTime() + 2500);
                    }
                }
                listener.onStateChanged(state);
            }
        }

        @Override
        public void onEvent(int event, String msg) {
            if (event == EVENT_DPI_LIST) {
                try {
                    JSONArray array = new JSONArray(msg);
                    if (array.length() > 0) {
                        for (int i = 0; i < array.length(); i++) {
                            String key = (String) array.opt(i);
                            switch (key) {
                                case "A":
                                case "a":
                                    webinarInfo.A.valid = 1;
                                    break;
                                case "SD":
                                case "360p":
                                    webinarInfo.SD.valid = 1;
                                    break;
                                case "HD":
                                case "480p":
                                    webinarInfo.HD.valid = 1;
                                    break;
                                case "UHD":
                                case "720p":
                                    webinarInfo.UHD.valid = 1;
                                    break;
                                default:
                                    break;
                            }
                        }
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (listener != null) {
                listener.onEvent(event, msg);
            }
        }

        @Override
        public void onError(int i, int i1, String s) {
            if (listener != null) {
                listener.onError(i, i1, s);
            }
        }
    };

    @Override
    public void start() {
        if (mPlayer == null) {
            if (videoContainer != null) {
                initWH(videoContainer.getWidth(), videoContainer.getHeight());
            }
            mPlayer = new VHLivePlayer.Builder()
                    .videoPlayer(this.videoView)
                    .bufferSeconds(this.buffSeconds)
                    .connectTimeout(this.connectTimeout)
                    .listener(innerListener)
                    .build();
            mPlayer.setDefaultRealtimeSubtitle(true);//设置默认开启实时字幕
        }
        if (mPlayer.isPlaying()) {
            return;
        }
        if (!isAvaliable()) {
            if (listener != null)
                listener.onError(ERROR_NOT_INIT, 0, context.getString(R.string.error_video_msg_init));
            return;
        }
        if (webinarInfo.status != WebinarInfo.LIVE) {
            if (listener != null)
                listener.onError(ERROR_STATE, 0, String.format(context.getString(R.string.playing_status), webinarInfo.getStatusStr()));
            return;
        }
        mPlayer.start(roomInfo.getRoom_id(), roomInfo.getPaas_access_token());
        mPlayer.setWaterMark(waterMarkUrl, waterMarkGravity, waterMarkAlpha);
    }

    @Override
    public void stop() {
        if (mPlayer != null) {
            mPlayer.stop();
        }
    }

    @Override
    public void destroy() {
        releasePlayer();
        if (vhops != null) {
            vhops.leave();
        }
        VssRoomManager.leaveRoom();
    }

    @Override
    public void startPlay(String url) {
        if (mPlayer != null) {
            mPlayer.startPlay(url);
        }
    }

    @Override
    public void releasePlayer() {
        if (mPlayer != null) {
            mPlayer.release();
        }
    }

    @Override
    public boolean setVideoBackgroundColor(int color) {
        if (videoView != null) {
            if (videoView instanceof VHVideoPlayerView) {
                ((VHVideoPlayerView) videoView).setVideoBackgroundColor(color);
                return true;
            } else {
                if (listener != null)
                    listener.onError(ERROR_INIT, 0, VhallSDK.mContext.getString(R.string.error_video_view));
            }
        } else {
            if (listener != null)
                listener.onError(ERROR_INIT, 0, VhallSDK.mContext.getString(R.string.error_video_view));
        }
        return false;
    }

    @Override
    public boolean setVideoBackgroundImage(Bitmap bitmap) {
        if (videoView != null) {
            if (videoView instanceof VHVideoPlayerView) {
                ((VHVideoPlayerView) videoView).setVideoBackgroundImage(bitmap);
                return true;
            } else {
                if (listener != null)
                    listener.onError(ERROR_INIT, 0, VhallSDK.mContext.getString(R.string.error_video_view));
            }
        } else {
            if (listener != null)
                listener.onError(ERROR_INIT, 0, VhallSDK.mContext.getString(R.string.error_video_view));
        }
        return false;
    }
    @Override
    public boolean takeVideoScreenshot(VHVideoPlayerView.ScreenShotCallback callback) {
        if (videoView != null) {
            if (videoView instanceof VHVideoPlayerView) {
                ((VHVideoPlayerView) videoView).takeVideoScreenshot(callback);
                return true;
            } else {
                if (listener != null)
                    listener.onError(ERROR_INIT, 0, VhallSDK.mContext.getString(R.string.error_video_view));
            }
        } else {
            if (listener != null)
                listener.onError(ERROR_INIT, 0, VhallSDK.mContext.getString(R.string.error_video_view));
        }
        return false;
    }

    @Override
    public void sendChat(String content, final RequestCallback callback) {
        VssRoomManager.getInstance().sendMsg(content, "", new CallBack() {
            @Override
            public void onSuccess(Object result) {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callback != null) {
                    callback.onError(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void sendCustom(JSONObject content, final RequestCallback callback) {
        VssRoomManager.getInstance().sendMsg(content.toString(), VHIM.TYPE_CUSTOM, new CallBack() {
            @Override
            public void onSuccess(Object result) {
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callback != null) {
                    callback.onError(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void sendQuestion(String content, RequestCallback callback) {
        if (!VhallSDK.isLogin()) {
            return;
        }

        /**
         * vss 没有问答接口
         */
        UserInfoRepository repository = UserInfoRepository.getInstance(UserInfoRemoteDataSource.getInstance(), UserInfoLocalDataSource.getInstance());
        repository.sendQuestion(VhallSDK.user.user_id, webinarInfo.webinar_id, content, callback);
    }

    @Override
    public void onRaiseHand(String webinarId, int type, final RequestCallback callback) {
        if (!VhallSDK.isLogin()) {
            callback.onError(ErrorCode.ERROR_ISLOGIN, ErrorCode.ERROR_MSG_ISLOGIN);
            return;
        }
        if (webinarInfo == null || TextUtils.isEmpty(webinarInfo.join_id)) {
            callback.onError(ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        if (context != null) {
            if (type == 1) {
                VssRtcManager.getInstance().apply(new CallBack() {
                    @Override
                    public void onSuccess(Object result) {
                        if (callback != null) {
                            callback.onSuccess();
                        }
                    }

                    @Override
                    public void onError(int eventCode, String msg) {
                        if (callback != null) {
                            callback.onError(eventCode, msg);
                        }
                    }
                });
            } else {
                VssRtcManager.getInstance().cancelApply(new CallBack() {
                    @Override
                    public void onSuccess(Object result) {
                        if (callback != null) {
                            callback.onSuccess();
                        }
                    }

                    @Override
                    public void onError(int eventCode, String msg) {
                        if (callback != null) {
                            callback.onError(eventCode, msg);
                        }
                    }
                });
            }
        } else {
            if (callback != null) {
                callback.onError(ERROR_INIT, ErrorCode.ERROR_MSG_INIT);
            }
        }

    }

    /**
     * @param type 1接受，2拒绝，3超时失败
     */
    @Override
    public void replyInvitation(String webinarId, int type, final RequestCallback callback) {
        if (!VhallSDK.isLogin()) {
            callback.onError(ErrorCode.ERROR_ISLOGIN, ErrorCode.ERROR_MSG_ISLOGIN);
            return;
        }
        if (webinarInfo == null || TextUtils.isEmpty(webinarInfo.join_id)) {
            callback.onError(ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        if (type == 1) {
            VssRtcManager.getInstance().agreeInvite(new CallBack() {
                @Override
                public void onSuccess(Object result) {
                    if (callback != null) {
                        callback.onSuccess();
                    }
                }

                @Override
                public void onError(int eventCode, String msg) {
                    if (callback != null) {
                        callback.onError(eventCode, msg);
                    }
                }
            });
        } else if (type == 2) {
            VssRtcManager.getInstance().rejectInvite(new CallBack() {
                @Override
                public void onSuccess(Object result) {
                    if (callback != null) {
                        callback.onSuccess();
                    }
                }

                @Override
                public void onError(int eventCode, String msg) {
                    if (callback != null) {
                        callback.onError(eventCode, msg);
                    }
                }
            });
        }
    }

    @Override
    public void acquireChatRecord(int page, final ChatServer.ChatRecordCallback chatRecordCallback) {
        VssChatManager.getInstance().chatLists(String.valueOf(page), "20", "", new CallBack<List<ResponseChatInfo>>() {
            @Override
            public void onSuccess(List<ResponseChatInfo> result) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onDataLoaded(VhallNetApiFactory.createChatApi().chatHistoryOld(result));
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onFailed(eventCode, msg);
                }
            }
        });

    }

    @Override
    public void acquireChatRecord(int page, int limit, String msgId, String anchor_path, String is_role, ChatServer.ChatRecordCallback chatRecordCallback) {
        if (chatRecordCallback != null) {
            chatRecordCallback.onFailed(ErrorCode.ERROR_NO_SUPPORT, VhallSDK.mContext.getString(R.string.error_no_support));
        }
    }

    @Override
    public void acquireChatRecord(boolean show_all, final ChatServer.ChatRecordCallback chatRecordCallback) {
        VssChatManager.getInstance().chatLists("1", show_all ? "200" : "20", "", new CallBack<List<ResponseChatInfo>>() {
            @Override
            public void onSuccess(List<ResponseChatInfo> result) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onDataLoaded(VhallNetApiFactory.createChatApi().chatHistoryOld(result));
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (chatRecordCallback != null) {
                    chatRecordCallback.onFailed(eventCode, msg);
                }
            }
        });

    }


    @Override
    public void setScaleType(int scaleType) {
        super.setScaleType(scaleType);
        if (videoView != null) {
            videoView.setDrawMode(scaleType);
        }
    }


    @Override
    public String getOriginalUrl() {
        if (webinarInfo.getCast_screen() == 1 && mPlayer != null) {
            return mPlayer.getOriginalUrl();
        }
        return null;
    }

    @Override
    public void connectChatServer() {
        //PaaS 层有自动重连机制
    }

    @Override
    public void disconnectChatServer() {
        //PaaS 层有自动重连机制
    }

    @Override
    public void connectMsgServer() {
        //PaaS 层有自动重连机制
    }

    @Override
    public void disconnectMsgServer() {
        //PaaS 层有自动重连机制

    }
}
