package com.vhall.business;

import static com.vhall.business.HttpDataSource.getOkHttpClient;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Base64;

import com.vhall.beautify.VHBeautifyKit;
import com.vhall.business.common.LogReportKs;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.core.IAccountApi;
import com.vhall.business.core.IActionNetApi;
import com.vhall.business.core.IChatInfoDataApi;
import com.vhall.business.core.IInteractiveNetApi;
import com.vhall.business.data.LotteryPrizeListInfo;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.RequestDataCallback;
import com.vhall.business.data.RequestDataCallbackV2;
import com.vhall.business.data.UserInfo;
import com.vhall.business.data.UserInfoData;
import com.vhall.business.data.WebinarInfo;
import com.vhall.business.data.WebinarInfoRemote;
import com.vhall.business.data.WebinarInfoRemoteDataSource;
import com.vhall.business.data.source.SurveyDataSource;
import com.vhall.business.data.source.SurveyRepository;
import com.vhall.business.data.source.UserInfoDataSource;
import com.vhall.business.data.source.UserInfoRepository;
import com.vhall.business.data.source.WebinarInfoDataSource;
import com.vhall.business.data.source.WebinarInfoRepository;
import com.vhall.business.data.source.local.UserInfoLocalDataSource;
import com.vhall.business.data.source.remote.SurveyRemoteDataSource;
import com.vhall.business.data.source.remote.UserInfoRemoteDataSource;
import com.vhall.business.impl.VhallNetApiFactory;
import com.vhall.business.utils.LogManager;
import com.vhall.business.utils.Md5Encode;
import com.vhall.business.utils.NetWorkUtil;
import com.vhall.business.utils.SignatureUtil;
import com.vhall.framework.VhallBaseSDK;
import com.vhall.jni.VhallLiveApi;
import com.vhall.logmanager.LogConstants;
import com.vhall.logmanager.LogInfo;
import com.vhall.logmanager.LogReporter;
import com.vhall.logmanager.VhallDeviceId;
import com.vhall.vhss.TokenManger;
import com.vhall.vhss.api.CoreApiConstant;
import com.vhall.vhss.api.CoreNetApi;
import com.vhall.vhss.data.CreateRecordData;
import com.vhall.vhss.data.DocListInfoData;
import com.vhall.vhss.data.FilesData;
import com.vhall.vhss.data.GiftListData;
import com.vhall.vhss.data.LotteryWinningDetailData;
import com.vhall.vhss.data.LotteryWinningUserInfoData;
import com.vhall.vhss.data.MenuListInfoData;
import com.vhall.vhss.data.NoticeListInfoData;
import com.vhall.vhss.data.QuestionHistoryListData;
import com.vhall.vhss.data.RecordChaptersData;
import com.vhall.vhss.data.RecordsData;
import com.vhall.vhss.data.RoleNameData;
import com.vhall.vhss.data.RoomToolsStatusData;
import com.vhall.vhss.data.TimerInfoData;
import com.vhall.vhss.data.VersionRollData;
import com.vhall.vhss.data.VhssUserInfoData;
import com.vhall.vhss.data.WarmInfoData;
import com.vhall.vhss.netutils.EncryptionUtil;
import com.vhall.vhss.network.ActivityNetworkRequest;
import com.vhall.vhss.network.ApiKeyConstants;
import com.vhall.vhss.network.ChatNetworkRequest;
import com.vhall.vhss.network.UserNetworkRequest;
import com.vhall.vhss.network.VersionNetworkRequest;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import okhttp3.Request;
import okhttp3.Response;
import vhall.com.vss2.CallBack;
import vhall.com.vss2.VssSdk;
import vhall.com.vss2.data.ResponseAttributes;
import vhall.com.vss2.data.ResponseRoomInfo;
import vhall.com.vss2.data.ResponseUserStatus;
import vhall.com.vss2.module.room.VssRoomManager;

public final class VhallSDK extends BaseSDKApi {
    private static final String TAG = "VhallSDK";
    private static final String META_KEY_HOST = "com.vhall.sdk.host";
    private static final String META_KEY_BU = "com.vhall.sdk.bu";
    protected static String mHOST = "https://e.vhall.com/sdk/v2/";//老H5业务层生产域名
    protected static String vhssUrl = "https://open-api.vhall.com";//化蝶业务层生产域名
    protected static String yunUrl = "";//默认为微吼云生产环境域名
    protected static String vssUrl = "";//默认为VSS生产环境域名，老H5活动
    public static String SURVEY_URL = "https://cnstatic01.e.vhall.com/questionnaire/%s.html";//老问卷使用
    // "http://cnstatic01.e.vhall.com/questionnaire/%s.html"; 正式 https://e.vhall.com
    // "http://t-alistatic01.e.vhall.com/questionnaire/%s.html"; 测试 https://t.e.vhall.com
    /**
     * 测试：//t-webinar.e.vhall.com/v3/lives/question
     * 预发布环境： //saas-live.vhall.com/v3/lives/question
     * 正式环境： //live.vhall.com/v3/lives/question
     * 正式环境： //https://test-zt.vhall.com
     */
    public static String NEW_SURVEY_URL = "https://live.vhall.com";//新问卷使用

    public static String DOMAIN = "https://e.vhall.com";//老问卷使用

    public static final int PLANTFORM = 5;//平台
    public static int BU = 0;
    public static boolean versionBall = false;
    public static String reportUrl = "https://dc.e.vhall.com";
    public static String APP_KEY = "";
    protected static String APP_SECRET_KEY = "";
    protected static String packageName = "";
    protected static String signature = "";
    public static Context mContext;
    private static String mVersion = getVersionImpl();
    public static UserInfo user = null;
    private static String mPhone = "";
    private static String mNetType = "";
    private static String mIMEI = "";
    protected static String header = "";
    public static String SURVEY_URL_FORMAT = SURVEY_URL + "?survey_id=%s&user_id=%s&domain=%s&webinar_id=%s&r=%d";
    public static String third_account_id = "";//用户登录信息

    //互动相关api
    private static IInteractiveNetApi sInteractiveInternalApi;
    private static IChatInfoDataApi chatInfoDataChange;
    private static IActionNetApi actionNetApi;
    private static IAccountApi sAccountApi;


    private VhallSDK() {
    }

    public static void setLogEnable(boolean enable) {
        LogManager.isDebug = enable;
        VhallLiveApi.EnableDebug(enable); // so 层日志
    }

    public static String getVersion() {
        return mVersion;
    }

    /**
     * 设置rsa私钥  需要init前调用
     * @param rsaPrivateKey
     */
    public static void setRsaPrivateKey(String rsaPrivateKey) {
        TokenManger.setSignType("0");
        if(rsaPrivateKey != null && rsaPrivateKey.length()>0){
            rsaPrivateKey = rsaPrivateKey.trim();
            rsaPrivateKey = rsaPrivateKey.replaceAll("-----BEGIN PRIVATE KEY-----","");
            rsaPrivateKey = rsaPrivateKey.replaceAll("-----END PRIVATE KEY-----","");
            rsaPrivateKey = rsaPrivateKey.trim();
            EncryptionUtil.USER_PRIVATE_KEY = rsaPrivateKey;
            TokenManger.setSignType("1");
        } else {
            EncryptionUtil.USER_PRIVATE_KEY = rsaPrivateKey;
        }
    }

    public static void init(Context context, String app_key, String app_secret_key) {
        init(context, app_key, app_secret_key, "");
    }

    //初始化SDK
    public static void init(Context context, String app_key, String app_secret_key, String host) {
        APP_KEY = app_key;
        APP_SECRET_KEY = app_secret_key;
        mContext = context;

        //必须先于paas 初始化 因为IMEI
        initHeader();

        //初始化微吼云
        VssSdk.getInstance().init(context, appId, getUserId(), vssUrl, yunUrl);
        //老H5 业务层域名
        if (!TextUtils.isEmpty(host)) {
            mHOST = "https://" + host + "/sdk/v2/";
        }

        //包名签名
        if (TextUtils.isEmpty(packageName)) {
            packageName = SignatureUtil.getPackageName(mContext);
        }
        if (TextUtils.isEmpty(signature)) {
            signature = SignatureUtil.getSignatureSHA1(mContext);
        }
        initUserInfo();
//        initMeta();

        /**************** 6.0化蝶配置******************/
        CoreNetApi.getNet().init(mContext, vhssUrl, "", "5");
        HashMap<String, String> hashMap = new HashMap<>();
        hashMap.put("app_key", VhallSDK.APP_KEY);
        hashMap.put("package_name", VhallSDK.packageName);
        hashMap.put("signature", VhallSDK.signature);
        hashMap.put("client_version", BuildConfig.VH_VERSION_NAME);
        CoreNetApi.getNet().setPostParams(hashMap);
        CoreApiConstant.SECRET_KEY = VhallSDK.APP_SECRET_KEY;
        /**********************************/
        initBu();

        initNetRequestInfo();

        initBeauty();
    }

    //默认设置 美颜开
    private static void initBeauty() {
        //VHBeautifyKit.getInstance().setBeautifyEnable(true);
    }

    /**
     * 初始化网络相关请求
     * 和数据转化
     */
    private static void initNetRequestInfo() {
        sInteractiveInternalApi = VhallNetApiFactory.createInteractiveApi();
        chatInfoDataChange = VhallNetApiFactory.createChatApi();
        actionNetApi = VhallNetApiFactory.createActionNetApi();
        sAccountApi = VhallNetApiFactory.createAccountApi();
    }

    //创建额外的参数
    private static Bundle createReportBundle() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("PS_V", com.vhall.framework.VhallSDK.getInstance().getVersion());
            jsonObject.put("SA_V", getVersion());
        } catch (Exception e) {
            e.printStackTrace();
        }
        Bundle bundle = new Bundle();
        bundle.putString(LogConstants.KEY_EXTRA, jsonObject.toString());
        return bundle;
    }

    private static void initHeader() {
        mPhone = Build.MANUFACTURER + Build.MODEL;
        mIMEI = getmIMEI();
        mNetType = NetWorkUtil.getNetworkType(mContext);
        header = getAtom();
    }

    //若mock=true，则不获取真实IMEI
    public static String getmIMEI() {
        if (TextUtils.isEmpty(mIMEI)) {
            mIMEI = VhallDeviceId.getVhallDeviceId(mContext, true);
        }
        return mIMEI;
    }

    private static void initBu() {
        VersionNetworkRequest.versionInitConfig(VhallSDK.APP_KEY, new com.vhall.vhss.CallBack<VersionRollData>() {
            @Override
            public void onSuccess(VersionRollData result) {
                if (result != null) {
                    if (TextUtils.isEmpty(result.bu)) {
                        BU = 0;
                    } else {
                        BU = Integer.parseInt(result.bu);
                    }
                    versionBall = TextUtils.equals("1", result.is_roll_back);
                    if (!TextUtils.isEmpty(result.data_domain) && result.data_domain.startsWith("http")) {
                        reportUrl = result.data_domain;
                    }
                }
                initLogReporter();
            }

            @Override
            public void onError(int eventCode, String msg) {
                initLogReporter();
            }
        });
    }


    private static void initLogReporter() {
        LogReporter.getInstance().init(mContext, "", mVersion, BU, VhallBaseSDK.getInstance().getAPP_ID(), getUserId());
        LogReporter.getInstance().initExtra(createReportBundle());
        //上报datahub 域名等
        LogInfo.getInstance().initStaticData(VhallBaseSDK.getInstance().getAPP_ID(),
                    VhallBaseSDK.getInstance().mIMEI, reportUrl+"/login"
                    , LogInfo.PLANTFORM_SDK, LogInfo.UNIT_SAAS);
        LogReporter.getInstance().onCollection(LogReporter.LOG_EVENT_INITSDK, null);
        LogManager.innerLog(TAG, "packageName:" + packageName + " signature:" + signature);
    }

    private static void initMeta() {
        try {
            ApplicationInfo appInfo = mContext.getPackageManager().getApplicationInfo(mContext.getPackageName(),
                    PackageManager.GET_META_DATA);
            String host = appInfo.metaData.getString(META_KEY_HOST);
            if (!TextUtils.isEmpty(host)) {
                mHOST = host;
                BU = appInfo.metaData.getInt(META_KEY_BU);
            }
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static boolean isInit() {
        return !(TextUtils.isEmpty(APP_KEY) || TextUtils.isEmpty(APP_SECRET_KEY));
    }

    private static void initUserInfo() {
        UserInfoRepository userRepository = UserInfoRepository.getInstance(UserInfoRemoteDataSource.getInstance(), UserInfoLocalDataSource.getInstance());
        userRepository.saveAppkey(mContext, APP_KEY);
        configInfoData();
    }

    //配置info data 数据
    private static void configInfoData() {
        //未登录
        UserInfoData infoData;
        if (isLogin()) {
            infoData = new UserInfoData(user.user_id, user.nick_name, user.avatar, "2", "3", "1", "0", "0", third_account_id);
            if (!TextUtils.isEmpty(user.user_id))
                VssSdk.getInstance().setUserId(user.user_id);
            com.vhall.framework.VhallSDK.getInstance().setUserInfo(infoData.toJsonString());
        }
        VssSdk.getInstance().setClient_version(BuildConfig.VH_VERSION_NAME);
    }

    public static boolean isLogin() {
        return user != null && !TextUtils.isEmpty(user.user_id);
    }


    /**
     * @param thirdId    三方用户id（必传）
     * @param userName   昵称（非必传）
     * @param headNetUrl 头像网址（非必传）
     * @param callback   返回回调
     */
    public static void loginByThirdId(String thirdId, String userName, String headNetUrl, UserInfoDataSource.UserInfoCallback callback) {
        if (TextUtils.isEmpty(thirdId) || TextUtils.isEmpty(thirdId.trim())) {
            VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        Map<String, String> map = new HashMap<>();
        map.put(ApiKeyConstants.KEY_HEAD_NET_URL, TextUtils.isEmpty(headNetUrl) ? "" : headNetUrl.trim());
        map.put(ApiKeyConstants.KEY_NICK_NAME, TextUtils.isEmpty(userName) ? "" : userName.trim());
        map.put(ApiKeyConstants.KEY_THIRD_USER_ID, thirdId.trim());
        sAccountApi.loginByThirdId(map, new LoginCallbackInternalImpl(callback, userName.trim()));
        third_account_id = thirdId.trim();
    }

    /**
     * @param userName 用户名 （必传 子账号id）
     * @param passWord 密码（必传）
     * @param callback UserInfoCallback
     */
    public static void login(String userName, String passWord, UserInfoDataSource.UserInfoCallback callback) {
        if (TextUtils.isEmpty(userName) || TextUtils.isEmpty(passWord) || TextUtils.isEmpty(userName.trim()) || TextUtils.isEmpty(passWord.trim())) {
            VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        sAccountApi.login(userName, passWord, "", new LoginCallbackInternalImpl(callback, userName));
        third_account_id = userName;
    }

    private static class LoginCallbackInternalImpl implements com.vhall.vhss.CallBack<VhssUserInfoData> {
        private UserInfoDataSource.UserInfoCallback callback;
        private String userName;

        public LoginCallbackInternalImpl(UserInfoDataSource.UserInfoCallback callback, String userName) {
            this.callback = callback;
            this.userName = userName;
        }

        @Override
        public void onSuccess(VhssUserInfoData result) {
            UserInfo userInfo = UserInfo.getUserInfo(result);
            userInfo.account = userName;
            user = userInfo;
            VssSdk.getInstance().setUserInfo(new UserInfoData(userInfo.user_id, userInfo.nick_name, userInfo.avatar, "2", "3", "1", "0", "0", third_account_id));
            //登录成功 更新data 数据
            configInfoData();
            LogReporter.getInstance().setUserid(userInfo.user_id);
            LogReporter.getInstance().onCollection(LogReporter.LOG_EVENT_INITLSS_PUSH, null);
            callback.onSuccess(userInfo);
        }

        @Override
        public void onError(int errorCode, String errorMsg) {
            LogReporter.getInstance().setErr(errorMsg);
            LogReporter.getInstance().onCollection(LogReporter.LOG_EVENT_INITLSS_PUSH, false, null);
            callback.onError(errorCode, errorMsg);
        }
    }

    public static void logout() {
        user = null;
        UserInfoRepository userRepository = UserInfoRepository.getInstance(UserInfoRemoteDataSource.getInstance(), UserInfoLocalDataSource.getInstance());
        userRepository.clearUserInfo(mContext);
        //退出登录，重置PaaS SDK UserInfo;
        configInfoData();
        UserNetworkRequest.logout(null);
        LogReportManager.doReport(LogReportKs.K_LOGOUT);
        third_account_id = "";
    }

    public static String getUserName() {
        return isLogin() ? user.account : "";
    }

    public static String getUserNickname() {
        return isLogin() ? user.nick_name : "";
    }

    public static String getUserAvatar() {
        return isLogin() ? user.avatar : "";
    }

    public static String getUserId() {
        if (isLogin()) {
            return user.user_id;
        }
        return "";
    }

    /**
     * 获取老H5活动Vss房间信息
     */
    private static void getVssRoomInfo(final RequestCallback callback, final Broadcast broadcast, final WebinarInfo webinarInfo) {
        VssRoomManager.getInstance().enterRoom(webinarInfo.vss_token, webinarInfo.vss_room_id, new CallBack<ResponseRoomInfo>() {
            @Override
            public void onSuccess(ResponseRoomInfo result) {
                broadcast.setWebinarInfo(dealVssRoomInfo(result, webinarInfo));
                if (callback != null) {
                    callback.onSuccess();
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                VhallCallback.ErrorCallback(callback, eventCode, msg);
            }
        });
    }

    private static WebinarInfo dealVssRoomInfo(ResponseRoomInfo result, WebinarInfo webinarInfo) {
        ResponseAttributes attributes = result.getAttributes();
        if (attributes != null) {
            webinarInfo.hands_up = attributes.getIs_handsup();
            if (TextUtils.isEmpty( webinarInfo.hands_up)){
                webinarInfo.hands_up="0";
            }
        }
        if (!VhallSDK.isLogin()) {
            VssSdk.getInstance().setUserId(result.getThird_party_user_id());
        } else {
            ResponseUserStatus userStatus = result.getUserStatus();
            if (userStatus != null && !TextUtils.isEmpty(userStatus.getIs_banned())) {
                webinarInfo.chatforbid = "1".equals(userStatus.getIs_banned());
                webinarInfo.chatOwnForbid = "1".equals(userStatus.getIs_banned());
            }
            if (attributes != null && !TextUtils.isEmpty(attributes.getAll_banned())) {
                webinarInfo.chatforbid = "1".equals(attributes.getAll_banned()) || webinarInfo.chatforbid;
                webinarInfo.chatAllForbid = "1".equals(attributes.getAll_banned());
            }
            webinarInfo.nick_name = VhallSDK.getUserName();
        }
        return webinarInfo;
    }

    /**
     * @param id          活动ID
     * @param accessToken 参会TOKEN
     * @param nickName    昵称 //可空
     * @param broadcast   {@link Broadcast}
     * @param callback    发起callback
     */
    public static void initBroadcast(final String id, final String accessToken, String nickName, final Broadcast broadcast, final RequestCallback callback) {
        initBroadcast(id, accessToken, nickName, "", broadcast, callback);
    }

    /**
     * @param id          活动ID
     * @param accessToken 参会TOKEN
     * @param nickName    昵称 //可空
     * @param email       邮箱  //可空
     * @param broadcast   {@link Broadcast}
     * @param callback    发起callback
     */
    public static void initBroadcast(final String id, final String accessToken, String nickName, String email, final Broadcast broadcast, final RequestCallback callback) {
        if (TextUtils.isEmpty(id) || broadcast == null) {
            VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        WebinarInfoRemote.getInstance().getBroadcastWebinarInfo(id.trim(), accessToken.trim(), nickName.trim(), email.trim(), getUserId().trim(), new WebinarInfoDataSource.LoadWebinarInfoCallback() {
            @Override
            public void onWebinarInfoLoaded(String jsonStr, WebinarInfo webinarInfo) {
                if (webinarInfo.status == WebinarInfo.LIVE || webinarInfo.status == WebinarInfo.MEDIA) {
                    VhallCallback.ErrorCallback(callback, Broadcast.ERROR_PLAYING, "当前视频处在" + webinarInfo.getStatusStr() + "状态");
                } else {
                    broadcast.setWebinarInfo(webinarInfo);
                    if (callback != null) {
                        callback.onSuccess();
                    }
                }
            }

            @Override
            public void onError(int errorCode, String errorMsg) {

                if (errorCode == CoreApiConstant.ERROR_CODE_OLD_H5 || errorCode == CoreApiConstant.ERROR_CODE_OLD_FLASH) {
                    if (TextUtils.isEmpty(accessToken)) {
                        VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
                        return;
                    }
                    WebinarInfoRepository repository = WebinarInfoRepository.getInstance(WebinarInfoRemoteDataSource.getInstance());
                    repository.getBroadcastWebinarInfo(id, accessToken, getUserId(), new WebinarInfoDataSource.LoadWebinarInfoCallback() {
                        @Override
                        public void onWebinarInfoLoaded(String jsonStr, WebinarInfo webinarInfo) {//回调回mainThread
                            if (webinarInfo.status == WebinarInfo.LIVE || webinarInfo.status == WebinarInfo.MEDIA) {
                                VhallCallback.ErrorCallback(callback, Broadcast.ERROR_PLAYING, "当前视频处在" + webinarInfo.getStatusStr() + "状态");
                            } else {
                                if (!TextUtils.isEmpty(webinarInfo.vss_token)) {
                                    getVssRoomInfo(callback, broadcast, webinarInfo);
                                } else {
                                    broadcast.setWebinarInfo(webinarInfo);
                                    if (callback != null) {
                                        callback.onSuccess();
                                    }
                                }
                            }
                        }

                        @Override
                        public void onError(int errorCode, String reason) {
                            VhallCallback.ErrorCallback(callback, errorCode, reason);
                        }
                    });
                } else {
                    VhallCallback.ErrorCallback(callback, errorCode, errorMsg);
                }
            }
        });
    }


    /**
     * @param id       活动ID
     * @param seatId   机位id
     * @param callback 发起callback
     */
    public static void initDirector(final String id, final String seatId, final WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        if (TextUtils.isEmpty(id) || TextUtils.isEmpty(seatId)) {
            VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        WebinarInfoRemote.getInstance().getCloudBroadcastWebinarInfo(id.trim(), seatId.trim(), new WebinarInfoDataSource.LoadWebinarInfoCallback() {
            @Override
            public void onWebinarInfoLoaded(String jsonStr, WebinarInfo webinarInfo) {
                if (callback != null) {
                    callback.onWebinarInfoLoaded(jsonStr, webinarInfo);
                }
            }

            @Override
            public void onError(int errorCode, String errorMsg) {
                VhallCallback.ErrorCallback(callback, errorCode, errorMsg);
            }
        });
    }

    /**
     * 返回活动基础信息
     *
     * @param id 活动ID
     */
    public static void getBaseWebinarInfo(final String id, final RequestDataCallback callback) {
        WebinarInfoRemote.getInstance().getBaseWebinarInfo(id, callback);
    }


    /**
     * 获取云导播开关
     *
     * @param id 活动id
     *           云导播台状态， 0： 未开启， 1：已开启
     */
    public static void getDirectorStatus(final String id, final RequestDataCallback callback) {
        WebinarInfoRemote.getInstance().getDirectorStatus(id, callback);
    }

    /**
     * 获取直播间流状态
     *
     * @param id 活动id
     *           流状态， 1 推流中 2 未推流
     */
    public static void getDirectorStreamStatus(String id, RequestDataCallback callback) {
        WebinarInfoRemote.getInstance().getDirectorStreamStatus(id, callback);
    }

    /**
     * 设备检测状态
     *
     * @param room_id 活动id
     * @param status  设备检测状态，0未检测1可以上麦2不可以上麦
     */
    public static void setDevice(String room_id, String status, RequestCallback callBack) {
        WebinarInfoRemote.getInstance().setDevice(room_id, status, callBack);
    }

    /**
     * 占用当前云导播活动下的机位
     *
     * @param id     当前云导播活动
     * @param seatId 机位id
     */
    public static void directorSelectSeat(String id, String seatId, RequestCallback callback) {
        WebinarInfoRemote.getInstance().directorSelectSeat(id, seatId, callback);
    }

    /**
     * 获取当前云导播活动下的机位列表
     *
     * @param id 当前云导播活动
     *           <p>
     *           DirectorSeatListData
     */
    public static void getDirectorSeatList(final String id, final RequestDataCallback callback) {
        WebinarInfoRemote.getInstance().getDirectorSeatList(id, callback);
    }

    /**
     * @param id          活动ID
     * @param accessToken 参会TOKEN
     * @param nickName    昵称 //可空
     * @param callback    发起callback
     */
    public static void initBroadcast(String id, String accessToken, String nickName, WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        initBroadcast(id, accessToken, nickName, "", callback);
    }

    /**
     * 内部使用
     */
    public static void initBroadcast(String id, String accessToken, String liveToken, String nickName, String email, WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        initBroadcast(id, accessToken, liveToken, nickName, email, callback, false);
    }


    public static void initBroadcast(String id, String accessToken, String nickName, WebinarInfoDataSource.LoadWebinarInfoCallback callback, boolean onlyNewInteractive) {
        initBroadcast(id, accessToken, "", nickName, "", callback, onlyNewInteractive);
    }


    private static void initBroadcast(final String id, final String accessToken, String liveToken, String nickName, String email, final WebinarInfoDataSource.LoadWebinarInfoCallback callback, final boolean onlyNewInteractive) {
        if (TextUtils.isEmpty(id) || TextUtils.isEmpty(id.trim())) {
            VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        WebinarInfoRemote.getInstance().getBroadcastWebinarInfo(id.trim(), TextUtils.isEmpty(accessToken) ? "" : accessToken.trim(), TextUtils.isEmpty(liveToken) ? "" : liveToken, TextUtils.isEmpty(nickName) ? "" : nickName.trim(), TextUtils.isEmpty(email) ? "" : email.trim(), TextUtils.isEmpty(getUserId()) ? "" : getUserId().trim(), new WebinarInfoDataSource.LoadWebinarInfoCallback() {
            @Override
            public void onWebinarInfoLoaded(String jsonStr, WebinarInfo webinarInfo) {
                //6.7.0 同步ios 主持人可以开播 正在直播中的活动
                if (callback != null) {
                    callback.onWebinarInfoLoaded(jsonStr, webinarInfo);
                }
            }

            @Override
            public void onError(int errorCode, String errorMsg) {

                if (errorCode == CoreApiConstant.ERROR_CODE_OLD_H5 || errorCode == CoreApiConstant.ERROR_CODE_OLD_FLASH) {
                    if (onlyNewInteractive) {
                        if (callback != null) {
                            callback.onError(errorCode, errorMsg);
                        }
                        return;
                    }
                    if (TextUtils.isEmpty(accessToken)) {
                        VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
                        return;
                    }
                    WebinarInfoRepository repository = WebinarInfoRepository.getInstance(WebinarInfoRemoteDataSource.getInstance());
                    repository.getBroadcastWebinarInfo(id, accessToken, getUserId(), new WebinarInfoDataSource.LoadWebinarInfoCallback() {
                        @Override
                        public void onWebinarInfoLoaded(final String jsonStr, final WebinarInfo webinarInfo) {//回调回mainThread
                            //6.7.0 同步ios 主持人可以开播 正在直播中的活动
                            if (callback != null) {
                                if (!TextUtils.isEmpty(webinarInfo.vss_token)) {
                                    getVssRoomInfo(callback, jsonStr, webinarInfo);
                                } else {
                                    callback.onWebinarInfoLoaded(jsonStr, webinarInfo);
                                }
                            }
                        }

                        @Override
                        public void onError(int errorCode, String reason) {
                            VhallCallback.ErrorCallback(callback, errorCode, reason);
                        }
                    });
                } else {
                    VhallCallback.ErrorCallback(callback, errorCode, errorMsg);
                }
            }
        });
    }

    /**
     * @param id          活动ID
     * @param accessToken 参会TOKEN
     * @param nickName    昵称 //可空
     * @param callback    发起 callback
     * @param email       邮箱  //可空
     */
    public static void initBroadcast(final String id, final String accessToken, String nickName, String email, final WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        initBroadcast(id, accessToken, "", nickName, email, callback);
    }

    /**
     * 获取老H5活动Vss房间信息
     */
    private static void getVssRoomInfo(final WebinarInfoDataSource.LoadWebinarInfoCallback callback, final String jsonStr, final WebinarInfo webinarInfo) {
        VssRoomManager.getInstance().enterRoom(webinarInfo.vss_token, webinarInfo.vss_room_id, new CallBack<ResponseRoomInfo>() {
            @Override
            public void onSuccess(ResponseRoomInfo result) {
                if (callback != null) {
                    callback.onWebinarInfoLoaded(jsonStr, dealVssRoomInfo(result, webinarInfo));
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                VhallCallback.ErrorCallback(callback, eventCode, msg);
            }
        });
    }

    /**
     * @param id
     * @param callback
     */
    public static void startBroadcast(String id, final RequestCallback callback) {
        if (TextUtils.isEmpty(id)) {
            VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        if (NewH5ImManager.enter) {
            ActivityNetworkRequest.liveStart(id, "", "3", new com.vhall.vhss.CallBack() {
                @Override
                public void onSuccess(Object s) {
                    if (callback != null) {
                        callback.onSuccess();
                    }
                }

                @Override
                public void onError(int i, String s) {
                    if (callback != null) {
                        callback.onError(i, s);
                    }
                }
            });
        } else {
            if (callback != null) {
                callback.onError(-1, "当前活动不支持");
            }
        }

    }


    public static void finishBroadcast(String id, String accessToken, final Broadcast broadcast, final RequestCallback callback) {
        finishBroadcast(id, accessToken, broadcast, false, callback);
    }

    /**
     * @param id
     * @param accessToken
     * @param broadcast   H5 v2H5 可以为空  flash 必须存在broadcast
     * @param rehearsal   是否是彩排
     * @param callback
     */
    public static void finishBroadcast(String id, String accessToken, final Broadcast broadcast, boolean rehearsal, final RequestCallback callback) {
        if (TextUtils.isEmpty(id)) {
            VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        if (VssRoomManager.enter) {
            VssRoomManager.getInstance().roomEndLive(new CallBack<String>() {
                @Override
                public void onSuccess(String s) {
                    if (callback != null) {
                        callback.onSuccess();
                    }
                }

                @Override
                public void onError(int i, String s) {
                    if (callback != null) {
                        callback.onError(i, s);
                    }
                }
            });
        } else if (NewH5ImManager.enter) {
            ActivityNetworkRequest.liveEnd(id, "", "3", rehearsal ? "2" : "0", new com.vhall.vhss.CallBack() {
                @Override
                public void onSuccess(Object s) {
                    if (callback != null) {
                        callback.onSuccess();
                    }
                }

                @Override
                public void onError(int i, String s) {
                    if (callback != null) {
                        callback.onError(i, s);
                    }
                }
            });
        } else {
            if (broadcast != null) {
                if (TextUtils.isEmpty(accessToken)) {
                    VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
                    return;
                }
                WebinarInfoRepository repository = WebinarInfoRepository.getInstance(WebinarInfoRemoteDataSource.getInstance());
                repository.stopBroadcast(id, accessToken, callback);
                broadcast.stop();
            } else {
                VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            }
        }

    }

    /**
     * 查询观看授权
     * 没有type、verifyValue时，校验用户历史是否已经校验过，校验过则直接通过校验，否则返回错误提示信息及当前观看限制类型
     *
     * @param webinarId
     */
    public static void queryWatchAuth(String webinarId, WebinarInfoDataSource.WatchAuthQueryCallback callback) {
        if (TextUtils.isEmpty(webinarId) || TextUtils.isEmpty(webinarId.trim())) {
            VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        WebinarInfoRemote.getInstance().queryWatchAuth(webinarId, null, null, callback);
    }

    /**
     * 校验观看授权
     *
     * @param webinarId   活动id
     * @param type        0:免费（默认），1:密码，2：白名单，3：付费，4：邀请码
     * @param verifyValue type对应的值
     */
    public static void checkWatchAuth(String webinarId, String type, String verifyValue, WebinarInfoDataSource.WatchAuthCallback callback) {
        if (TextUtils.isEmpty(webinarId) || TextUtils.isEmpty(webinarId.trim())) {
            VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        WebinarInfoRemote.getInstance().checkWatchAuth(webinarId, type, verifyValue, callback);
    }

    /**
     * @param email    Nullable
     * @param nickname Nullable
     * @param watchAuth     是否进行观看限制校验，default = true
     * @param callback
     */
    public static void initWatch(String webinarId, String email, String nickname, boolean watchAuth, WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        HashMap<String, String> authConfig = new HashMap<>();
        authConfig.put("auth_model", watchAuth ? "1" : "0");
        doInitWatch(webinarId, "", email, nickname, null, -1, null, authConfig, callback);
    }

    /**
     * @param webinarId 活动id
     * @param record_id 指定回放id
     * @param email    Nullable
     * @param nickname Nullable
     * @param watchAuth     是否进行观看限制校验，default = true
     * @param callback
     */
    public static void initWatch(String webinarId, String record_id, String email, String nickname, boolean watchAuth, WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        HashMap<String, String> authConfig = new HashMap<>();
        authConfig.put("auth_model", watchAuth ? "1" : "0");
        doInitWatch(webinarId, record_id, email, nickname, null, -1, null, authConfig, callback);
    }

    public static void initWatch(String id, String email, String nickname, String password, final String k_id, WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        initWatch(id, email, nickname, password, -1, k_id, callback);
    }

    public static void initWatch(String id, String email, String nickname, String password, int status, WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        initWatch(id, email, nickname, password, status, "", callback);
    }

    /**
     * SaaS 4.0 引入 VSS 后需要先判断房间类型后才进入，因此对外开放房间信息
     *
     * @param id       活动id
     * @param email    邮箱
     * @param nickname 昵称
     * @param password 密码/K值
     * @param k_id     K_id 纯数字
     * @param status   直播状态-直播/回放
     * @param callback
     */
    public static void initWatch(final String id, final String email, final String nickname, final String password, final int status, final String k_id, final WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        doInitWatch(id, "",email, nickname, password, status, k_id, null, callback);
    }

    /**
     * SaaS 4.0 引入 VSS 后需要先判断房间类型后才进入，因此对外开放房间信息
     *
     * @param id       活动id
     * @param record_id 指定回放id
     * @param email    邮箱
     * @param nickname 昵称
     * @param password 密码/K值
     * @param k_id     K_id 纯数字
     * @param status   直播状态-直播/回放
     * @param authConfig     是否校验观看限制
     * @param callback
     */
    private static void doInitWatch(
            final String id,
            final String record_id,
            final String email,
            final String nickname,
            final String password,
            final int status,
            final String k_id,
            final HashMap<String, String> authConfig,
            final WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        if (TextUtils.isEmpty(id) || TextUtils.isEmpty(id.trim())) {
            VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        final String vhallId = getUserId();
        LogReportManager.doReport(LogReportKs.K_LIVE_PLAYER_INFO);
        WebinarInfoRemote.getInstance().getWatchWebinarInfo(
                id.trim(),
                TextUtils.isEmpty(nickname) ? "" : nickname.trim(),
                TextUtils.isEmpty(email) ? "" : email.trim(),
                TextUtils.isEmpty(password) ? "" : password.trim(),
                vhallId.trim(), record_id,
                k_id,
                authConfig,
                new WebinarInfoDataSource.LoadWebinarInfoCallback() {
            @Override
            public void onWebinarInfoLoaded(String jsonStr, WebinarInfo webinarInfo) {
                if (webinarInfo != null) {
                    String userInfoStr = com.vhall.framework.VhallSDK.getInstance().getmUserInfo();
                    if (!TextUtils.isEmpty(userInfoStr)) {
                        try {
                            JSONObject userInfo = new JSONObject(userInfoStr);
                            userInfo.put("pv", webinarInfo.pv);
                            com.vhall.framework.VhallSDK.getInstance().setUserInfo(userInfo.toString());
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                    //看直播且当前房间处于直播状态
                    if (webinarInfo.status == WebinarInfo.LIVE && status == WebinarInfo.LIVE) {
                        if (callback != null) {
                            callback.onWebinarInfoLoaded(jsonStr, webinarInfo);
                        }
                        return;
                    }
                    //看点播且当前房间状态处于点播或回放状态
                    if ((webinarInfo.status == WebinarInfo.VIDEO || webinarInfo.status == WebinarInfo.MEDIA) && (status == WebinarInfo.VIDEO || status == WebinarInfo.MEDIA)) {
                        if (callback != null) {
                            callback.onWebinarInfoLoaded(jsonStr, webinarInfo);
                        }
                        return;
                    }
                    //预告状态
                    if (webinarInfo.status == WebinarInfo.BESPEAK) {
                        if (callback != null) {
                            callback.onWebinarInfoLoaded(jsonStr, webinarInfo);
                        }
                        return;
                    }

                    // 不传状态 直接返回
                    if (status == -1) {
                        if (callback != null) {
                            callback.onWebinarInfoLoaded(jsonStr, webinarInfo);
                        }
                        return;
                    }
                    VhallCallback.ErrorCallback(callback, Watch.ERROR_STATE, String.format(VhallSDK.mContext.getString(R.string.playing_status), webinarInfo.getStatusStr()));

                }
            }

            @Override
            public void onError(int errorCode, String errorMsg) {

                if (errorCode == CoreApiConstant.ERROR_CODE_OLD_H5 || errorCode == CoreApiConstant.ERROR_CODE_OLD_FLASH) {
                    WebinarInfoRepository repository = WebinarInfoRepository.getInstance(WebinarInfoRemoteDataSource.getInstance());
                    repository.getWatchWebinarInfo(id, nickname, email, TextUtils.isEmpty(password) ? "" : password.trim(), vhallId, "", new WebinarInfoDataSource.LoadWebinarInfoCallback() {
                        @Override
                        public void onWebinarInfoLoaded(String jsonStr, WebinarInfo webinarInfo) {
                            if (webinarInfo != null) {
                                if (!TextUtils.isEmpty(webinarInfo.report_extra)) {
                                    LogInfo.getInstance().setExtraData(webinarInfo.report_extra);
                                }
                                String userInfoStr = com.vhall.framework.VhallSDK.getInstance().getmUserInfo();
                                if (!TextUtils.isEmpty(userInfoStr)) {
                                    try {
                                        JSONObject userInfo = new JSONObject(userInfoStr);
                                        userInfo.put("pv", webinarInfo.online);
                                        com.vhall.framework.VhallSDK.getInstance().setUserInfo(userInfo.toString());
                                    } catch (JSONException e) {
                                        e.printStackTrace();
                                    }
                                }
                                //看直播且当前房间处于直播状态
                                if (webinarInfo.status == WebinarInfo.LIVE && status == WebinarInfo.LIVE) {
                                    if (callback != null) {
                                        if (!TextUtils.isEmpty(webinarInfo.vss_token)) {
                                            getVssRoomInfo(callback, jsonStr, webinarInfo);
                                        } else {
                                            callback.onWebinarInfoLoaded(jsonStr, webinarInfo);
                                        }
                                    }
                                    return;
                                }
                                //看点播且当前房间状态处于点播或回放状态
                                if ((webinarInfo.status == WebinarInfo.VIDEO || webinarInfo.status == WebinarInfo.MEDIA) && (status == WebinarInfo.VIDEO || status == WebinarInfo.MEDIA)) {
                                    if (callback != null) {
                                        if (!TextUtils.isEmpty(webinarInfo.vss_token)) {
                                            getVssRoomInfo(callback, jsonStr, webinarInfo);
                                        } else {
                                            callback.onWebinarInfoLoaded(jsonStr, webinarInfo);
                                        }
                                    }
                                    return;
                                }

                                //预告状态
                                if (webinarInfo.status == WebinarInfo.BESPEAK) {
                                    if (callback != null) {
                                        if (!TextUtils.isEmpty(webinarInfo.vss_token)) {
                                            getVssRoomInfo(callback, jsonStr, webinarInfo);
                                        } else {
                                            callback.onWebinarInfoLoaded(jsonStr, webinarInfo);
                                        }
                                    }
                                    return;
                                }
                                // 不传状态 直接返回
                                if (status == -1) {
                                    if (callback != null) {
                                        if (!TextUtils.isEmpty(webinarInfo.vss_token)) {
                                            getVssRoomInfo(callback, jsonStr, webinarInfo);
                                        } else {
                                            callback.onWebinarInfoLoaded(jsonStr, webinarInfo);
                                        }
                                    }
                                    return;
                                }
                                VhallCallback.ErrorCallback(callback, Watch.ERROR_STATE, String.format(VhallSDK.mContext.getString(R.string.playing_status), webinarInfo.getStatusStr()));
                            }
                        }

                        @Override
                        public void onError(int errorCode, String reason) {
                            VhallCallback.ErrorCallback(callback, errorCode, reason);
                        }
                    });
                } else {
                    VhallCallback.ErrorCallback(callback, errorCode, errorMsg);
                }
            }
        });
    }

    /**
     * 签到
     *
     * @param webinarId 活动id
     * @param signId    签到id
     */
    public static void performSignIn(String webinarId, String signId, final RequestCallback callBack) {
        if (TextUtils.isEmpty(webinarId) || TextUtils.isEmpty(signId)) {
            VhallCallback.ErrorCallback(callBack, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        if (!isLogin()) {
            VhallCallback.ErrorCallback(callBack, ErrorCode.ERROR_ISLOGIN, ErrorCode.ERROR_MSG_ISLOGIN);
            return;
        }
        actionNetApi.performSignIn(webinarId, signId, callBack);

    }

    /**
     * 获取历史问卷列表
     *
     * @param roomId    房间id
     * @param webinarId 活动id
     * @param switchId  场次id 当前
     * @param callBack  ArrayList<SurveyInfoData>
     */
    public static void getHistorySurveyList(String switchId, String roomId, String webinarId, final RequestDataCallback callBack) {
        if (TextUtils.isEmpty(webinarId) || TextUtils.isEmpty(roomId)) {
            VhallCallback.ErrorCallback(callBack, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        if (!isLogin()) {
            VhallCallback.ErrorCallback(callBack, ErrorCode.ERROR_ISLOGIN, ErrorCode.ERROR_MSG_ISLOGIN);
            return;
        }
        actionNetApi.getHistorySurvey(switchId, roomId, webinarId, callBack);
    }

    /**
     * 观看端-检查抽奖列表接口
     *
     * @param show_all 是否需要展示所有抽奖 0-否(默认：仅展示进行中、已中奖抽奖) 1-全部抽奖 2 已中奖抽奖
     *                 <p>
     *                 返回 ArrayList<LotteryCheckData>
     */

    public static void getHistoryLotteryList(String show_all, final RequestDataCallback callBack) {
        if (!isLogin()) {
            VhallCallback.ErrorCallback(callBack, ErrorCode.ERROR_ISLOGIN, ErrorCode.ERROR_MSG_ISLOGIN);
            return;
        }
        actionNetApi.getHistoryLotteryList(show_all, callBack);
    }

    /**
     * 提交中奖信息
     *
     * @param join_id    参会ID
     * @param lottery_id 抽奖ID
     * @param name       用户昵称
     * @param phone      手机号
     * @param remark     地址备注
     * @param callBack   回调
     */
    public static void submitLotteryInfo(String join_id, String lottery_id, String name, String phone, String remark, final RequestCallback callBack) {
        if (TextUtils.isEmpty(join_id) || TextUtils.isEmpty(lottery_id) || TextUtils.isEmpty(name) || TextUtils.isEmpty(join_id.trim()) || TextUtils.isEmpty(lottery_id.trim()) || TextUtils.isEmpty(name.trim())) {
            VhallCallback.ErrorCallback(callBack, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        actionNetApi.submitLotteryInfo(join_id.trim(), lottery_id.trim(), name.trim(), TextUtils.isEmpty(phone) ? "" : phone.trim(), TextUtils.isEmpty(remark) ? "" : remark.trim(), callBack);
    }

    /**
     * 获取领奖页中奖信息列表
     *
     * @param lottery_id 抽奖ID
     * @param infoList   LotteryPrizeListInfo 为getPrizeInfo接口返回数据，新增value后数据
     * @param callBack   回调
     */
    public static void submitLotteryInfo(String lottery_id,  List<LotteryPrizeListInfo> infoList , final RequestCallback callBack) {
        if (TextUtils.isEmpty(lottery_id) || TextUtils.isEmpty(lottery_id.trim()) || infoList == null || infoList.isEmpty()) {
            VhallCallback.ErrorCallback(callBack, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }

        
        actionNetApi.submitLotteryInfo( lottery_id.trim(), infoList, callBack);
    }


    /**
     * 获取当前活动的角色信息
     *
     * @param webinar_id 活动ID
     * @param callBack   回调
     */
    public static void getRoleName(String webinar_id, final RequestDataCallback callBack) {
        if (TextUtils.isEmpty(webinar_id)) {
            VhallCallback.ErrorCallback(callBack, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        ActivityNetworkRequest.getRoleName(webinar_id, new com.vhall.vhss.CallBack<RoleNameData>() {
            @Override
            public void onSuccess(RoleNameData result) {
                if (callBack != null) {
                    callBack.onSuccess(result);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (callBack != null) {
                    callBack.onError(eventCode, msg);
                }
            }
        });
    }

    /**
     * 观看端-判断自己是否中奖
     */
    public static void lotteryCheck(final RequestDataCallback callBack) {
        actionNetApi.lotteryCheck(callBack);
    }

    /**
     * 观看端-判读当前活动是都支持显示观看协议
     */
    public static void getAgreement(String webinarId, final RequestDataCallback callBack) {
        actionNetApi.getAgreement(webinarId, callBack);
    }

    /**
     * 观看端-判读当前活动是都支持显示观看协议
     */
    public static void setUserAgreeAgreement(String webinarId, final RequestCallback callBack) {
        actionNetApi.setUserAgreeAgreement(webinarId, callBack);
        LogReportManager.doReport(LogReportKs.K_LIVE_AGREEMENT_AGREE);
    }

    /**
     * 观看端-领奖页-获取信息 - 过时v6.13.0版本 请使用 getPrizeInfo(String webinarId, String lottery_id,final RequestDataCallback callBack)
     *
     * @param webinarId 房间id
     */
    @Deprecated
    public static void getPrizeInfo(String webinarId, final RequestDataCallback callBack) {
        if (TextUtils.isEmpty(webinarId)) {
            VhallCallback.ErrorCallback(callBack, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        actionNetApi.getPrizeInfo(webinarId, callBack);
    }

    /**
     * 观看端-领奖页-获取信息
     *
     * @param webinarId 房间id
     * @param lottery_id 抽奖id
     */
    public static void getPrizeInfo(String webinarId, String lottery_id,final RequestDataCallback callBack) {
        if (TextUtils.isEmpty(webinarId)) {
            VhallCallback.ErrorCallback(callBack, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        actionNetApi.getPrizeInfo(webinarId,lottery_id, callBack);
    }

    /**
     * 观看端-领奖页-获取中奖信息
     *
     * @param room_id 房间id
     */
    public static void getLotteryWinner(String room_id, String lottery_id, final RequestDataCallback callBack) {
        if (TextUtils.isEmpty(room_id) || TextUtils.isEmpty(lottery_id)) {
            VhallCallback.ErrorCallback(callBack, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        actionNetApi.getLotteryWinner(room_id, lottery_id, callBack);
    }

    /**
     * 参加口令抽奖
     *
     * @param room_id    房间ID
     * @param lottery_id 抽奖ID
     * @param command    口令
     * @param callBack   回调
     */
    public static void joinCodeLottery(String room_id, String lottery_id, final String command, final RequestCallback callBack) {
        if (TextUtils.isEmpty(command) || TextUtils.isEmpty(lottery_id) || TextUtils.isEmpty(room_id) || TextUtils.isEmpty(command.trim()) || TextUtils.isEmpty(lottery_id.trim()) || TextUtils.isEmpty(room_id.trim())) {
            VhallCallback.ErrorCallback(callBack, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        actionNetApi.joinCodeLottery(room_id.trim(), lottery_id.trim(), command.trim(), callBack);
    }


    /**
     * 获取问卷信息
     *
     * @param survey_id 问卷ID
     * @param callback  回调
     */
    public static void getSurveyInfo(String survey_id, SurveyDataSource.SurveyInfoCallback callback) {
        if (TextUtils.isEmpty(survey_id)) {
            VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }
        SurveyRepository repository = SurveyRepository.getInstance(SurveyRemoteDataSource.getInstance());
        repository.getSurveyInfo(survey_id, callback);
    }

    public static void submitSurveyInfo(Watch watch, String surveyid, String result, RequestCallback callback) {
        if (!isLogin() || TextUtils.isEmpty(surveyid) || TextUtils.isEmpty(result)) {
            VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }

        SurveyRepository repository = SurveyRepository.getInstance(SurveyRemoteDataSource.getInstance());
        if (watch != null && watch.webinarInfo != null && !TextUtils.isEmpty(watch.webinarInfo.webinar_id)) {
            repository.submitSurveyInfo(getUserId(), watch.webinarInfo.webinar_id, surveyid, result, callback);
        } else {
            repository.submitSurveyInfo(getUserId(), "", surveyid, result, callback);
        }
    }

    public static void submitSurveyInfo(String webinar_id, String surveyid, String result, RequestCallback callback) {
        if (!isLogin() || TextUtils.isEmpty(surveyid) || TextUtils.isEmpty(result)) {
            VhallCallback.ErrorCallback(callback, ErrorCode.ERROR_PARAM, ErrorCode.ERROR_PARAM_STR);
            return;
        }

        SurveyRepository repository = SurveyRepository.getInstance(SurveyRemoteDataSource.getInstance());
        repository.submitSurveyInfo(getUserId(), webinar_id, surveyid, result, callback);
    }

    public static void getAnswerList(String webinarId, final ChatServer.ChatRecordCallback callback) {
        if (NewH5ImManager.enter) {
            ChatNetworkRequest.getQuestionHistory(NewH5ImManager.getInstance().getRoomId(), new com.vhall.vhss.CallBack<QuestionHistoryListData>() {
                @Override
                public void onSuccess(QuestionHistoryListData data) {

                    if (callback != null) {

                        callback.onDataLoaded(chatInfoDataChange.questionHistoryListDataChange(data));
                    }
                }

                @Override
                public void onError(int eventCode, String msg) {
                    if (callback != null) {
                        callback.onFailed(eventCode, msg);
                    }
                }
            });
        } else {
            WebinarInfoRepository repository = WebinarInfoRepository.getInstance(WebinarInfoRemoteDataSource.getInstance());
            repository.getAnswerList(getUserId(), webinarId, callback);
        }
    }

    public static void getToken(String secretkey, WebinarInfoDataSource.LoadWebinarInfoCallback callback) {
        WebinarInfoRepository repository = WebinarInfoRepository.getInstance(WebinarInfoRemoteDataSource.getInstance());
        String url = "http://e.vhall.com/api/vhallapi/v2/verify/access-token";
        long timemiles = System.currentTimeMillis();
        url += "?app_key=" + APP_KEY;
        url += "&auth_type=2";
        url += "&signed_at=" + timemiles;
        String sign = secretkey + "app_key" + APP_KEY + "auth_type2" + "signed_at" + timemiles + secretkey;
        sign = Md5Encode.getMD5(sign);
        url += "&sign=" + sign;
        repository.getPublishToken(url, callback);
    }

    protected static String getDispatchURL(String url, String def) {
        String result = def;
        if (TextUtils.isEmpty(url)) {
            return result;
        }
        Request request = new Request.Builder().url(url).build();
        try {
            Response response = getOkHttpClient().newCall(request).execute();
            if (response.isSuccessful()) {
                result = response.body().string();
            } else {
                result = "";
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static final String atomFormat = "cv=%s&dt=%s&pf=%s&uid=%s&cn=%s&imei=%s";

    private static String getAtom() {
        String atom = String.format(atomFormat, mVersion, mPhone, PLANTFORM, getUserId(), mNetType, mIMEI);
        Base64.encodeToString(atom.getBytes(), Base64.NO_WRAP);
        LogManager.e(TAG, "atom:" + atom + " basic64 == " + Base64.encodeToString(atom.getBytes(), Base64.NO_WRAP));
        return Base64.encodeToString(atom.getBytes(), Base64.NO_WRAP);
    }

    public void setDebugMode(boolean debugMode) {
        //日志上报
        LogReporter.getInstance().setDebug(debugMode);
        //文档
    }

    /**
     * 口令用户登录验证
     *
     * @param webinarId 活动id
     * @param password  密码
     * @param nickname  昵称
     * @param type      类型 角色（2-嘉宾，3-助理）
     *                  refer      来源 自定义渠道 目前没有用
     *                  visitorId 访客唯一标识
     */
    public static void joinWebinar(String webinarId, String password, String nickname, String type, WebinarInfoDataSource.LoadWebinarInfoCallback callBack) {
        joinWebinar(webinarId, password, nickname, "", type, callBack);
    }

    /**
     * 口令用户登录验证
     *
     * @param webinarId 活动id
     * @param password  密码
     * @param nickname  昵称
     * @param avatar    头像 可以为空
     * @param type      类型 角色（2-嘉宾，3-助理）
     *                  refer      来源 自定义渠道 目前没有用
     *                  visitorId 访客唯一标识
     */
    public static void joinWebinar(String webinarId, String password, String nickname, String avatar, String type, WebinarInfoDataSource.LoadWebinarInfoCallback callBack) {
        sInteractiveInternalApi.joinWebinar(TextUtils.isEmpty(webinarId) ? "" : webinarId.trim(), TextUtils.isEmpty(password) ? "" : password.trim(), TextUtils.isEmpty(nickname) ? "" : nickname.trim(), TextUtils.isEmpty(avatar) ? "" : avatar.trim(), TextUtils.isEmpty(type) ? "" : type.trim(), callBack);
    }

    /**
     * 口令用户登录验证
     *
     * @param room_id 房间id
     * @param isNext  是否是下一组， 0：当前组， 1：下一组
     *                返回数据 RoundUserListData
     */
    public static void getRoundUsers(String room_id, String isNext, RequestDataCallback callBack) {
        sInteractiveInternalApi.getRoundUsers(TextUtils.isEmpty(room_id) ? "" : room_id.trim(), TextUtils.isEmpty(isNext) ? "0" : isNext.trim(), callBack);
    }

    /**
     * 获取当前活动下的公告列表
     *
     * @param room_id 房间id
     * @param page    当前页面 0，1，2，3，4
     * @param limit   一页的个数
     *                返回数据 NoticeListInfoData
     */
    public static void getNoticeList(String room_id, int page, int limit, final RequestDataCallbackV2<NoticeListInfoData> callback) {
        WebinarInfoRemote.getInstance().getNoticeList(room_id, page, limit, callback);
    }


    /**
     * 观看端-查询计时器进度
     */
    public static void getTimerInfo(RequestDataCallbackV2<TimerInfoData> callback) {
        actionNetApi.getTimerInfo(callback);
    }

    /**
     * 用户点赞
     *
     * @param room_id 房间id
     * @param num     点赞次数，最多500，超过500会强制成为500
     */
    public static void userLike(String room_id, String num, RequestCallback callback) {
        actionNetApi.userLike(room_id, num, callback);
    }

    /**
     * 获取房间的点赞数量
     */
    public static void getRoomLike(String room_id, RequestDataCallbackV2<Integer> callback) {
        actionNetApi.getRoomLike(room_id, callback);
    }


    /**
     * 获取活动使用的礼物列表
     *
     * @param room_id 房间id
     */
    public static void getGiftList(String room_id, RequestDataCallbackV2<GiftListData> callback) {
        WebinarInfoRemote.getInstance().getGiftList(room_id, callback);
    }


    /**
     * 观看端_发送礼物给主持人
     *
     * @param room_id      lss
     * @param gift_id      礼物ID
     * @param channel      支付渠道 WEIXIN
     * @param service_code 支付方式 QR_PAY
     * @param open_id      当支付方式为JSAPI的时候必传
     */
    public static void sendGift(String room_id, String gift_id, String channel, String service_code, String open_id, RequestCallback callback) {
        WebinarInfoRemote.getInstance().sendGift(room_id, gift_id, channel, service_code, open_id, callback);
    }

    /**
     * 获取配置信息
     * scene_id 使用场景：1权限检测（默认1）  2获取配置项选中值
     * 活动id，1、传活动id时，返回活动id+活动创建者相关的配置项信息 2、不传活动id时，获取登录用户的配置项信息
     * 有webinar_id时，必传
     */
    public static void permissionsCheck(String webinar_id, String host_id, RequestDataCallbackV2<String> callBack) {
        WebinarInfoRemote.getInstance().getConfigList("1", webinar_id, TextUtils.isEmpty(host_id) ? "" : host_id, callBack);
    }

    /**
     * 获取文档列表
     */
    public static void getDocList(String webinar_id, String room_id, int page, int limit, String keyword, RequestDataCallbackV2<DocListInfoData> callBack) {
        WebinarInfoRemote.getDocList(webinar_id, room_id, page, limit, keyword, callBack);
    }

    /**
     * 发起端-直播结束生成回放
     * live_type 开播类型：0-正式直播（默认）；2-彩排
     */
    public static void createRecord(String webinar_id, String live_type, RequestDataCallbackV2<CreateRecordData> callBack) {
        WebinarInfoRemote.createRecord(webinar_id, live_type, callBack);
    }

    /**
     * 查询章节信息-章节打点
     * record_id saas 回放id
     */
    public static void getRecordChaptersList(String record_id, RequestDataCallbackV2<RecordChaptersData> callBack) {
        WebinarInfoRemote.getRecordChaptersList(record_id, callBack);
    }

    /**
     * 查询回放列表
     * webinar_id saas 活动id
     */
    public static void getRecordList(String webinar_id, int page, int limit, RequestDataCallbackV2<RecordsData> callBack) {
        limit = limit <= 0 ? 10 : limit;
        page  = page  <  1 ? 1 : page;
        WebinarInfoRemote.getRecordList(webinar_id, (page - 1) * limit,limit,callBack);
    }

    /**
     * 查询可下载文件列表
     *  webinar_id saas 活动id
     */
    public static void getFilesList(String webinar_id, MenuListInfoData.MenuItem menu_item, RequestDataCallbackV2<FilesData> callBack) {
        if(webinar_id == null || menu_item == null)
            return;
        WebinarInfoRemote.getFilesList(webinar_id, menu_item.id, callBack);
    }

    /**
     * 检测下载
     *
     * @param webinar_id saas 回放id
     *  http://yapi.vhall.domain/project/101/interface/api/54519
     */
    public static void getFileDownLoadUrl(String webinar_id, MenuListInfoData.MenuItem menu_item, String file_id, RequestDataCallbackV2<String> callBack) {
        if(webinar_id == null || menu_item == null || file_id == null)
            return;
        WebinarInfoRemote.getFileDownLoadUrl(webinar_id, menu_item.id, file_id, callBack);
    }

    /**
     * 获取暖场视频详情接口
     */
    public static void getWarmInfo(String webinar_id, RequestDataCallbackV2<WarmInfoData> callBack) {
        WebinarInfoRemote.getWarmInfo(webinar_id, callBack);
    }

    /**
     * 观看端-抽奖-查看之前提交过的中奖信息
     */
    public static void lotteryWinningDetail(String room_id, String lottery_id, RequestDataCallbackV2<LotteryWinningDetailData> callBack) {
        actionNetApi.lotteryWinningDetail(room_id, lottery_id, callBack);
    }

    /**
     * 观看端-抽奖-获取中奖人信息 之前提交过的
     */
    public static void lotteryWinningUserInfo(String room_id, RequestDataCallbackV2<LotteryWinningUserInfoData> callBack) {
        actionNetApi.lotteryWinningUserInfo(room_id, callBack);
    }

    /**
     * 发送验证码
     *
     * @param type     类型 手机号或者邮箱 1手机  2邮箱
     * @param data     根据type值不同，分别传手机号、邮箱
     * @param scene_id 场景ID：1账户信息-修改密码  2账户信息-修改密保手机 3账户信息-修改关联邮箱 4忘记密码-邮箱方式找回
     *                 5忘记密码-短信方式找回 6提现绑定时手机号验证 7快捷方式登录 8注册-验证码  11账号注销 12消息通知手机号填写
     */

    public static void sendCode(String type, String data, String scene_id, RequestCallback callBack) {
        sAccountApi.sendCode(type, data, scene_id, callBack);
    }

    /**
     * 微信授权场景提交手机号
     *
     * @param phone 手机号
     * @param code  验证码（非必穿 根据控制台控制）
     */

    public static void noticeWechatSubmit(String webinar_id, String phone, String code, RequestCallback callBack) {
        sAccountApi.wechatSubmit(webinar_id, phone, code, callBack);
    }

    // 获取互动房间信息
    public static void getRoomToolsState(String roomId, RequestDataCallbackV2<RoomToolsStatusData> callBack) {
        WebinarInfoRemote.getRoomToolsState(roomId, callBack);
    }

    private static String appId = "15df4d3f";//  测试："f14ed109"


    /* 私有方法
     * 获取SDK版本
     */
    private static String getVersionImpl() {
        return String.format("v%s", BuildConfig.VH_VERSION_NAME);
    }

    /*
     * 设置测试环境
     */
    public static void setPackageCheck(String pkgName, String st) {
        packageName = pkgName;
        signature = st;
    }

    /*
     * 设置扩展数据 用于测试环境配置
     * app_id 微吼云 app_id  测试："f14ed109"
     * vhss_url test01-open-api.vhall.com
     * h5_url   test01.e.vhall.com
     * vss_url  test01-vss.vhall.com
     * yun_url  test01-api.vhallyun.com
     */
    public static void setExData(String app_id,String vhss_url,String h5_url,String vss_url,String yun_url) {
        appId = TextUtils.isEmpty( app_id ) ? "15df4d3f" : app_id;
        vhssUrl = TextUtils.isEmpty( vhss_url ) ? "https://open-api.vhall.com" : vhss_url;
        mHOST = TextUtils.isEmpty( h5_url ) ? "https://e.vhall.com/sdk/v2/" : "https://" + h5_url + "/sdk/v2/";//老H5业务层域名
        vssUrl = vss_url;
        yunUrl = yun_url;
        CoreNetApi.getNet().init(mContext, vhssUrl, "", "5");
    }

    /*
     * url 老问卷使用 拼接问卷id url https://cnstatic01.e.vhall.com/questionnaire/%s.html
     *   ?survey_id=%s&user_id=%s&domain=%s&webinar_id=%s&r=%d
     * domain 老问卷使用 url 中domain参数 https://e.vhall.com
     * newdomain 化蝶问卷  https://live.vhall.com
     */
    public static void setSurveyUrl(String url, String domain, String newdomain) {
        if(!TextUtils.isEmpty(url))
            SURVEY_URL = url;
        if(!TextUtils.isEmpty(domain))
            DOMAIN = domain;
        if(!TextUtils.isEmpty(newdomain))
            NEW_SURVEY_URL = newdomain;
        SURVEY_URL_FORMAT = SURVEY_URL + "?survey_id=%s&user_id=%s&domain=%s&webinar_id=%s&r=%d";
    }

    /**
     * @param survey_id  接收到的问卷消息的问卷id
     * @param webinar_id 跟随WebinarInfo返回的webinar_id
     * @param userId     跟随WebinarInfo返回的join_id
     * @return 返回WebView可直接加载的url
     */
    public static String getSurveyUrl(String survey_id, String webinar_id, String userId) {
        return String.format(SURVEY_URL_FORMAT,
                survey_id,
                survey_id,
                TextUtils.isEmpty(userId) ? getUserId() : userId,
                DOMAIN, webinar_id, System.currentTimeMillis());
    }
}
