package com.vhall.business;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.hardware.Camera;

import com.vhall.business.common.LogReportKs;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.data.RequestCallback;
import com.vhall.business.data.WebinarInfo;
import com.vhall.lss_v2.VHV2LiveDef;
import com.vhall.lss_v2.push.IVHV2Pusher;
import com.vhall.player.VHPlayerListener;
import com.vhall.push.VHAudioCapture;
import com.vhall.push.VHLivePushConfig;
import com.vhall.push.VHLivePushFormat;
import com.vhall.push.VHVideoCaptureView;

import org.json.JSONObject;

import static com.vhall.business.common.Constants.TYPE_FLASH;
import static com.vhall.business.common.Constants.TYPE_H5;

/**
 * @author hkl
 */
abstract class Push {

    /**
     * 正在直播
     */
    public static final int ERROR_PLAYING = 20101;
    /**
     * 初始化视频信息失败
     */
    public static final int ERROR_NOT_INIT = 20102;
    /**
     * 连接服务器失败
     */
    public static final int ERROR_CONNECTE = 20105;
    /**
     * 美颜权限未开启
     */
    public static final int BEAUTY_PERMISSION = 30001;
    /**
     * 客户处理音视频采集并编码
     */
    protected boolean streamOnly;
    /**
     * 视频相关类信息保存，SaaS自有 直播inner data
     */
    protected WebinarInfo webinarInfo;
    /**
     * 视频录制
     */
    protected VHVideoCaptureView videoCapture;
    /**
     * V2 版本推流对象
     * */
    protected IVHV2Pusher vhLivePusherV2;
    /**
     * 模块化core中包路径为com.vhall.push
     */
    protected VHAudioCapture mAudioCapture;
    protected VHPlayerListener listener;
    protected ChatServer.Callback chatCallback;
    protected MessageServer.Callback messageCallback;
    protected VHLivePushConfig config;
    protected boolean denoise;
    protected boolean isBuilderV2 = false;
    protected Context mContext;
    protected boolean isMirror = false;
    protected boolean front_camera = true;
    protected String licenseUrl;
    protected String licenseKey;
    protected boolean is_audio_enable = true;
    protected boolean is_video_enable = true;

    public abstract void destroy();

    public abstract void start(RequestCallback callback);

    public void start(boolean rehearsal,RequestCallback callback){

    }

    public abstract void stop();

    public abstract void sendChat(String content, RequestCallback callback);

    public abstract void sendCustom(JSONObject content, RequestCallback callback);

    public abstract void acquireChatRecord(boolean show_all, ChatServer.ChatRecordCallback chatRecordCallback);
    /**
     * 获取当前房间聊天列表
     *
     * @param page         获取条目节点，默认为0
     * @param limit       获取条目数量，最大100
     * @param msgId      获取条目数量，聊天记录 锚点消息id,此参数存在时anchor_path 参数必须存在
     * @param anchor_path 锚点方向，up 向上查找，down 向下查找,此参数存在时 msg_id 参数必须存在
     * @param is_role     0：不筛选主办方 1：筛选主办方 默认是0
     */
    public abstract void acquireChatRecord(int page, int limit, String msgId, String anchor_path, String is_role, ChatServer.ChatRecordCallback chatRecordCallback);


    public abstract int PushAACDataTs(byte[] data, int size, int type, long timestamp);

    public abstract int PushH264DataTs(byte[] data, int size, int type, long timestamp);

    /**
     设置声音增益的大小，范围[0.0 1.0]

     @param size float 增益大小的值
     @return 0是成功，非0是失败
     */
    public abstract int setVolumeAmplificateSize(float size);

    public abstract void connectChatServer();

    public abstract void disconnectChatServer();

    protected abstract void setWebinarInfo(WebinarInfo webinarInfo);

    /**
     * 当接收到ErrorCode.ERROR_V2_DISCONNECTED事件后，需要应用判断是否重新推流。
     */
    public abstract boolean pushStream(RequestCallback callback);

    /**
     * 通过build()构造的对象切换摄像头。
     *
     * @return camerId
     */
    public int changeCamera() {
        int id = -1;
        if (Camera.getNumberOfCameras() <= 1) {
            return -1;
        }
        if (videoCapture != null) {
            id = videoCapture.switchCamera();
        }
        return id;
    }
    /**
     * 默认为前置摄像头。通过buildV2()构造的对象，切换摄像头时使用。
     * @param  frontCamera: true 切换到前置摄像头 false 后置摄像头
     */
    public void changeCameraV2(boolean frontCamera) {
        if(vhLivePusherV2!=null){
            front_camera = frontCamera;
            vhLivePusherV2.switchCamera(front_camera);
        }
    }

    /**
     * 默认为前置摄像头。通过buildV2()构造的对象，切换摄像头时使用。
     * @param  enable: true 开启摄像头 false 关闭摄像头
     */
    public boolean setVideoCapture(boolean enable){
        is_video_enable = enable;
        if(isBuilderV2){
            if(vhLivePusherV2!=null){
                if(enable){
                    vhLivePusherV2.stopVirtualCamera();
                    vhLivePusherV2.startCamera(front_camera);
                    setMirror(isMirror);
                }else{
                    vhLivePusherV2.stopCamera();
                    int largeWidth = config.screenOri == VHLivePushFormat.SCREEN_ORI_LANDSPACE ? 640 : 360;  // 自定义宽度
                    int largeHeight = config.screenOri == VHLivePushFormat.SCREEN_ORI_LANDSPACE? 360 : 640; // 自定义高度
                    try {
                        // 创建一张黑色背景的 Bitmap用黑色填充大图背景
                        Bitmap largeBitmap = Bitmap.createBitmap(largeWidth, largeHeight, Bitmap.Config.ARGB_8888);
                        Canvas canvas = new Canvas(largeBitmap);
                        canvas.drawColor(Color.BLACK);
                        if(largeBitmap != null){
                            vhLivePusherV2.startVirtualCamera(largeBitmap);
                        }
                    }
                    catch (Exception e){
                        e.printStackTrace();
                    }
                }
            }
        }else{
            if(videoCapture!=null){
                videoCapture.setEnable(enable);
            }
        }
        return is_video_enable;
    }

    /*
     * 设置前置摄像头画面镜像，用于调整前置摄像头预览镜像策略.
     * V2 版本需要使用
     * 默认为 false 前置预览画面就是推流画面
     * true 前置预览画面与推流画面镜像关系
     * 注： 使用此功能时前置预览画面与推流画面可能存在镜像关系
     */
    public void setFrontPreViewMirror(boolean preViewMirror) {
        if(this.isBuilderV2){
            if(vhLivePusherV2!=null){
                vhLivePusherV2.setRenderMirror(preViewMirror);
            }
        }else if (videoCapture != null) {
            videoCapture.setFrontPreViewMirror(preViewMirror);
        }
    }

    /**
     * 设置模式
     */
    public void setCameraDrawMode(int mode) {
        if(this.isBuilderV2){
            if(vhLivePusherV2 != null){
                if(mode == 0){
                    vhLivePusherV2.setRenderFillMode(VHV2LiveDef.VHV2LiveFillMode.VHV2LiveFillMode_Fill);
                }else if(mode == 1){
                    vhLivePusherV2.setRenderFillMode(VHV2LiveDef.VHV2LiveFillMode.VHV2LiveFillMode_Fit);
                } else if(mode == 2){
                    vhLivePusherV2.setRenderFillMode(VHV2LiveDef.VHV2LiveFillMode.VHV2LiveFillMode_ScaleFill);
                }
            }
        }else if (videoCapture != null) {
            videoCapture.setCameraDrawMode(mode);
            LogReportManager.doReport(LogReportKs.K_LIVE_DRAWMODE);
        }
    }

    /*
     * 设置镜像，同时镜像预览画面和推流画面(观看端画面)
     * 默认预览画面与推流画面均为通过镜头看到的画面
     */
    public void setMirror(boolean mirror) {
        if(this.isBuilderV2){
            vhLivePusherV2.setRenderMirror(mirror);
            if(front_camera && config.screenOri == 0){
                vhLivePusherV2.setRenderRotation(VHV2LiveDef.VHV2LiveRotation.VHV2LiveRotation0);
            }
            else if(!front_camera && config.screenOri == 0){
                vhLivePusherV2.setRenderRotation(VHV2LiveDef.VHV2LiveRotation.VHV2LiveRotation0);
            }
        }else if (videoCapture != null) {
            videoCapture.setMirror(mirror);
        }
    }

    /**
     * 切换闪光灯
     *
     * @return boolean
     */
    public boolean changeFlash(boolean isOpen) {
        try {
            if(this.isBuilderV2){
                if(vhLivePusherV2 != null){
                    return vhLivePusherV2.enableCameraTorch(isOpen);
                }
            }else if (videoCapture != null) {
                return videoCapture.changeFlash(isOpen) == isOpen;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return !isOpen;
    }

    /**
     * 是否静音
     *
     * @return
     */
    public boolean isMute() {
        boolean state = false;
        if(isBuilderV2){
            if(vhLivePusherV2!=null){
                state = is_audio_enable ? false : true;
            }
        }else{
            state = mAudioCapture.isEnable() ? false  : true;
        }
        return state;
    }

    public boolean setMute(boolean mute) {
        if(isBuilderV2){
            if(vhLivePusherV2!=null){
                int i = mute ? vhLivePusherV2.stopMicrophone() : vhLivePusherV2.startMicrophone();
                if(i == 0){
                    is_audio_enable = !mute;
                }
            }
            return  true;
        }else{
            return mAudioCapture.setEnable(!mute);
        }
    }

    /**
     * 是否已初始化
     *
     * @return
     */
    public boolean isAvaliable() {
        if (webinarInfo != null) {
            return true;
        }
        return false;
    }


    /**
     * 发直播实例构造器
     */
    static class Builder extends Broadcast.Builder {
        public Push buildPush(String type) {
            if (!streamOnly && (this.videoCapture == null || this.videoCapture.getActivity() == null)) {
                throw new IllegalArgumentException("init CameraView first...");
            }
            if (this.listener == null) {
                throw new IllegalArgumentException("Broadcast callback should not be null...");
            }
            if (this.config == null) {
                throw new IllegalArgumentException("PushConfig should not be null...");
            }
            if (this.audioCapture == null) {
                audioCapture = new VHAudioCapture();
            }
            if (TYPE_H5.equals(type)) {
                return new BroadcastH5(this);
            } else if (TYPE_FLASH.equals(type)) {
                return new BroadcastFlash(this);
            }
            return new BroadcastH5new(this);
        }
    }

}

