package com.vhall.business;

import android.widget.RelativeLayout;

import com.vhall.business.common.LogReportKs;
import com.vhall.business.common.LogReportManager;
import com.vhall.business.data.RequestCallback;
import com.vhall.player.stream.play.IVHVideoPlayer;
import com.vhall.player.stream.play.impl.VHVRVideoPlayerView;
import com.vhall.player.stream.play.impl.VHVideoPlayerView;

import org.json.JSONObject;

import java.util.HashMap;

import static com.vhall.business.common.Constants.TYPE_FLASH;
import static com.vhall.business.common.Constants.TYPE_H5;

/**
 * @author hkl
 * Date: 2020-09-16 15:30
 */
abstract class Live extends Watch {
    // FIT_DEFAULT = 0x00;FIT_CENTER_INSIDE = 0x01;FIT_X = 0x02;FIT_Y = 0x03;FIT_XY = 0x04;

    protected IVHVideoPlayer videoView;//视频渲染器
    protected int buffSeconds;
    protected int connectTimeout;

    protected int videoWidth = 0;
    protected int videoHeight = 0;

    protected boolean VR = false;
    protected int VRDrawMode = 0;
    protected boolean VRHeadTracker = false;

    protected String waterMarkUrl = "";
    protected int waterMarkGravity = 0;
    protected float waterMarkAlpha = 0;

    protected RelativeLayout videoContainer;

    public abstract String getDefinition();

    public abstract void setPCSwitchDefinition();

    public abstract void sendChat(String content, RequestCallback callback);

    public abstract void sendCustom(JSONObject content, RequestCallback callback);

    public abstract void sendQuestion(String content, RequestCallback callback);

    public abstract void onRaiseHand(String webinarId, int type, RequestCallback callback);

    public abstract void replyInvitation(String webinarId, int type, RequestCallback callback);

    public abstract void acquireChatRecord(boolean show_all, ChatServer.ChatRecordCallback chatRecordCallback);

    public abstract void acquireChatRecord(int page, ChatServer.ChatRecordCallback chatRecordCallback);

    public abstract void acquireChatRecord(int page, int limit, String msgId, String anchor_path, String is_role, ChatServer.ChatRecordCallback chatRecordCallback);


    public abstract void connectChatServer();

    public abstract void disconnectChatServer();

    public abstract void connectMsgServer();

    public abstract void disconnectMsgServer();

    public HashMap<String, Integer> getDefinitionAvailable() {
        if (webinarInfo == null) {
            return null;
        }
        HashMap<String, Integer> map = new HashMap();
        map.put("SD", webinarInfo.SD.valid);
        map.put("HD", webinarInfo.HD.valid);
        map.put("UHD", webinarInfo.UHD.valid);
        map.put("A", webinarInfo.A.valid);
        return map;
    }

    public boolean isVR() {
        return VR;
    }

    public boolean isVRHeadTracker() {
        return VRHeadTracker;
    }

    public void setVRHeadTracker(boolean VRHeadTracker) {
        this.VRHeadTracker = VRHeadTracker;
        if (videoView != null && videoView instanceof VHVRVideoPlayerView) {
            ((VHVRVideoPlayerView) videoView).setIsHeadTracker(VRHeadTracker);
        }
    }

    @Override
    public void setScaleType(final int scaleType) {
        super.setScaleType(scaleType);
        /**
         * 不添加这个 竖屏直播切换直接触发变形 目前没有发现原因
         * 8月19号
         */
        mDelivery.postDelayed(new Runnable() {
            @Override
            public void run() {
                if (videoView != null) {
                    videoView.setDrawMode(scaleType);
                }
            }
        }, 10);
    }

    /**
     * 返回当前的活动是否是互动活动
     */
    public String isInteractive() {
        if (webinarInfo == null) {
            return "";
        }
        return webinarInfo.is_interact;
    }

    /**
     * 返回当前的活动是否可以举手
     */
    public String isAllowHand() {
        if (webinarInfo == null) {
            return "";
        }
        return webinarInfo.hands_up;
    }

    /**
     * PC端是否使用文档
     *
     * @return
     */
    public boolean isUseDoc() {
        if (webinarInfo == null) {
            return true;
        }
        return webinarInfo.use_doc == 1;
    }

    /**
     * PC端是否使用白板
     *
     * @return
     */
    public boolean isUseBoard() {
        if (webinarInfo == null) {
            return false;
        }
        return webinarInfo.use_white_board == 1;
    }

    /**
     * 设置白板状态 1 打开 0 关闭
     *
     * @param state
     */
    public void setIsUseBoard(int state) {
        if (webinarInfo != null) {
            webinarInfo.use_white_board = state;
        }
    }

    /**
     * 设置文档状态状态 1 打开 0 关闭
     *
     * @param state
     */
    public void setIsUseDoc(int state) {
        if (webinarInfo != null) {
            webinarInfo.use_doc = state;
        }
    }

    public void setVRDrawMode(int vrDrawMode) {
        this.VRDrawMode = vrDrawMode;
        if (videoView != null && videoView instanceof VHVRVideoPlayerView) {
            videoView.setDrawMode(vrDrawMode);
        }
    }

    //删除这个逻辑，不判断用户传递的view宽 高
    @Override
    public void initWH(int width, int height) {

//        if (width <= 0 || height <= 0) {
//            return;
//        }
//        if (width != videoWidth || height != videoHeight) {
        videoWidth = width;
        videoHeight = height;
        if (videoView != null) {
            videoView.setDrawMode(scaleType);
        } else {
            if (VR) {
                videoView = new VHVRVideoPlayerView(context);
                videoView.setDrawMode(VRDrawMode);
                ((VHVRVideoPlayerView) videoView).setIsHeadTracker(VRHeadTracker);//设置是否开启头动 就是陀螺仪的开关
            } else {
                videoView = new VHVideoPlayerView(context);
                videoView.setDrawMode(scaleType);
            }
            videoContainer.addView((VHVideoPlayerView) videoView);
        }

    }

    /**
     * 发直播实例构造器
     */
    class Builder extends WatchLive.Builder {

        public Live buildLive(String type) {
            if (context == null) {
                throw new IllegalArgumentException("context can not be null");
            }
            if (videoContainer == null && videoView == null) {
                throw new IllegalArgumentException("containerLayout and playView can not both be null");
            }

            LogReportManager.doReport(LogReportKs.K_LIVE_PLAYER_INIT);

            if (TYPE_H5.equals(type)) {
                return new WatchLiveH5(this);

            } else if (TYPE_FLASH.equals(type)) {
                return new WatchLiveFlash(this);
            }
            return new WatchLiveH5New(this);
        }
    }

}

