package com.vhall.business;

import com.vhall.business.utils.LogManager;
import com.vhall.business.utils.Md5Encode;
import com.vhall.httpclient.utils.OKHttpUtils;

import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

/**
 * Created by huanan on 2016/9/26.
 */
public class HttpDataSource {
    private static final String TAG = "HttpDataSource";

    public static void post(String area, String api_name, HashMap<String, String> hashMap, Callback callback) {
        if (!VhallSDK.isInit()) {
            callback.onFailure(null, new IOException("init SDK first..."));
            return;
        }
        String url = VhallSDK.mHOST + area;
        hashMap.put("api_name", api_name);
        hashMap.put("app_key", VhallSDK.APP_KEY);
        hashMap.put("app_secret_key", VhallSDK.APP_SECRET_KEY);
        hashMap.put("client", "android");
        hashMap.put("package_name", VhallSDK.packageName);
        hashMap.put("signature", VhallSDK.signature);
        RequestBody body = getRequestBody(getParam(hashMap));
        post(url, body, callback);
    }

    private static HashMap<String, String> getParam(HashMap<String, String> params) {
        Object[] key = params.keySet().toArray();
        Arrays.sort(key);
        String param = "";
        for (int i = 0; i < key.length; i++) {
            param = param + key[i] + params.get(key[i]);
        }
        String sign = Md5Encode.getMD5(param);
        params.put("sign", sign);
        params.remove("api_name");
        params.remove("app_secret_key");
        params.remove("package_name");
        params.remove("signature");
        LogManager.innerLog(TAG, "param:" + param + ",sign:" + sign);
        return params;
    }

    private static RequestBody getRequestBody(HashMap<String, String> hashMap) {
        String param = "";
        FormBody.Builder builder = new FormBody.Builder();
        for (String key : hashMap.keySet()) {
            String value = hashMap.get(key) == null ? "" : hashMap.get(key);
            param = param + key + ":" + value + "\n";
            builder.add(key, value);
        }
        LogManager.innerLog(TAG, param);
        return builder.build();
    }

    static OkHttpClient mOkHttpClient;

    public static OkHttpClient getOkHttpClient() {
        if (mOkHttpClient == null) {
            mOkHttpClient = OKHttpUtils.createOkClient();
        }
        return mOkHttpClient;
    }

    public static void post(String url, RequestBody body, Callback callback) {
        Request request = new Request.Builder().addHeader("atom", VhallSDK.header).url(url).post(body).build();
        Call call = getOkHttpClient().newCall(request);
        call.enqueue(callback);
    }

    public static void get(String url, Callback callback) {
        Request request = new Request.Builder().url(url).get().build();
        Call call = getOkHttpClient().newCall(request);
        call.enqueue(callback);
    }
}